/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.service.csv.BeanIndexNullableGetter;
import fr.ifremer.tutti.service.csv.BeanNullableGetter;
import fr.ifremer.tutti.service.csv.ForeignKeyParserFormatter;
import fr.ifremer.tutti.service.csv.TuttiCsvUtil;
import java.util.List;
import java.util.Map;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;
import org.nuiton.csv.ext.AbstractImportExportModel;

public abstract class AbstractTuttiImportExportModel<M>
extends AbstractImportExportModel<M> {
    public AbstractTuttiImportExportModel(char separator) {
        super(separator);
    }

    public <E extends TuttiEntity> void newForeignKeyColumn(String propertyName, Class<E> entityType, String foreignKeyName, Map<String, E> universe) {
        this.newMandatoryColumn(propertyName, propertyName, (ValueParser)new ForeignKeyParserFormatter<E>(entityType, foreignKeyName, universe));
    }

    public <E extends TuttiEntity> void newForeignKeyColumn(String headerName, String propertyName, Class<E> entityType, String foreignKeyName, Map<String, E> universe) {
        this.newMandatoryColumn(headerName, propertyName, (ValueParser)new ForeignKeyParserFormatter<E>(entityType, foreignKeyName, universe));
    }

    public void newSpeciesForeignKeyColumn(String propertyName, List<Species> species) {
        if (species == null) {
            species = Lists.newArrayList();
        }
        Map universe = Speciess.splitReferenceSpeciesByReferenceTaxonId((Iterable)species);
        this.newMandatoryColumn(propertyName, propertyName, (ValueParser)new ForeignKeyParserFormatter<Species>(Species.class, "referenceTaxonId", universe));
    }

    public <E extends TuttiEntity> void newForeignKeyColumn(String propertyName, Class<E> entityType, List<E> list) {
        if (list == null) {
            list = Lists.newArrayList();
        }
        Map universe = TuttiEntities.splitById((Iterable)list);
        this.newMandatoryColumn(propertyName, propertyName, (ValueParser)new ForeignKeyParserFormatter<E>(entityType, "id", universe));
    }

    public <T> ExportableColumn<M, T> newNullableColumnForExport(String headerName, String propertyName, ValueFormatter<T> valueFormatter) {
        return this.modelBuilder.newColumnForExport(headerName, new BeanNullableGetter(propertyName), valueFormatter);
    }

    public ExportableColumn<M, String> newNullableColumnForExport(String headerName, String propertyName) {
        return this.newNullableColumnForExport(headerName, propertyName, (ValueFormatter)TuttiCsvUtil.STRING);
    }

    public <T> ExportableColumn<M, T> newIndexNullableColumnForExport(String headerName, String collectionName, int order, String propertyName, ValueFormatter<T> valueFormatter) {
        return this.modelBuilder.newColumnForExport(headerName, new BeanIndexNullableGetter(collectionName, order, propertyName), valueFormatter);
    }

    public ExportableColumn<M, String> newIndexNullableColumnForExport(String headerName, String collectionName, int order, String propertyName) {
        return this.newIndexNullableColumnForExport(headerName, collectionName, order, propertyName, (ValueFormatter)TuttiCsvUtil.STRING);
    }
}

