/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.BaseAggregationCalculator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.RunningFunctionCalculator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.SimpleFunctionCalculator;

public class AggregationHelper {
    private static AggregationHelper instance = new AggregationHelper();

    public static AggregationHelper getInstance() {
        return instance;
    }

    private static boolean isRunningFunction(AggregationDefinition aggrDef) throws DataException {
        AggregationFunctionDefinition[] aggregationFunction = aggrDef.getAggregationFunctions();
        if (aggregationFunction != null) {
            IAggrFunction aggregation = AggregationManager.getInstance().getAggregation(aggregationFunction[0].getFunctionName());
            if (aggregation == null) {
                throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.UnsupportedFunction")) + aggregationFunction[0].getFunctionName());
            }
            return aggregation.getType() == 1;
        }
        return false;
    }

    public static IAggregationResultSet[] execute(IAggregationResultSet aggrResultSet, AggregationDefinition[] aggregations, StopSign stopSign) throws IOException, DataException {
        IAggregationResultSet[] resultSets = new IAggregationResultSet[aggregations.length];
        int i = 0;
        while (i < aggregations.length) {
            BaseAggregationCalculator aggregationCalculator = AggregationHelper.isRunningFunction(aggregations[i]) ? new RunningFunctionCalculator(aggregations[i], aggrResultSet) : new SimpleFunctionCalculator(aggregations[i], aggrResultSet);
            resultSets[i] = aggregationCalculator.execute(stopSign);
            ++i;
        }
        return resultSets;
    }
}

