/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.bundle;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuiton.i18n.I18nUtil;

public enum I18nBundleScope {
    GENERAL("(.*/.+)\\.properties"){

        @Override
        public Locale getLocale(Matcher matcher) {
            return null;
        }
    }
    ,
    LANGUAGE("(.*/.+)_(\\w\\w)\\.properties"){

        @Override
        public Locale getLocale(Matcher matcher) {
            Locale result = null;
            if (matcher.matches()) {
                result = I18nUtil.newLocale(matcher.group(2));
            }
            return result;
        }
    }
    ,
    FULL("(.*/.+)_(\\w\\w_\\w\\w)\\.properties"){

        @Override
        public Locale getLocale(Matcher matcher) {
            Locale result = null;
            if (matcher.matches()) {
                result = I18nUtil.newLocale(matcher.group(2));
            }
            return result;
        }
    };

    private final Pattern patternAll;

    public static I18nBundleScope valueOf(Locale locale) {
        if (locale == null || locale.getLanguage() == null || locale.getLanguage().length() == 0) {
            return GENERAL;
        }
        if (locale.getCountry() == null || locale.getCountry().length() == 0) {
            return LANGUAGE;
        }
        return FULL;
    }

    public Matcher getMatcher(String path) {
        return this.patternAll.matcher(path);
    }

    public abstract Locale getLocale(Matcher var1);

    public String getBundlePrefix(Matcher matcher) {
        String result = null;
        if (matcher.matches()) {
            result = matcher.group(1);
        }
        return result;
    }

    private I18nBundleScope(String patternAll) {
        this.patternAll = Pattern.compile(patternAll);
    }
}

