/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.ArrayList;
import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.re.executor.EdgeGroup;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupUtil
implements ICrosstabConstants {
    private GroupUtil() {
    }

    public static int getGroupIndex(CrosstabReportItemHandle crosstabItem, int axisType, int dimensionIndex, int levelIndex) {
        List<EdgeGroup> groups = GroupUtil.getGroups(crosstabItem, axisType);
        if (levelIndex < 0) {
            int i = groups.size() - 1;
            while (i >= 0) {
                EdgeGroup gp = groups.get(i);
                if (gp.dimensionIndex == dimensionIndex) {
                    return i;
                }
                --i;
            }
        } else {
            int i = 0;
            while (i < groups.size()) {
                EdgeGroup gp = groups.get(i);
                if (gp.dimensionIndex == dimensionIndex && gp.levelIndex == levelIndex) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int getGroupIndex(List<EdgeGroup> groups, LevelHandle levelHandle) {
        DimensionHandle dimensionHandle;
        if (groups != null && levelHandle != null && levelHandle.getContainer() != null && (dimensionHandle = (DimensionHandle)levelHandle.getContainer().getContainer()) != null) {
            int i = 0;
            while (i < groups.size()) {
                EdgeGroup gp = groups.get(i);
                if (dimensionHandle.getQualifiedName().equals(gp.dimensionName) && levelHandle.getFullName().equals(gp.levelName)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int getGroupIndex(List<EdgeGroup> groups, int dimensionIndex, int levelIndex) {
        if (levelIndex < 0) {
            int i = groups.size() - 1;
            while (i >= 0) {
                EdgeGroup gp = groups.get(i);
                if (gp.dimensionIndex == dimensionIndex) {
                    return i;
                }
                --i;
            }
        } else {
            int i = 0;
            while (i < groups.size()) {
                EdgeGroup gp = groups.get(i);
                if (gp.dimensionIndex == dimensionIndex && gp.levelIndex == levelIndex) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int computeGroupSpan(List<EdgeGroup> groups, int dimensionIndex, int levelIndex) {
        int currentGroup = -1;
        int i = 0;
        while (i < groups.size()) {
            EdgeGroup gp = groups.get(i);
            if (gp.dimensionIndex == dimensionIndex && gp.levelIndex == levelIndex) {
                currentGroup = i;
                break;
            }
            ++i;
        }
        if (currentGroup == -1) {
            return 1;
        }
        return groups.size() - currentGroup - 1;
    }

    public static boolean hasTotalContent(CrosstabReportItemHandle crosstabItem, int axisType, int dimX, int levelX, int meaX) {
        int mCount = crosstabItem.getMeasureCount();
        if (mCount == 0) {
            return false;
        }
        int rdCount = crosstabItem.getDimensionCount(0);
        int cdCount = crosstabItem.getDimensionCount(1);
        boolean checkAllMeasure = meaX < 0 || meaX >= mCount;
        int startMeasure = meaX;
        int endMeasure = meaX + 1;
        if (checkAllMeasure) {
            startMeasure = 0;
            endMeasure = mCount;
        }
        if (startMeasure >= endMeasure) {
            return false;
        }
        if (axisType == 1) {
            if (rdCount == 0) {
                String colDimName = null;
                String colLevelName = null;
                if (dimX >= 0 && levelX >= 0) {
                    DimensionViewHandle cdv = crosstabItem.getDimension(1, dimX);
                    LevelViewHandle clv = cdv.getLevel(levelX);
                    colDimName = cdv.getCubeDimensionName();
                    colLevelName = clv.getCubeLevelName();
                }
                return GroupUtil.hasAggregationCell(startMeasure, endMeasure, crosstabItem, null, null, colDimName, colLevelName);
            }
            int i = 0;
            while (i < rdCount) {
                DimensionViewHandle rdv = crosstabItem.getDimension(0, i);
                int j = 0;
                while (j < rdv.getLevelCount()) {
                    LevelViewHandle rlv = rdv.getLevel(j);
                    String colDimName = null;
                    String colLevelName = null;
                    if (dimX >= 0 && levelX >= 0) {
                        DimensionViewHandle cdv = crosstabItem.getDimension(1, dimX);
                        LevelViewHandle clv = cdv.getLevel(levelX);
                        colDimName = cdv.getCubeDimensionName();
                        colLevelName = clv.getCubeLevelName();
                    }
                    if (GroupUtil.hasAggregationCell(startMeasure, endMeasure, crosstabItem, rdv.getCubeDimensionName(), rlv.getCubeLevelName(), colDimName, colLevelName)) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            if (cdCount == 0) {
                String rowDimName = null;
                String rowLevelName = null;
                if (dimX >= 0 && levelX >= 0) {
                    DimensionViewHandle rdv = crosstabItem.getDimension(0, dimX);
                    LevelViewHandle rlv = rdv.getLevel(levelX);
                    rowDimName = rdv.getCubeDimensionName();
                    rowLevelName = rlv.getCubeLevelName();
                }
                return GroupUtil.hasAggregationCell(startMeasure, endMeasure, crosstabItem, rowDimName, rowLevelName, null, null);
            }
            int i = 0;
            while (i < cdCount) {
                DimensionViewHandle cdv = crosstabItem.getDimension(1, i);
                int j = 0;
                while (j < cdv.getLevelCount()) {
                    LevelViewHandle clv = cdv.getLevel(j);
                    String rowDimName = null;
                    String rowLevelName = null;
                    if (dimX >= 0 && levelX >= 0) {
                        DimensionViewHandle rdv = crosstabItem.getDimension(0, dimX);
                        LevelViewHandle rlv = rdv.getLevel(levelX);
                        rowDimName = rdv.getCubeDimensionName();
                        rowLevelName = rlv.getCubeLevelName();
                    }
                    if (GroupUtil.hasAggregationCell(startMeasure, endMeasure, crosstabItem, rowDimName, rowLevelName, cdv.getCubeDimensionName(), clv.getCubeLevelName())) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean hasAggregationCell(int startMeasure, int endMeasure, CrosstabReportItemHandle crosstabItem, String rowDimensionName, String rowLevelName, String columnDimensionName, String columnLevelName) {
        int k = startMeasure;
        while (k < endMeasure) {
            AggregationCellHandle cell = crosstabItem.getMeasure(k).getAggregationCell(rowDimensionName, rowLevelName, columnDimensionName, columnLevelName);
            if (cell != null) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public static List<EdgeGroup> getGroups(CrosstabReportItemHandle crosstabItem, int axisType) {
        ArrayList<EdgeGroup> groups = new ArrayList<EdgeGroup>();
        int dimCount = crosstabItem.getDimensionCount(axisType);
        if (dimCount > 0) {
            int i = 0;
            while (i < dimCount) {
                DimensionViewHandle dv = crosstabItem.getDimension(axisType, i);
                int j = 0;
                while (j < dv.getLevelCount()) {
                    groups.add(new EdgeGroup(i, j, dv.getCubeDimensionName(), dv.getLevel(j).getCubeLevelName()));
                    ++j;
                }
                ++i;
            }
        }
        return groups;
    }

    public static boolean isLeafGroup(List<DimensionCursor> groupCursors, int groupIndex) throws OLAPException {
        int i = groupIndex + 1;
        while (i < groupCursors.size()) {
            DimensionCursor dc = groupCursors.get(i);
            if (!GroupUtil.isDummyGroup(dc)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isDummyGroup(DimensionCursor dc) throws OLAPException {
        return dc.getExtent() == -1L;
    }

    public static boolean isLeafOrDummyGroup(List<DimensionCursor> groupCursors, int groupIndex) throws OLAPException {
        DimensionCursor dc = groupCursors.get(groupIndex);
        if (GroupUtil.isDummyGroup(dc)) {
            return true;
        }
        return GroupUtil.isLeafGroup(groupCursors, groupIndex);
    }

    public static EdgeGroup getPreviousGroup(List<EdgeGroup> groups, int currentDimensionIndex, int currentLevelIndex) {
        int currentGroup = -1;
        int i = 0;
        while (i < groups.size()) {
            EdgeGroup gp = groups.get(i);
            if (gp.dimensionIndex == currentDimensionIndex && gp.levelIndex == currentLevelIndex) {
                currentGroup = i;
                break;
            }
            ++i;
        }
        if (currentGroup > 0 && currentGroup < groups.size()) {
            return groups.get(currentGroup - 1);
        }
        return null;
    }

    public static EdgeGroup getNextGroup(List<EdgeGroup> groups, int currentDimensionIndex, int currentLevelIndex) {
        int currentGroup = -1;
        int i = 0;
        while (i < groups.size()) {
            EdgeGroup gp = groups.get(i);
            if (gp.dimensionIndex == currentDimensionIndex && gp.levelIndex == currentLevelIndex) {
                currentGroup = i;
                break;
            }
            ++i;
        }
        if (currentGroup >= 0 && currentGroup < groups.size() - 1) {
            return groups.get(currentGroup + 1);
        }
        return null;
    }

    public static int getNextGroupIndex(List<EdgeGroup> groups, int currentDimensionIndex, int currentLevelIndex) {
        int currentGroup = -1;
        int i = 0;
        while (i < groups.size()) {
            EdgeGroup gp = groups.get(i);
            if (gp.dimensionIndex == currentDimensionIndex && gp.levelIndex == currentLevelIndex) {
                currentGroup = i;
                break;
            }
            ++i;
        }
        if (currentGroup >= 0 && currentGroup < groups.size() - 1) {
            return currentGroup + 1;
        }
        return -1;
    }

    public static boolean isFirstGroup(List<EdgeGroup> groups, int dimensionIndex, int levelIndex) {
        if (groups.size() > 0) {
            EdgeGroup eg = groups.get(0);
            return dimensionIndex == eg.dimensionIndex && levelIndex == eg.levelIndex;
        }
        return false;
    }

    public static int computeAggregationCellRowOverSpan(CrosstabReportItemHandle crosstabItem, List<EdgeGroup> rowGroups, LevelHandle targetSpanLevel, EdgeCursor rowEdgeCursor) throws OLAPException {
        int factor;
        if (rowEdgeCursor == null || targetSpanLevel == null) {
            return 1;
        }
        long startPosition = rowEdgeCursor.getPosition();
        int targetGroupIndex = GroupUtil.getGroupIndex(rowGroups, targetSpanLevel);
        boolean verticalHeader = "vertical".equals(crosstabItem.getMeasureDirection());
        int n = factor = verticalHeader ? Math.max(crosstabItem.getMeasureCount(), 1) : 1;
        if (targetGroupIndex != -1) {
            long edgeEndPosition;
            DimensionCursor dc;
            long currentPosition = startPosition;
            if (targetGroupIndex > 0) {
                dc = (DimensionCursor)rowEdgeCursor.getDimensionCursor().get(targetGroupIndex - 1);
                edgeEndPosition = dc.getEdgeEnd();
            } else {
                edgeEndPosition = Long.MAX_VALUE;
            }
            int span = 0;
            while (currentPosition <= edgeEndPosition && !rowEdgeCursor.isAfterLast()) {
                span += factor;
                int i = rowGroups.size() - 2;
                while (i >= targetGroupIndex) {
                    dc = (DimensionCursor)rowEdgeCursor.getDimensionCursor().get(i);
                    if (!GroupUtil.isDummyGroup(dc)) {
                        if (currentPosition != dc.getEdgeEnd()) break;
                        EdgeGroup gp = rowGroups.get(i);
                        DimensionViewHandle dv = crosstabItem.getDimension(0, gp.dimensionIndex);
                        LevelViewHandle lv = dv.getLevel(gp.levelIndex);
                        if (lv.getAggregationHeader() != null) {
                            span += GroupUtil.getTotalRowSpan(crosstabItem, gp.dimensionIndex, gp.levelIndex, verticalHeader);
                        }
                    }
                    --i;
                }
                rowEdgeCursor.next();
                currentPosition = rowEdgeCursor.getPosition();
            }
            rowEdgeCursor.setPosition(startPosition);
            return span;
        }
        return factor;
    }

    public static int computeRowSpan(CrosstabReportItemHandle crosstabItem, List<EdgeGroup> rowGroups, int dimensionIndex, int levelIndex, EdgeCursor rowEdgeCursor, boolean isLayoutDownThenOver) throws OLAPException {
        int factor;
        if (rowEdgeCursor == null) {
            return 1;
        }
        long startPosition = rowEdgeCursor.getPosition();
        int groupIndex = -1;
        int i = 0;
        while (i < rowGroups.size()) {
            EdgeGroup gp = rowGroups.get(i);
            if (gp.dimensionIndex == dimensionIndex && gp.levelIndex == levelIndex) {
                groupIndex = i;
                break;
            }
            ++i;
        }
        boolean verticalHeader = "vertical".equals(crosstabItem.getMeasureDirection());
        int n = factor = verticalHeader ? Math.max(crosstabItem.getMeasureCount(), 1) : 1;
        if (groupIndex != -1 && !GroupUtil.isLeafGroup(rowEdgeCursor.getDimensionCursor(), groupIndex)) {
            long currentPosition = startPosition;
            DimensionCursor dc = (DimensionCursor)rowEdgeCursor.getDimensionCursor().get(groupIndex);
            long edgeEndPosition = dc.getEdgeEnd();
            assert (currentPosition == dc.getEdgeStart());
            int span = 0;
            int startGroupIndex = isLayoutDownThenOver ? groupIndex + 1 : groupIndex;
            while (currentPosition <= edgeEndPosition) {
                span += factor;
                int i2 = rowGroups.size() - 2;
                while (i2 >= startGroupIndex) {
                    dc = (DimensionCursor)rowEdgeCursor.getDimensionCursor().get(i2);
                    if (!GroupUtil.isDummyGroup(dc)) {
                        if (currentPosition != dc.getEdgeEnd()) break;
                        EdgeGroup gp = rowGroups.get(i2);
                        DimensionViewHandle dv = crosstabItem.getDimension(0, gp.dimensionIndex);
                        LevelViewHandle lv = dv.getLevel(gp.levelIndex);
                        if (lv.getAggregationHeader() != null) {
                            span += GroupUtil.getTotalRowSpan(crosstabItem, gp.dimensionIndex, gp.levelIndex, verticalHeader);
                        }
                    }
                    --i2;
                }
                rowEdgeCursor.next();
                currentPosition = rowEdgeCursor.getPosition();
            }
            rowEdgeCursor.setPosition(startPosition);
            return span;
        }
        return factor;
    }

    public static int getFirstTotalRowIndex(CrosstabReportItemHandle crosstabItem, int dimensionIndex, int levelIndex, boolean isVerticalMeasure) {
        int totalMeasureCount = crosstabItem.getMeasureCount();
        if (totalMeasureCount > 0 && isVerticalMeasure) {
            int k = 0;
            while (k < totalMeasureCount) {
                if (GroupUtil.hasTotalContent(crosstabItem, 0, dimensionIndex, levelIndex, k)) {
                    return k;
                }
                ++k;
            }
        }
        return 0;
    }

    public static int getTotalRowSpan(CrosstabReportItemHandle crosstabItem, int dimensionIndex, int levelIndex, boolean isVerticalMeasure) {
        int totalMeasureCount = crosstabItem.getMeasureCount();
        if (totalMeasureCount == 0) {
            return 0;
        }
        if (!isVerticalMeasure) {
            return GroupUtil.hasTotalContent(crosstabItem, 0, dimensionIndex, levelIndex, -1) ? 1 : 0;
        }
        int span = 0;
        int k = 0;
        while (k < totalMeasureCount) {
            if (GroupUtil.hasTotalContent(crosstabItem, 0, dimensionIndex, levelIndex, k)) {
                ++span;
            }
            ++k;
        }
        return span;
    }

    public static boolean hasMeasureHeader(CrosstabReportItemHandle crosstabItem, int axisType) {
        block6: {
            int mc;
            block7: {
                if (crosstabItem.isHideMeasureHeader()) {
                    return false;
                }
                mc = crosstabItem.getMeasureCount();
                if (mc <= 0) break block6;
                if (axisType != 1) break block7;
                if (!"horizontal".equals(crosstabItem.getMeasureDirection())) break block6;
                int i = 0;
                while (i < mc) {
                    if (crosstabItem.getMeasure(i).getHeader() != null) {
                        return true;
                    }
                    ++i;
                }
                break block6;
            }
            if ("vertical".equals(crosstabItem.getMeasureDirection())) {
                int i = 0;
                while (i < mc) {
                    if (crosstabItem.getMeasure(i).getHeader() != null) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public static int getStartingGroupLevel(EdgeCursor edgeCursor, List<DimensionCursor> groupCursors) throws OLAPException {
        if (edgeCursor.isFirst()) {
            return 0;
        }
        int i = 0;
        while (i < groupCursors.size() - 1) {
            DimensionCursor dc = groupCursors.get(i);
            if (dc.getEdgeStart() == edgeCursor.getPosition()) {
                return i + 1;
            }
            ++i;
        }
        return groupCursors.size();
    }

    public static int getEndingGroupLevel(EdgeCursor edgeCursor, List<DimensionCursor> groupCursors) throws OLAPException {
        if (edgeCursor.isLast()) {
            return 0;
        }
        int i = 0;
        while (i < groupCursors.size() - 1) {
            DimensionCursor dc = groupCursors.get(i);
            if (dc.getEdgeEnd() == edgeCursor.getPosition()) {
                return i + 1;
            }
            ++i;
        }
        return groupCursors.size();
    }

    public static int[] getLevelPageBreakIntervals(CrosstabReportItemHandle crosstabItem, List groups, int axisType) {
        if (crosstabItem == null || groups == null || groups.size() == 0) {
            return null;
        }
        int[] intervals = new int[groups.size()];
        boolean hasEffectiveInterval = false;
        int i = 0;
        while (i < groups.size()) {
            EdgeGroup eg = (EdgeGroup)groups.get(i);
            LevelViewHandle lv = crosstabItem.getDimension(axisType, eg.dimensionIndex).getLevel(eg.levelIndex);
            int intv = lv.getPageBreakInterval();
            if (intv > 0) {
                hasEffectiveInterval = true;
                intervals[i] = intv;
            }
            ++i;
        }
        return (int[])(hasEffectiveInterval ? intervals : null);
    }

    public static long[] getLevelCursorState(EdgeCursor cursor) throws OLAPException {
        if (cursor == null) {
            return null;
        }
        List dimCursors = cursor.getDimensionCursor();
        long[] levelState = new long[dimCursors.size()];
        int i = 0;
        while (i < levelState.length) {
            DimensionCursor dc = (DimensionCursor)dimCursors.get(i);
            levelState[i] = dc.getPosition();
            ++i;
        }
        return levelState;
    }
}

