package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.protocol.rtp.RtpEditorUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class EditProtocolUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditProtocolUIModel, EditProtocolUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_BENTHOS_PROTOCOL_BUTTON_ENABLED = "addBenthosProtocolButton.enabled";
    public static final String BINDING_ADD_CARACTERISTIC_MAPPING_BUTTON_ENABLED = "addCaracteristicMappingButton.enabled";
    public static final String BINDING_ADD_SPECIES_PROTOCOL_BUTTON_ENABLED = "addSpeciesProtocolButton.enabled";
    public static final String BINDING_BENTHOS_COMBO_BOX_ENABLED = "benthosComboBox.enabled";
    public static final String BINDING_CARACTERISTIC_MAPPING_COMBO_BOX_ENABLED = "caracteristicMappingComboBox.enabled";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_MOVE_DOWN_CARACTERISTIC_MAPPING_BUTTON_ENABLED = "moveDownCaracteristicMappingButton.enabled";
    public static final String BINDING_MOVE_UP_CARACTERISTIC_MAPPING_BUTTON_ENABLED = "moveUpCaracteristicMappingButton.enabled";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_REMOVE_BENTHOS_PROTOCOL_BUTTON_ENABLED = "removeBenthosProtocolButton.enabled";
    public static final String BINDING_REMOVE_CARACTERISTIC_MAPPING_BUTTON_ENABLED = "removeCaracteristicMappingButton.enabled";
    public static final String BINDING_REMOVE_SPECIES_PROTOCOL_BUTTON_ENABLED = "removeSpeciesProtocolButton.enabled";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SAVE_WARNING_CONTAINER_VISIBLE = "saveWarningContainer.visible";
    public static final String BINDING_SPECIES_COMBO_BOX_ENABLED = "speciesComboBox.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditProtocolUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addBenthosProtocolButton;
    protected JButton addCaracteristicMappingButton;
    protected JButton addSpeciesProtocolButton;
    protected JPanel benthosActions;
    protected BeanFilterableComboBox<Species> benthosComboBox;
    protected JPanel benthosPanel;
    protected JXTable benthosTable;
    protected JPopupMenu benthosTablePopup;
    protected TuttiHelpBroker broker;
    protected JPanel caracteristicActions;
    protected BeanFilterableComboBox<Caracteristic> caracteristicMappingComboBox;
    protected JPopupMenu caracteristicMappingTablePopup;
    protected JTabbedPane caracteristicPane;
    protected JPanel caracteristicPanel;
    protected JXTable caracteristicsMappingTable;
    protected JButton closeButton;
    protected JTextArea commentField;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    protected EditProtocolUI editProtocolTopPanel = this;
    protected JButton exportAllCaracteristicButton;
    protected JButton exportBenthosButton;
    protected JButton exportCaracteristicButton;
    protected JButton exportPupitriButton;
    protected JButton exportSpeciesButton;
    protected final EditProtocolUIHandler handler = createHandler();
    protected JButton importBenthosButton;
    protected JButton importCaracteristicButton;
    protected JButton importColumnsButton;
    protected JButton importSpeciesButton;
    protected BeanDoubleList<Caracteristic> individualObservationList;
    protected BeanDoubleList<Caracteristic> lengthClassesList;
    protected EditProtocolUIModel model;
    protected JMenuItem moveDownCaracteristicMappingButton;
    protected JMenuItem moveUpCaracteristicMappingButton;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    protected JXTable operationFieldsMappingTable;
    protected Table protocolInfoForm;
    protected JMenuItem removeBenthosProtocolButton;
    protected JMenuItem removeCaracteristicMappingButton;
    protected JMenuItem removeSpeciesProtocolButton;
    protected RtpEditorUI rtpEditorUI;
    protected JButton saveButton;
    protected JLabel saveWarning;
    protected JPanel saveWarningContainer;
    protected JButton selectOtherBenthosButton;
    protected JButton selectOtherSpeciesButton;
    protected JPanel speciesActions;
    protected BeanFilterableComboBox<Species> speciesComboBox;
    protected JPanel speciesPanel;
    protected JXTable speciesTable;
    protected JPopupMenu speciesTablePopup;
    protected JTabbedPane tabPanel;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditProtocolUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JScrollPane $JScrollPane2;
    private JScrollPane $JScrollPane3;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private TabInfo $TabInfo3;
    private TabInfo $TabInfo4;
    private TabInfo $TabInfo5;
    private TabInfo $TabInfo6;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditProtocolUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public EditProtocolUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI() {
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doKeyPressed__on__benthosTable(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, benthosTablePopup);
    }

    public void doKeyPressed__on__caracteristicsMappingTable(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, caracteristicMappingTablePopup);
    }

    public void doKeyPressed__on__speciesTable(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, speciesTablePopup);
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "name");
    }

    public void doMouseClicked__on__benthosTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, benthosTablePopup);
    }

    public void doMouseClicked__on__caracteristicsMappingTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, caracteristicMappingTablePopup);
    }

    public void doMouseClicked__on__speciesTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, speciesTablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddBenthosProtocolButton() {
        return addBenthosProtocolButton;
    }

    public JButton getAddCaracteristicMappingButton() {
        return addCaracteristicMappingButton;
    }

    public JButton getAddSpeciesProtocolButton() {
        return addSpeciesProtocolButton;
    }

    public JPanel getBenthosActions() {
        return benthosActions;
    }

    public BeanFilterableComboBox<Species> getBenthosComboBox() {
        return benthosComboBox;
    }

    public JPanel getBenthosPanel() {
        return benthosPanel;
    }

    public JXTable getBenthosTable() {
        return benthosTable;
    }

    public JPopupMenu getBenthosTablePopup() {
        return benthosTablePopup;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JPanel getCaracteristicActions() {
        return caracteristicActions;
    }

    public BeanFilterableComboBox<Caracteristic> getCaracteristicMappingComboBox() {
        return caracteristicMappingComboBox;
    }

    public JPopupMenu getCaracteristicMappingTablePopup() {
        return caracteristicMappingTablePopup;
    }

    public JTabbedPane getCaracteristicPane() {
        return caracteristicPane;
    }

    public JPanel getCaracteristicPanel() {
        return caracteristicPanel;
    }

    public JXTable getCaracteristicsMappingTable() {
        return caracteristicsMappingTable;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JButton getExportAllCaracteristicButton() {
        return exportAllCaracteristicButton;
    }

    public JButton getExportBenthosButton() {
        return exportBenthosButton;
    }

    public JButton getExportCaracteristicButton() {
        return exportCaracteristicButton;
    }

    public JButton getExportPupitriButton() {
        return exportPupitriButton;
    }

    public JButton getExportSpeciesButton() {
        return exportSpeciesButton;
    }

    public EditProtocolUIHandler getHandler() {
        return handler;
    }

    public JButton getImportBenthosButton() {
        return importBenthosButton;
    }

    public JButton getImportCaracteristicButton() {
        return importCaracteristicButton;
    }

    public JButton getImportColumnsButton() {
        return importColumnsButton;
    }

    public JButton getImportSpeciesButton() {
        return importSpeciesButton;
    }

    public BeanDoubleList<Caracteristic> getIndividualObservationList() {
        return individualObservationList;
    }

    public BeanDoubleList<Caracteristic> getLengthClassesList() {
        return lengthClassesList;
    }

    public EditProtocolUIModel getModel() {
        return model;
    }

    public JMenuItem getMoveDownCaracteristicMappingButton() {
        return moveDownCaracteristicMappingButton;
    }

    public JMenuItem getMoveUpCaracteristicMappingButton() {
        return moveUpCaracteristicMappingButton;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public JXTable getOperationFieldsMappingTable() {
        return operationFieldsMappingTable;
    }

    public Table getProtocolInfoForm() {
        return protocolInfoForm;
    }

    public JMenuItem getRemoveBenthosProtocolButton() {
        return removeBenthosProtocolButton;
    }

    public JMenuItem getRemoveCaracteristicMappingButton() {
        return removeCaracteristicMappingButton;
    }

    public JMenuItem getRemoveSpeciesProtocolButton() {
        return removeSpeciesProtocolButton;
    }

    public RtpEditorUI getRtpEditorUI() {
        return rtpEditorUI;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JLabel getSaveWarning() {
        return saveWarning;
    }

    public JPanel getSaveWarningContainer() {
        return saveWarningContainer;
    }

    public JButton getSelectOtherBenthosButton() {
        return selectOtherBenthosButton;
    }

    public JButton getSelectOtherSpeciesButton() {
        return selectOtherSpeciesButton;
    }

    public JPanel getSpeciesActions() {
        return speciesActions;
    }

    public BeanFilterableComboBox<Species> getSpeciesComboBox() {
        return speciesComboBox;
    }

    public JPanel getSpeciesPanel() {
        return speciesPanel;
    }

    public JXTable getSpeciesTable() {
        return speciesTable;
    }

    public JPopupMenu getSpeciesTablePopup() {
        return speciesTablePopup;
    }

    public JTabbedPane getTabPanel() {
        return tabPanel;
    }

    public SwingValidator<EditProtocolUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    protected TabInfo get$TabInfo6() {
        return $TabInfo6;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBenthosActions() {
        if (!allComponentsCreated) {
            return;
        }
        benthosActions.add(importBenthosButton);
        benthosActions.add(exportBenthosButton);
    }

    protected void addChildrenToBenthosPanel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosPanel.add(benthosActions, BorderLayout.NORTH);
        benthosPanel.add($Table2, BorderLayout.CENTER);
    }

    protected void addChildrenToBenthosTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTablePopup.add(removeBenthosProtocolButton);
    }

    protected void addChildrenToCaracteristicActions() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicActions.add(importCaracteristicButton);
        caracteristicActions.add(exportCaracteristicButton);
        caracteristicActions.add(exportAllCaracteristicButton);
        caracteristicActions.add(importColumnsButton);
    }

    protected void addChildrenToCaracteristicMappingTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicMappingTablePopup.add(removeCaracteristicMappingButton);
        caracteristicMappingTablePopup.add(moveUpCaracteristicMappingButton);
        caracteristicMappingTablePopup.add(moveDownCaracteristicMappingButton);
    }

    protected void addChildrenToCaracteristicPane() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicPane.add(lengthClassesList);
        caracteristicPane.add(individualObservationList);
        caracteristicPane.add($Table0);
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 0));
        caracteristicPane.setTitleAt(0, t("tutti.editProtocol.tab.caracteristic.lengthClasses"));
        $TabInfo3.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 1));
        caracteristicPane.setTitleAt(1, t("tutti.editProtocol.tab.caracteristic.individualObservation"));
        $TabInfo4.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 2));
        caracteristicPane.setTitleAt(2, t("tutti.editProtocol.tab.caracteristic.mapping"));
    }

    protected void addChildrenToCaracteristicPanel() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicPanel.add(caracteristicActions, BorderLayout.NORTH);
        caracteristicPanel.add(caracteristicPane, BorderLayout.CENTER);
    }

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToEditProtocolTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(tabPanel, BorderLayout.CENTER);
        add(saveWarningContainer, BorderLayout.NORTH);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToProtocolInfoForm() {
        if (!allComponentsCreated) {
            return;
        }
        protocolInfoForm.add(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        protocolInfoForm.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        protocolInfoForm.add(SwingUtil.boxComponentWithJxLayer(commentPane), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.8, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSaveWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        saveWarningContainer.add(saveWarning, BorderLayout.CENTER);
    }

    protected void addChildrenToSpeciesActions() {
        if (!allComponentsCreated) {
            return;
        }
        speciesActions.add(importSpeciesButton);
        speciesActions.add(exportSpeciesButton);
        speciesActions.add(exportPupitriButton);
    }

    protected void addChildrenToSpeciesPanel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesPanel.add(speciesActions, BorderLayout.NORTH);
        speciesPanel.add($Table1, BorderLayout.CENTER);
    }

    protected void addChildrenToSpeciesTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTablePopup.add(removeSpeciesProtocolButton);
    }

    protected void addChildrenToTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        tabPanel.add(protocolInfoForm);
        tabPanel.add(caracteristicPanel);
        tabPanel.add(speciesPanel);
        tabPanel.add(benthosPanel);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPanel, 0));
        tabPanel.setTitleAt(0, t("tutti.editProtocol.tab.info"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPanel, 1));
        tabPanel.setTitleAt(1, t("tutti.editProtocol.tab.caracteristic"));
        $TabInfo5.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPanel, 2));
        tabPanel.setTitleAt(2, t("tutti.editProtocol.tab.species"));
        $TabInfo6.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPanel, 3));
        tabPanel.setTitleAt(3, t("tutti.editProtocol.tab.benthos"));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddBenthosProtocolButton() {
        $objectMap.put("addBenthosProtocolButton", addBenthosProtocolButton = new JButton());
        
        addBenthosProtocolButton.setName("addBenthosProtocolButton");
        addBenthosProtocolButton.setToolTipText(t("tutti.editProtocol.action.addBenthosProtocol.tip"));
        addBenthosProtocolButton.putClientProperty("help", "tutti.editProtocol.action.addBenthosProtocol.help");
        addBenthosProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.AddBenthosProtocolAction.class);
    }

    protected void createAddCaracteristicMappingButton() {
        $objectMap.put("addCaracteristicMappingButton", addCaracteristicMappingButton = new JButton());
        
        addCaracteristicMappingButton.setName("addCaracteristicMappingButton");
        addCaracteristicMappingButton.setToolTipText(t("tutti.editProtocol.action.addCaracteristicMapping.tip"));
        addCaracteristicMappingButton.putClientProperty("help", "tutti.editProtocol.action.addCaracteristicMapping.help");
        addCaracteristicMappingButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.AddCaracteristicMappingAction.class);
    }

    protected void createAddSpeciesProtocolButton() {
        $objectMap.put("addSpeciesProtocolButton", addSpeciesProtocolButton = new JButton());
        
        addSpeciesProtocolButton.setName("addSpeciesProtocolButton");
        addSpeciesProtocolButton.setToolTipText(t("tutti.editProtocol.action.addSpeciesProtocol.tip"));
        addSpeciesProtocolButton.putClientProperty("help", "tutti.editProtocol.action.addSpeciesProtocol.help");
        addSpeciesProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.AddSpeciesProtocolAction.class);
    }

    protected void createBenthosActions() {
        $objectMap.put("benthosActions", benthosActions = new JPanel());
        
        benthosActions.setName("benthosActions");
        benthosActions.setLayout(new GridLayout());
    }

    protected void createBenthosComboBox() {
        $objectMap.put("benthosComboBox", benthosComboBox = new BeanFilterableComboBox<Species>(this));
        
        benthosComboBox.setName("benthosComboBox");
        benthosComboBox.setShowReset(true);
        benthosComboBox.setToolTipText(t("tutti.editProtocol.field.benthos.tip"));
        benthosComboBox.putClientProperty("help", "tutti.editProtocol.field.benthos.help");
    }

    protected void createBenthosPanel() {
        $objectMap.put("benthosPanel", benthosPanel = new JPanel());
        
        benthosPanel.setName("benthosPanel");
        benthosPanel.setLayout(new BorderLayout());
    }

    protected void createBenthosTable() {
        $objectMap.put("benthosTable", benthosTable = new JXTable());
        
        benthosTable.setName("benthosTable");
        benthosTable.setSortable(true);
        benthosTable.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__benthosTable"));
        benthosTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__benthosTable"));
        benthosTable.putClientProperty("help", "tutti.editProtocol.field.benthos.help");
    }

    protected void createBenthosTablePopup() {
        $objectMap.put("benthosTablePopup", benthosTablePopup = new JPopupMenu());
        
        benthosTablePopup.setName("benthosTablePopup");
        benthosTablePopup.setLabel("tutti.editProtocol.title.batchActions");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editProtocol.help"));
    }

    protected void createCaracteristicActions() {
        $objectMap.put("caracteristicActions", caracteristicActions = new JPanel());
        
        caracteristicActions.setName("caracteristicActions");
        caracteristicActions.setLayout(new GridLayout());
    }

    protected void createCaracteristicMappingComboBox() {
        $objectMap.put("caracteristicMappingComboBox", caracteristicMappingComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        caracteristicMappingComboBox.setName("caracteristicMappingComboBox");
        caracteristicMappingComboBox.setShowReset(true);
        caracteristicMappingComboBox.setToolTipText(t("tutti.editProtocol.field.caracteristicMapping.tip"));
        caracteristicMappingComboBox.putClientProperty("help", "tutti.editProtocol.field.caracteristicMapping.help");
    }

    protected void createCaracteristicMappingTablePopup() {
        $objectMap.put("caracteristicMappingTablePopup", caracteristicMappingTablePopup = new JPopupMenu());
        
        caracteristicMappingTablePopup.setName("caracteristicMappingTablePopup");
        caracteristicMappingTablePopup.setLabel("tutti.editProtocol.title.batchActions");
    }

    protected void createCaracteristicPane() {
        $objectMap.put("caracteristicPane", caracteristicPane = new JTabbedPane());
        
        caracteristicPane.setName("caracteristicPane");
        caracteristicPane.putClientProperty("help", "tutti.editProtocol.pane.caracteristic.help");
    }

    protected void createCaracteristicPanel() {
        $objectMap.put("caracteristicPanel", caracteristicPanel = new JPanel());
        
        caracteristicPanel.setName("caracteristicPanel");
        caracteristicPanel.setLayout(new BorderLayout());
    }

    protected void createCaracteristicsMappingTable() {
        $objectMap.put("caracteristicsMappingTable", caracteristicsMappingTable = new JXTable());
        
        caracteristicsMappingTable.setName("caracteristicsMappingTable");
        caracteristicsMappingTable.setSortable(false);
        caracteristicsMappingTable.setEnabled(true);
        caracteristicsMappingTable.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__caracteristicsMappingTable"));
        caracteristicsMappingTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__caracteristicsMappingTable"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(t("tutti.editProtocol.action.closeEditProtocol"));
        closeButton.setToolTipText(t("tutti.editProtocol.action.closeEditProtocol.tip"));
        closeButton.putClientProperty("help", "tutti.editProtocol.action.closeEditProtocol.help");
        closeButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.OpenHomeScreenAction.class);
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
        commentField.putClientProperty("validatorLabel", t("tutti.editProtocol.field.comment"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.setToolTipText(t("tutti.editProtocol.field.comment.tip"));
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
        commentPane.putClientProperty("help", "tutti.editProtocol.field.comment.help");
    }

    protected void createExportAllCaracteristicButton() {
        $objectMap.put("exportAllCaracteristicButton", exportAllCaracteristicButton = new JButton());
        
        exportAllCaracteristicButton.setName("exportAllCaracteristicButton");
        exportAllCaracteristicButton.setText(t("tutti.editProtocol.action.exportProtocolAllCaracteristic"));
        exportAllCaracteristicButton.setToolTipText(t("tutti.editProtocol.action.exportProtocolAllCaracteristic.tip"));
        exportAllCaracteristicButton.putClientProperty("help", "tutti.editProtocol.action.exportProtocolAllCaracteristic.help");
        exportAllCaracteristicButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ExportAllCaracteristicAction.class);
    }

    protected void createExportBenthosButton() {
        $objectMap.put("exportBenthosButton", exportBenthosButton = new JButton());
        
        exportBenthosButton.setName("exportBenthosButton");
        exportBenthosButton.setText(t("tutti.editProtocol.action.exportProtocolBenthos"));
        exportBenthosButton.setToolTipText(t("tutti.editProtocol.action.exportProtocolBenthos.tip"));
        exportBenthosButton.putClientProperty("help", "tutti.editProtocol.action.exportProtocolBenthos.help");
        exportBenthosButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ExportProtocolBenthosAction.class);
    }

    protected void createExportCaracteristicButton() {
        $objectMap.put("exportCaracteristicButton", exportCaracteristicButton = new JButton());
        
        exportCaracteristicButton.setName("exportCaracteristicButton");
        exportCaracteristicButton.setText(t("tutti.editProtocol.action.exportProtocolCaracteristic"));
        exportCaracteristicButton.setToolTipText(t("tutti.editProtocol.action.exportProtocolCaracteristic.tip"));
        exportCaracteristicButton.putClientProperty("help", "tutti.editProtocol.action.exportProtocolCaracteristic.tip");
        exportCaracteristicButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ExportProtocolCaracteristicAction.class);
    }

    protected void createExportPupitriButton() {
        $objectMap.put("exportPupitriButton", exportPupitriButton = new JButton());
        
        exportPupitriButton.setName("exportPupitriButton");
        exportPupitriButton.setText(t("tutti.editProtocol.action.exportPupitri"));
        exportPupitriButton.setToolTipText(t("tutti.editProtocol.action.exportPupitri.tip"));
        exportPupitriButton.putClientProperty("help", "tutti.editProtocol.action.exportPupitri.help");
        exportPupitriButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ExportPupitriAction.class);
    }

    protected void createExportSpeciesButton() {
        $objectMap.put("exportSpeciesButton", exportSpeciesButton = new JButton());
        
        exportSpeciesButton.setName("exportSpeciesButton");
        exportSpeciesButton.setText(t("tutti.editProtocol.action.exportProtocolSpecies"));
        exportSpeciesButton.setToolTipText(t("tutti.editProtocol.action.exportProtocolSpecies.tip"));
        exportSpeciesButton.putClientProperty("help", "tutti.editProtocol.action.exportProtocolSpecies.help");
        exportSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ExportProtocolSpeciesAction.class);
    }

    protected EditProtocolUIHandler createHandler() {
        return new EditProtocolUIHandler();
    }

    protected void createImportBenthosButton() {
        $objectMap.put("importBenthosButton", importBenthosButton = new JButton());
        
        importBenthosButton.setName("importBenthosButton");
        importBenthosButton.setText(t("tutti.editProtocol.action.importProtocolBenthos"));
        importBenthosButton.setToolTipText(t("tutti.editProtocol.action.importProtocolBenthos.tip"));
        importBenthosButton.putClientProperty("help", "tutti.editProtocol.action.importProtocolBenthos.help");
        importBenthosButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ImportProtocolBenthosAction.class);
    }

    protected void createImportCaracteristicButton() {
        $objectMap.put("importCaracteristicButton", importCaracteristicButton = new JButton());
        
        importCaracteristicButton.setName("importCaracteristicButton");
        importCaracteristicButton.setText(t("tutti.editProtocol.action.importProtocolCaracteristic"));
        importCaracteristicButton.setToolTipText(t("tutti.editProtocol.action.importProtocolCaracteristic.tip"));
        importCaracteristicButton.putClientProperty("help", "tutti.editProtocol.action.importProtocolCaracteristic.help");
        importCaracteristicButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ImportProtocolCaracteristicAction.class);
    }

    protected void createImportColumnsButton() {
        $objectMap.put("importColumnsButton", importColumnsButton = new JButton());
        
        importColumnsButton.setName("importColumnsButton");
        importColumnsButton.setText(t("tutti.editProtocol.action.importProtocolColumns"));
        importColumnsButton.setToolTipText(t("tutti.editProtocol.action.importProtocolColumns.tip"));
        importColumnsButton.putClientProperty("help", "tutti.editProtocol.action.importProtocolColumns.help");
        importColumnsButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.LoadProtocolImportColumnsAction.class);
    }

    protected void createImportSpeciesButton() {
        $objectMap.put("importSpeciesButton", importSpeciesButton = new JButton());
        
        importSpeciesButton.setName("importSpeciesButton");
        importSpeciesButton.setText(t("tutti.editProtocol.action.importProtocolSpecies"));
        importSpeciesButton.setToolTipText(t("tutti.editProtocol.action.importProtocolSpecies.tip"));
        importSpeciesButton.putClientProperty("help", "tutti.editProtocol.action.importProtocolSpecies.help");
        importSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ImportProtocolSpeciesAction.class);
    }

    protected void createIndividualObservationList() {
        $objectMap.put("individualObservationList", individualObservationList = new BeanDoubleList<Caracteristic>());
        
        individualObservationList.setName("individualObservationList");
        individualObservationList.setShowSelectPopupEnabled(true);
        individualObservationList.setProperty("individualObservationPmfm");
        individualObservationList.setShowReset(true);
        individualObservationList.putClientProperty("help", "tutti.editProtocol.field.individualObservation.help");
    }

    protected void createLengthClassesList() {
        $objectMap.put("lengthClassesList", lengthClassesList = new BeanDoubleList<Caracteristic>());
        
        lengthClassesList.setName("lengthClassesList");
        lengthClassesList.setShowSelectPopupEnabled(true);
        lengthClassesList.setProperty("lengthClassesPmfm");
        lengthClassesList.setShowReset(true);
        lengthClassesList.putClientProperty("help", "tutti.editProtocol.field.lengthClasses.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditProtocolUIModel.class));
    }

    protected void createMoveDownCaracteristicMappingButton() {
        $objectMap.put("moveDownCaracteristicMappingButton", moveDownCaracteristicMappingButton = new JMenuItem());
        
        moveDownCaracteristicMappingButton.setName("moveDownCaracteristicMappingButton");
        moveDownCaracteristicMappingButton.setText(t("tutti.editProtocol.action.moveDownCaracteristicMapping"));
        moveDownCaracteristicMappingButton.setToolTipText(t("tutti.editProtocol.action.moveDownCaracteristicMapping.tip"));
        moveDownCaracteristicMappingButton.putClientProperty("help", "tutti.editProtocol.action.moveDownCaracteristicMapping.help");
        moveDownCaracteristicMappingButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.MoveDownCaracteristicMappingAction.class);
    }

    protected void createMoveUpCaracteristicMappingButton() {
        $objectMap.put("moveUpCaracteristicMappingButton", moveUpCaracteristicMappingButton = new JMenuItem());
        
        moveUpCaracteristicMappingButton.setName("moveUpCaracteristicMappingButton");
        moveUpCaracteristicMappingButton.setText(t("tutti.editProtocol.action.moveUpCaracteristicMapping"));
        moveUpCaracteristicMappingButton.setToolTipText(t("tutti.editProtocol.action.moveUpCaracteristicMapping.tip"));
        moveUpCaracteristicMappingButton.putClientProperty("help", "tutti.editProtocol.action.moveUpEntry.help");
        moveUpCaracteristicMappingButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.MoveUpCaracteristicMappingAction.class);
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
        nameField.putClientProperty("help", "tutti.editProtocol.field.name.help");
        nameField.putClientProperty("selectOnFocus", true);
        nameField.putClientProperty("validatorLabel", t("tutti.editProtocol.field.protocol.name"));
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(t("tutti.editProtocol.field.protocol.name"));
        nameLabel.setToolTipText(t("tutti.editProtocol.field.protocol.name.tip"));
        nameLabel.putClientProperty("help", "tutti.editProtocol.field.name.help");
    }

    protected void createOperationFieldsMappingTable() {
        $objectMap.put("operationFieldsMappingTable", operationFieldsMappingTable = new JXTable());
        
        operationFieldsMappingTable.setName("operationFieldsMappingTable");
        operationFieldsMappingTable.setSortable(false);
        operationFieldsMappingTable.setEnabled(true);
    }

    protected void createProtocolInfoForm() {
        $objectMap.put("protocolInfoForm", protocolInfoForm = new Table());
        
        protocolInfoForm.setName("protocolInfoForm");
    }

    protected void createRemoveBenthosProtocolButton() {
        $objectMap.put("removeBenthosProtocolButton", removeBenthosProtocolButton = new JMenuItem());
        
        removeBenthosProtocolButton.setName("removeBenthosProtocolButton");
        removeBenthosProtocolButton.setText(t("tutti.editProtocol.action.removeBenthosProtocol"));
        removeBenthosProtocolButton.setToolTipText(t("tutti.editProtocol.action.removeBenthosProtocol.tip"));
        removeBenthosProtocolButton.putClientProperty("help", "tutti.editProtocol.action.removeBenthosProtocol.help");
        removeBenthosProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.RemoveBenthosProtocolAction.class);
    }

    protected void createRemoveCaracteristicMappingButton() {
        $objectMap.put("removeCaracteristicMappingButton", removeCaracteristicMappingButton = new JMenuItem());
        
        removeCaracteristicMappingButton.setName("removeCaracteristicMappingButton");
        removeCaracteristicMappingButton.setText(t("tutti.editProtocol.action.removeCaracteristicMapping"));
        removeCaracteristicMappingButton.setToolTipText(t("tutti.editProtocol.action.removeCaracteristicMapping.tip"));
        removeCaracteristicMappingButton.putClientProperty("help", "tutti.editProtocol.action.removeCaracteristicMapping.help");
        removeCaracteristicMappingButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.RemoveCaracteristicMappingAction.class);
    }

    protected void createRemoveSpeciesProtocolButton() {
        $objectMap.put("removeSpeciesProtocolButton", removeSpeciesProtocolButton = new JMenuItem());
        
        removeSpeciesProtocolButton.setName("removeSpeciesProtocolButton");
        removeSpeciesProtocolButton.setText(t("tutti.editProtocol.action.removeSpeciesProtocol"));
        removeSpeciesProtocolButton.setToolTipText(t("tutti.editProtocol.action.removeSpeciesProtocol.tip"));
        removeSpeciesProtocolButton.putClientProperty("help", "tutti.editProtocol.action.removeSpeciesProtocol.help");
        removeSpeciesProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.RemoveSpeciesProtocolAction.class);
    }

    protected void createRtpEditorUI() {
        $objectMap.put("rtpEditorUI", rtpEditorUI = new RtpEditorUI(this));
        
        rtpEditorUI.setName("rtpEditorUI");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("tutti.editProtocol.action.saveProtocol"));
        saveButton.setToolTipText(t("tutti.editProtocol.action.saveProtocol.tip"));
        saveButton.putClientProperty("help", "tutti.editProtocol.action.saveProtocol.help");
        saveButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.SaveProtocolAction.class);
    }

    protected void createSaveWarning() {
        $objectMap.put("saveWarning", saveWarning = new JLabel());
        
        saveWarning.setName("saveWarning");
    }

    protected void createSaveWarningContainer() {
        $objectMap.put("saveWarningContainer", saveWarningContainer = new JPanel());
        
        saveWarningContainer.setName("saveWarningContainer");
        saveWarningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createSelectOtherBenthosButton() {
        $objectMap.put("selectOtherBenthosButton", selectOtherBenthosButton = new JButton());
        
        selectOtherBenthosButton.setName("selectOtherBenthosButton");
        selectOtherBenthosButton.setText(t("tutti.editProtocol.action.selectOtherBenthos"));
        selectOtherBenthosButton.setToolTipText(t("tutti.editProtocol.action.selectOtherBenthos.tip"));
        selectOtherBenthosButton.putClientProperty("help", "tutti.editProtocol.action.selectOtherBenthos.help");
        selectOtherBenthosButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.SelectOtherBenthosAction.class);
    }

    protected void createSelectOtherSpeciesButton() {
        $objectMap.put("selectOtherSpeciesButton", selectOtherSpeciesButton = new JButton());
        
        selectOtherSpeciesButton.setName("selectOtherSpeciesButton");
        selectOtherSpeciesButton.setText(t("tutti.editProtocol.action.selectOtherSpecies"));
        selectOtherSpeciesButton.setToolTipText(t("tutti.editProtocol.action.selectOtherSpecies.tip"));
        selectOtherSpeciesButton.putClientProperty("help", "tutti.editProtocol.action.selectOtherSpecies.help");
        selectOtherSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.SelectOtherSpeciesAction.class);
    }

    protected void createSpeciesActions() {
        $objectMap.put("speciesActions", speciesActions = new JPanel());
        
        speciesActions.setName("speciesActions");
        speciesActions.setLayout(new GridLayout());
    }

    protected void createSpeciesComboBox() {
        $objectMap.put("speciesComboBox", speciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        speciesComboBox.setName("speciesComboBox");
        speciesComboBox.setShowReset(true);
        speciesComboBox.setToolTipText(t("tutti.editProtocol.field.species.tip"));
        speciesComboBox.putClientProperty("help", "tutti.editProtocol.field.species.help");
    }

    protected void createSpeciesPanel() {
        $objectMap.put("speciesPanel", speciesPanel = new JPanel());
        
        speciesPanel.setName("speciesPanel");
        speciesPanel.setLayout(new BorderLayout());
    }

    protected void createSpeciesTable() {
        $objectMap.put("speciesTable", speciesTable = new JXTable());
        
        speciesTable.setName("speciesTable");
        speciesTable.setSortable(true);
        speciesTable.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__speciesTable"));
        speciesTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__speciesTable"));
        speciesTable.putClientProperty("help", "tutti.editProtocol.field.species.help");
    }

    protected void createSpeciesTablePopup() {
        $objectMap.put("speciesTablePopup", speciesTablePopup = new JPopupMenu());
        
        speciesTablePopup.setName("speciesTablePopup");
        speciesTablePopup.setLabel("tutti.editProtocol.title.batchActions");
    }

    protected void createTabPanel() {
        $objectMap.put("tabPanel", tabPanel = new JTabbedPane());
        
        tabPanel.setName("tabPanel");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditProtocolUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditProtocolTopPanel();
        addChildrenToValidator();
        addChildrenToSpeciesTablePopup();
        addChildrenToBenthosTablePopup();
        addChildrenToCaracteristicMappingTablePopup();
        addChildrenToTabPanel();
        addChildrenToProtocolInfoForm();
        addChildrenToCommentPane();
        addChildrenToCaracteristicPanel();
        addChildrenToCaracteristicActions();
        addChildrenToCaracteristicPane();
        // inline complete setup of $Table0
        $Table0.add(caracteristicMappingComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addCaracteristicMappingButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 2, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(caracteristicsMappingTable);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(operationFieldsMappingTable);
        addChildrenToSpeciesPanel();
        addChildrenToSpeciesActions();
        // inline complete setup of $Table1
        $Table1.add(speciesComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(selectOtherSpeciesButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(addSpeciesProtocolButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane2, new GridBagConstraints(0, 1, 3, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(speciesTable);
        addChildrenToBenthosPanel();
        addChildrenToBenthosActions();
        // inline complete setup of $Table2
        $Table2.add(benthosComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(selectOtherBenthosButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(addBenthosProtocolButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane3, new GridBagConstraints(0, 1, 3, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane3
        $JScrollPane3.getViewport().add(benthosTable);
        addChildrenToSaveWarningContainer();
        // inline complete setup of $JPanel0
        $JPanel0.add(closeButton);
        $JPanel0.add(saveButton);
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 70 property setters
        lengthClassesList.setBeanType(Caracteristic.class);
        individualObservationList.setBeanType(Caracteristic.class);
        caracteristicMappingComboBox.setBeanType(Caracteristic.class);
        speciesComboBox.setBeanType(Species.class);
        benthosComboBox.setBeanType(Species.class);
        removeSpeciesProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.removeSpeciesProtocol.mnemonic"),'Z'));
        removeSpeciesProtocolButton.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeBenthosProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.removeBenthosProtocol.mnemonic"),'Z'));
        removeBenthosProtocolButton.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeCaracteristicMappingButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.removeCaracteristicMapping.mnemonic"),'Z'));
        removeCaracteristicMappingButton.setIcon(SwingUtil.createActionIcon("delete"));
        moveUpCaracteristicMappingButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.moveUpCaracteristicMapping.mnemonic"),'Z'));
        moveUpCaracteristicMappingButton.setIcon(SwingUtil.createActionIcon("up"));
        moveDownCaracteristicMappingButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.moveDownCaracteristicMapping.mnemonic"),'Z'));
        moveDownCaracteristicMappingButton.setIcon(SwingUtil.createActionIcon("down"));
        nameLabel.setLabelFor(nameField);
        commentPane.setBorder(BorderFactory.createTitledBorder(t("tutti.editProtocol.field.comment")));
        importCaracteristicButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.importProtocolCaracteristic.mnemonic"),'Z'));
        importCaracteristicButton.setIcon(SwingUtil.createActionIcon("import"));
        exportCaracteristicButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.exportProtocolCaracteristic.mnemonic"),'Z'));
        exportCaracteristicButton.setIcon(SwingUtil.createActionIcon("export"));
        exportAllCaracteristicButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.exportProtocolAllCaracteristic.mnemonic"),'Z'));
        exportAllCaracteristicButton.setIcon(SwingUtil.createActionIcon("export"));
        importColumnsButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.importProtocolColumns.mnemonic"),'Z'));
        importColumnsButton.setIcon(SwingUtil.createActionIcon("import"));
        caracteristicPane.setTabPlacement(JTabbedPane.LEFT);
        lengthClassesList.setBean(model);
        individualObservationList.setBean(model);
        addCaracteristicMappingButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.addCaracteristicMapping.mnemonic"),'Z'));
        addCaracteristicMappingButton.setIcon(SwingUtil.createActionIcon("add"));
        caracteristicsMappingTable.setSelectionBackground(null);
        caracteristicsMappingTable.setSelectionForeground(Color.BLACK);
        caracteristicsMappingTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        operationFieldsMappingTable.setSelectionBackground(null);
        operationFieldsMappingTable.setSelectionForeground(Color.BLACK);
        operationFieldsMappingTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        importSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.importProtocolSpecies.mnemonic"),'Z'));
        importSpeciesButton.setIcon(SwingUtil.createActionIcon("import"));
        exportSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.exportProtocolSpecies.mnemonic"),'Z'));
        exportSpeciesButton.setIcon(SwingUtil.createActionIcon("export"));
        exportPupitriButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.exportPupitri.mnemonic"),'Z'));
        exportPupitriButton.setIcon(SwingUtil.createActionIcon("export"));
        selectOtherSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.selectOtherSpecies.mnemonic"),'Z'));
        addSpeciesProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.addSpeciesProtocol.mnemonic"),'Z'));
        addSpeciesProtocolButton.setIcon(SwingUtil.createActionIcon("add"));
        speciesTable.setSelectionForeground(Color.BLACK);
        importBenthosButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.importProtocolBenthos.mnemonic"),'Z'));
        importBenthosButton.setIcon(SwingUtil.createActionIcon("import"));
        exportBenthosButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.exportProtocolBenthos.mnemonic"),'Z'));
        exportBenthosButton.setIcon(SwingUtil.createActionIcon("export"));
        selectOtherBenthosButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.selectOtherBenthos.mnemonic"),'Z'));
        addBenthosProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.addBenthosProtocol.mnemonic"),'Z'));
        addBenthosProtocolButton.setIcon(SwingUtil.createActionIcon("add"));
        benthosTable.setSelectionForeground(Color.BLACK);
        saveWarningContainer.setBackground(new java.awt.Color(245, 218, 88));
        saveWarning.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        saveWarning.setIcon(SwingUtil.createActionIcon("warning"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.closeEditProtocol.mnemonic"),'Z'));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.saveProtocol.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        // late initializer
        rtpEditorUI.pack();
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editProtocolTopPanel, "tutti.editProtocol.help");
        registerHelpId(_broker, removeSpeciesProtocolButton, "tutti.editProtocol.action.removeSpeciesProtocol.help");
        registerHelpId(_broker, removeBenthosProtocolButton, "tutti.editProtocol.action.removeBenthosProtocol.help");
        registerHelpId(_broker, removeCaracteristicMappingButton, "tutti.editProtocol.action.removeCaracteristicMapping.help");
        registerHelpId(_broker, moveUpCaracteristicMappingButton, "tutti.editProtocol.action.moveUpEntry.help");
        registerHelpId(_broker, moveDownCaracteristicMappingButton, "tutti.editProtocol.action.moveDownCaracteristicMapping.help");
        registerHelpId(_broker, nameLabel, "tutti.editProtocol.field.name.help");
        registerHelpId(_broker, nameField, "tutti.editProtocol.field.name.help");
        registerHelpId(_broker, commentPane, "tutti.editProtocol.field.comment.help");
        registerHelpId(_broker, importCaracteristicButton, "tutti.editProtocol.action.importProtocolCaracteristic.help");
        registerHelpId(_broker, exportCaracteristicButton, "tutti.editProtocol.action.exportProtocolCaracteristic.tip");
        registerHelpId(_broker, exportAllCaracteristicButton, "tutti.editProtocol.action.exportProtocolAllCaracteristic.help");
        registerHelpId(_broker, importColumnsButton, "tutti.editProtocol.action.importProtocolColumns.help");
        registerHelpId(_broker, caracteristicPane, "tutti.editProtocol.pane.caracteristic.help");
        registerHelpId(_broker, lengthClassesList, "tutti.editProtocol.field.lengthClasses.help");
        registerHelpId(_broker, individualObservationList, "tutti.editProtocol.field.individualObservation.help");
        registerHelpId(_broker, caracteristicMappingComboBox, "tutti.editProtocol.field.caracteristicMapping.help");
        registerHelpId(_broker, addCaracteristicMappingButton, "tutti.editProtocol.action.addCaracteristicMapping.help");
        registerHelpId(_broker, importSpeciesButton, "tutti.editProtocol.action.importProtocolSpecies.help");
        registerHelpId(_broker, exportSpeciesButton, "tutti.editProtocol.action.exportProtocolSpecies.help");
        registerHelpId(_broker, exportPupitriButton, "tutti.editProtocol.action.exportPupitri.help");
        registerHelpId(_broker, speciesComboBox, "tutti.editProtocol.field.species.help");
        registerHelpId(_broker, selectOtherSpeciesButton, "tutti.editProtocol.action.selectOtherSpecies.help");
        registerHelpId(_broker, addSpeciesProtocolButton, "tutti.editProtocol.action.addSpeciesProtocol.help");
        registerHelpId(_broker, speciesTable, "tutti.editProtocol.field.species.help");
        registerHelpId(_broker, importBenthosButton, "tutti.editProtocol.action.importProtocolBenthos.help");
        registerHelpId(_broker, exportBenthosButton, "tutti.editProtocol.action.exportProtocolBenthos.help");
        registerHelpId(_broker, benthosComboBox, "tutti.editProtocol.field.benthos.help");
        registerHelpId(_broker, selectOtherBenthosButton, "tutti.editProtocol.action.selectOtherBenthos.help");
        registerHelpId(_broker, addBenthosProtocolButton, "tutti.editProtocol.action.addBenthosProtocol.help");
        registerHelpId(_broker, benthosTable, "tutti.editProtocol.field.benthos.help");
        registerHelpId(_broker, closeButton, "tutti.editProtocol.action.closeEditProtocol.help");
        registerHelpId(_broker, saveButton, "tutti.editProtocol.action.saveProtocol.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editProtocolTopPanel", editProtocolTopPanel);
        createModel();
        createBroker();
        createRtpEditorUI();
        createValidator();
        createSpeciesTablePopup();
        createRemoveSpeciesProtocolButton();
        createBenthosTablePopup();
        createRemoveBenthosProtocolButton();
        createCaracteristicMappingTablePopup();
        createRemoveCaracteristicMappingButton();
        createMoveUpCaracteristicMappingButton();
        createMoveDownCaracteristicMappingButton();
        createTabPanel();
        createProtocolInfoForm();
        createNameLabel();
        createNameField();
        createCommentPane();
        createCommentField();
        createCaracteristicPanel();
        createCaracteristicActions();
        createImportCaracteristicButton();
        createExportCaracteristicButton();
        createExportAllCaracteristicButton();
        createImportColumnsButton();
        createCaracteristicPane();
        createLengthClassesList();
        createIndividualObservationList();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createCaracteristicMappingComboBox();
        createAddCaracteristicMappingButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createCaracteristicsMappingTable();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createOperationFieldsMappingTable();
        createSpeciesPanel();
        createSpeciesActions();
        createImportSpeciesButton();
        createExportSpeciesButton();
        createExportPupitriButton();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createSpeciesComboBox();
        createSelectOtherSpeciesButton();
        createAddSpeciesProtocolButton();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createSpeciesTable();
        createBenthosPanel();
        createBenthosActions();
        createImportBenthosButton();
        createExportBenthosButton();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createBenthosComboBox();
        createSelectOtherBenthosButton();
        createAddBenthosProtocolButton();
        // inline creation of $JScrollPane3
        $objectMap.put("$JScrollPane3", $JScrollPane3 = new JScrollPane());
        
        $JScrollPane3.setName("$JScrollPane3");
        createBenthosTable();
        createSaveWarningContainer();
        createSaveWarning();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        SwingUtil.setComponentHeight($JPanel0,50);
        createCloseButton();
        createSaveButton();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(t("tutti.editProtocol.tab.info"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(t("tutti.editProtocol.tab.caracteristic"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(t("tutti.editProtocol.tab.caracteristic.lengthClasses"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new TabInfo());
        
        $TabInfo3.setTitle(t("tutti.editProtocol.tab.caracteristic.individualObservation"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new TabInfo());
        
        $TabInfo4.setTitle(t("tutti.editProtocol.tab.caracteristic.mapping"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new TabInfo());
        
        $TabInfo5.setTitle(t("tutti.editProtocol.tab.species"));
        // inline creation of $TabInfo6
        $objectMap.put("$TabInfo6", $TabInfo6 = new TabInfo());
        
        $TabInfo6.setTitle(t("tutti.editProtocol.tab.benthos"));
        // inline creation of editProtocolTopPanel
        setName("editProtocolTopPanel");
        setLayout(new BorderLayout());
        editProtocolTopPanel.putClientProperty("help", "tutti.editProtocol.help");
        
        // registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_PROTOCOL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeSpeciesEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesProtocolButton.setEnabled(model.isRemoveSpeciesEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeSpeciesEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_BENTHOS_PROTOCOL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeBenthosEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeBenthosProtocolButton.setEnabled(model.isRemoveBenthosEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeBenthosEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_CARACTERISTIC_MAPPING_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeCaracteristicMappingEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeCaracteristicMappingButton.setEnabled(model.isRemoveCaracteristicMappingEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeCaracteristicMappingEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MOVE_UP_CARACTERISTIC_MAPPING_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("moveUpCaracteristicMappingEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    moveUpCaracteristicMappingButton.setEnabled(model.isMoveUpCaracteristicMappingEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("moveUpCaracteristicMappingEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MOVE_DOWN_CARACTERISTIC_MAPPING_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("moveDownCaracteristicMappingEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    moveDownCaracteristicMappingButton.setEnabled(model.isMoveDownCaracteristicMappingEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("moveDownCaracteristicMappingEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField, model.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, getStringValue(model.getComment()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CARACTERISTIC_MAPPING_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (caracteristicMappingComboBox != null) {
                    caracteristicMappingComboBox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (caracteristicMappingComboBox != null) {
                    caracteristicMappingComboBox.setEnabled(!caracteristicMappingComboBox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (caracteristicMappingComboBox != null) {
                    caracteristicMappingComboBox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_CARACTERISTIC_MAPPING_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (caracteristicMappingComboBox != null) {
                    caracteristicMappingComboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (caracteristicMappingComboBox != null) {
                    addCaracteristicMappingButton.setEnabled( caracteristicMappingComboBox.getSelectedItem() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (caracteristicMappingComboBox != null) {
                    caracteristicMappingComboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.setEnabled(!speciesComboBox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_SPECIES_PROTOCOL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesComboBox != null) {
                    addSpeciesProtocolButton.setEnabled(handler.isSpeciesSelected(speciesComboBox.getSelectedItem()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (benthosComboBox != null) {
                    benthosComboBox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (benthosComboBox != null) {
                    benthosComboBox.setEnabled(!benthosComboBox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (benthosComboBox != null) {
                    benthosComboBox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_BENTHOS_PROTOCOL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (benthosComboBox != null) {
                    benthosComboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (benthosComboBox != null) {
                    addBenthosProtocolButton.setEnabled(handler.isSpeciesSelected(benthosComboBox.getSelectedItem()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (benthosComboBox != null) {
                    benthosComboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_WARNING_CONTAINER_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("imported", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cloned", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cleaned", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveWarningContainer.setVisible(model.isImported() || model.isCloned() || model.isCleaned());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("imported", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cloned", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cleaned", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}