/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.psionimport;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;

public class PsionImportResult {
    protected final File importFile;
    protected final List<String> errors;
    protected int nbSortedImported;
    protected int nbUnsortedImported;

    public PsionImportResult(File importFile, List<String> errors) {
        this.importFile = importFile;
        this.errors = Lists.newArrayList(errors);
    }

    public File getImportFile() {
        return this.importFile;
    }

    public int getNbSortedImported() {
        return this.nbSortedImported;
    }

    public int getNbUnsortedImported() {
        return this.nbUnsortedImported;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    void incrementNbSortedImported() {
        ++this.nbSortedImported;
    }

    void incrementNbUnsortedImported() {
        ++this.nbUnsortedImported;
    }

    void addError(String error) {
        this.errors.add(error);
    }

    public boolean isDone() {
        return this.errors.isEmpty();
    }
}

