/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.list;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.KeyStroke;
import jaxx.runtime.swing.list.CheckListEditor;
import jaxx.runtime.swing.list.CheckListModel;
import jaxx.runtime.swing.list.CheckListRenderer;
import jaxx.runtime.swing.list.DefaultCheckListModel;

public class CheckList<T> {
    private final JList list = new JList();
    private static final MouseAdapter checkBoxEditor = new CheckListEditor();

    public CheckList() {
        this.list.getSelectionModel().setSelectionMode(0);
        if (!this.isEditorAttached()) {
            this.list.addMouseListener(checkBoxEditor);
        }
        this.list.setCellRenderer(new CheckListRenderer());
        this.setupKeyboardActions(this.list);
    }

    private void setupKeyboardActions(final JList list) {
        String actionKey = "toggle-check";
        list.getInputMap().put(KeyStroke.getKeyStroke(32, 0), actionKey);
        list.getActionMap().put(actionKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckList.this.toggleIndex(list.getSelectedIndex());
            }
        });
    }

    private boolean isEditorAttached() {
        for (MouseListener ml : this.list.getMouseListeners()) {
            if (!(ml instanceof CheckListEditor)) continue;
            return true;
        }
        return false;
    }

    public JList getList() {
        return this.list;
    }

    public void setData(Collection<T> data) {
        this.setModel(new DefaultCheckListModel<T>(data));
    }

    public void setModel(CheckListModel<T> model) {
        this.list.setModel(model);
    }

    public CheckListModel<T> getModel() {
        return (CheckListModel)this.list.getModel();
    }

    public Collection<T> getCheckedItems() {
        return this.getModel().getCheckedItems();
    }

    public void setCheckedItems(Collection<T> elements) {
        this.getModel().setCheckedItems(elements);
    }

    public void toggleIndex(int index) {
        if (index >= 0 && index < this.list.getModel().getSize()) {
            CheckListModel<T> model;
            model.setCheckedIndex(index, !(model = this.getModel()).isCheckedIndex(index));
        }
    }
}

