/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.awt.Component;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveBenthosSubBatchAction
extends LongActionSupport<BenthosBatchUIModel, BenthosBatchUI, BenthosBatchUIHandler> {
    protected int rowIndex;
    protected Set<BenthosBatchRowModel> rowToRemove;
    protected BenthosBatchRowModel parentBatch;

    public RemoveBenthosSubBatchAction(BenthosBatchUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        this.rowIndex = -1;
        if (result) {
            int answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), I18n.t((String)"tutti.editBenthosBatch.action.removeSubBatch.confirm.message", (Object[])new Object[0]), I18n.t((String)"tutti.editBenthosBatch.action.removeSubBatch.confirm.title", (Object[])new Object[0]), 0);
            result = answer == 0;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        JXTable table = ((BenthosBatchUIHandler)this.handler).getTable();
        this.rowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        Preconditions.checkState((this.rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove sub batch if no batch selected");
        this.parentBatch = (BenthosBatchRowModel)((BenthosBatchUIHandler)this.handler).getTableModel().getEntry(this.rowIndex);
        Preconditions.checkState((!TuttiEntities.isNew(this.parentBatch) ? 1 : 0) != 0, (Object)"Can't remove sub batch if batch is not persisted");
        persistenceService.deleteSpeciesSubBatch(this.parentBatch.getId());
        this.rowToRemove = Sets.newHashSet();
        ((BenthosBatchUIHandler)this.handler).collectChildren(this.parentBatch, this.rowToRemove);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        JXTable table = ((BenthosBatchUIHandler)this.handler).getTable();
        ((BenthosBatchUIModel)this.getModel()).getRows().removeAll(this.rowToRemove);
        this.parentBatch.setChildBatch(null);
        ((BenthosBatchUIHandler)this.handler).getTableModel().fireTableDataChanged();
        TuttiUIUtil.selectFirstCellOnRow((JXTable)table, (int)this.rowIndex, (boolean)true);
    }
}

