/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.nuiton.util.GZUtilException;

public class GZUtil {
    public static boolean isGzipStream(InputStream inputStream) throws IOException {
        inputStream.mark(2);
        int b = inputStream.read();
        int magic = inputStream.read() << 8 | b;
        inputStream.reset();
        boolean gzip = magic == 35615;
        return gzip;
    }

    public static StringBuffer bytesToStringBuffer(byte[] in) {
        try {
            int c;
            if (in == null || in.length == 0) {
                return new StringBuffer("");
            }
            GZIPInputStream gz = new GZIPInputStream(new BufferedInputStream(new ByteArrayInputStream(in)));
            StringBuffer sb = new StringBuffer();
            while ((c = gz.read()) != -1) {
                sb.append((char)c);
            }
            gz.close();
            return sb;
        }
        catch (IOException eee) {
            throw new GZUtilException("Probleme dans la decompression", eee);
        }
    }

    public static String bytesToString(byte[] in) {
        return GZUtil.bytesToStringBuffer(in).toString();
    }

    public static byte[] stringBufferToBytes(StringBuffer elem) {
        return GZUtil.stringToBytes(elem.toString());
    }

    public static byte[] stringToBytes(String elem) {
        try {
            int c;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gz = new GZIPOutputStream(new BufferedOutputStream(baos));
            BufferedReader sr = new BufferedReader(new StringReader(elem));
            while ((c = ((Reader)sr).read()) != -1) {
                gz.write((char)c);
            }
            gz.close();
            return baos.toByteArray();
        }
        catch (IOException eee) {
            throw new GZUtilException("Probleme dans la compression", eee);
        }
    }
}

