/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.BasicStroke;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGStrokeDescriptor;

public class SVGBasicStroke
extends AbstractSVGConverter {
    public SVGBasicStroke(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        if (graphicContext.getStroke() instanceof BasicStroke) {
            return this.toSVG((BasicStroke)graphicContext.getStroke());
        }
        return null;
    }

    public final SVGStrokeDescriptor toSVG(BasicStroke basicStroke) {
        String string = this.doubleString(basicStroke.getLineWidth());
        String string2 = SVGBasicStroke.endCapToSVG(basicStroke.getEndCap());
        String string3 = SVGBasicStroke.joinToSVG(basicStroke.getLineJoin());
        String string4 = this.doubleString(basicStroke.getMiterLimit());
        float[] fArray = basicStroke.getDashArray();
        String string5 = null;
        string5 = fArray != null ? this.dashArrayToSVG(fArray) : "none";
        String string6 = this.doubleString(basicStroke.getDashPhase());
        return new SVGStrokeDescriptor(string, string2, string3, string4, string5, string6);
    }

    private final String dashArrayToSVG(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (fArray.length > 0) {
            stringBuffer.append(this.doubleString(fArray[0]));
        }
        int n = 1;
        while (n < fArray.length) {
            stringBuffer.append(",");
            stringBuffer.append(this.doubleString(fArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String joinToSVG(int n) {
        switch (n) {
            case 2: {
                return "bevel";
            }
            case 1: {
                return "round";
            }
        }
        return "miter";
    }

    private static String endCapToSVG(int n) {
        switch (n) {
            case 0: {
                return "butt";
            }
            case 1: {
                return "round";
            }
        }
        return "square";
    }
}

