/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ichtyometer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intel.bluetooth.BlueCoveImpl;
import fr.ifremer.tutti.ichtyometer.LocalDeviceNotFoundException;
import fr.ifremer.tutti.ichtyometer.RemoteDeviceChooser;
import fr.ifremer.tutti.ichtyometer.RemoteDeviceNotFoundException;
import fr.ifremer.tutti.ichtyometer.RemoteDeviceServiceNotFoundException;
import fr.ifremer.tutti.ichtyometer.RemoteDevicesFinder;
import fr.ifremer.tutti.ichtyometer.ServiceRecordsFinder;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IchtyometerClient
implements Closeable {
    private static final Log log = LogFactory.getLog(IchtyometerClient.class);
    protected static Map<String, RemoteDevice> REMOTE_DEVICE_CACHE;
    protected static Map<String, String> REMOTE_CONNECTION_URL_CACHE;
    private final int maximumNumberOfTryToConnect;
    protected LocalDevice localDevice;
    protected final Set<StreamConnection> connections = Sets.newHashSet();
    protected RemoteDevice remoteDevice;
    protected String connectionUrl;
    protected boolean open;
    protected String name;

    public IchtyometerClient(int maximumNumberOfTryToConnect) {
        this.maximumNumberOfTryToConnect = maximumNumberOfTryToConnect;
    }

    public static void clearRemoteDeviceCaches() {
        REMOTE_DEVICE_CACHE = null;
        REMOTE_CONNECTION_URL_CACHE = null;
    }

    public void open(RemoteDeviceChooser remoteDeviceChooser, boolean forceCompleteScan) throws IOException {
        Preconditions.checkState((!this.open ? 1 : 0) != 0, (Object)"Client is already opened");
        try {
            this.localDevice = LocalDevice.getLocalDevice();
        }
        catch (BluetoothStateException e) {
            throw new LocalDeviceNotFoundException();
        }
        if (forceCompleteScan || REMOTE_DEVICE_CACHE == null) {
            REMOTE_DEVICE_CACHE = this.discoverRemoteDevices();
        }
        if (REMOTE_DEVICE_CACHE.isEmpty()) {
            throw new RemoteDeviceNotFoundException("No remote device found");
        }
        this.name = remoteDeviceChooser.chooseRemoteDevice(REMOTE_DEVICE_CACHE.keySet());
        if (this.name == null) {
            throw new RemoteDeviceNotFoundException("User did not choose a remote device");
        }
        this.remoteDevice = REMOTE_DEVICE_CACHE.get(this.name);
        if (this.remoteDevice == null) {
            throw new RemoteDeviceNotFoundException("Could not find remote device with name '" + this.name + "'");
        }
        if (forceCompleteScan || REMOTE_CONNECTION_URL_CACHE == null) {
            REMOTE_CONNECTION_URL_CACHE = Maps.newTreeMap();
        }
        if (!REMOTE_CONNECTION_URL_CACHE.containsKey(this.name)) {
            int serviceIndex = 3;
            List<ServiceRecord> serviceRecords = this.discoverServiceRecords(serviceIndex);
            if (log.isInfoEnabled()) {
                log.info((Object)("Found some services for index: " + serviceIndex));
            }
            ServiceRecord serviceRecord = serviceRecords.get(0);
            String url = serviceRecord.getConnectionURL(0, true);
            if (log.isInfoEnabled()) {
                log.info((Object)("Found service(" + serviceIndex + "): " + url + ", name: " + this.name));
            }
            REMOTE_CONNECTION_URL_CACHE.put(this.name, url);
        }
        this.connectionUrl = REMOTE_CONNECTION_URL_CACHE.get(this.name);
        this.open = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        try {
            for (StreamConnection connection : Sets.newHashSet(this.connections)) {
                this.closeConnection(connection);
            }
        }
        finally {
            BlueCoveImpl.shutdown();
        }
    }

    public StreamConnection openConnection() throws IOException {
        this.checkIsOpened();
        StreamConnection connection = (StreamConnection)Connector.open((String)this.connectionUrl, (int)2);
        this.connections.add(connection);
        return connection;
    }

    public void closeConnection(StreamConnection connection) throws IOException {
        this.checkIsOpened();
        boolean remove = this.connections.remove(connection);
        if (!remove) {
            throw new IllegalArgumentException("Connection is not coming from this client, won't close it!");
        }
        connection.close();
    }

    public boolean isOpen() {
        return this.open;
    }

    public String getName() {
        this.checkIsOpened();
        return this.name;
    }

    protected void checkIsOpened() {
        if (!this.open) {
            throw new IllegalStateException("Client is not opened!");
        }
    }

    protected Map<String, RemoteDevice> discoverRemoteDevices() throws RemoteDeviceNotFoundException {
        Map<String, RemoteDevice> devices;
        RemoteDevicesFinder remoteDevicesFinder = new RemoteDevicesFinder(this.maximumNumberOfTryToConnect, this);
        try {
            devices = remoteDevicesFinder.findDevices(this.localDevice);
        }
        catch (Exception e) {
            throw new RemoteDeviceNotFoundException("Could not detected devices", e);
        }
        return devices;
    }

    protected List<ServiceRecord> discoverServiceRecords(int serviceIndex) throws RemoteDeviceNotFoundException, RemoteDeviceServiceNotFoundException {
        List<ServiceRecord> serviceRecords;
        ServiceRecordsFinder serviceRecordsFinder = new ServiceRecordsFinder(this.maximumNumberOfTryToConnect, this);
        try {
            serviceRecords = serviceRecordsFinder.findServices(this.localDevice, this.remoteDevice, serviceIndex);
        }
        catch (Exception e) {
            throw new RemoteDeviceNotFoundException("Could not read remote device services", e);
        }
        if (serviceRecords.isEmpty()) {
            throw new RemoteDeviceServiceNotFoundException("No services detected.");
        }
        return serviceRecords;
    }
}

