/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.launcher;

import fr.ifremer.tutti.ui.swing.launcher.ExitCode;
import fr.ifremer.tutti.ui.swing.launcher.ExitCodes;
import fr.ifremer.tutti.ui.swing.launcher.JavaCommand;
import fr.ifremer.tutti.ui.swing.launcher.LauncherProperties;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;

public class Launcher {
    public static final String APPLICATION_LAUNCHER_TITLE = "Allegro Campagne";
    public static final String APPLICATION_DIR = "tutti";
    public static final String DEBUG_APPLICATION_ARG = "--debug";
    public static final String DEBUG_UPDATER_ARG = "--debug-updater";
    private final Path basedir = Paths.get(System.getProperty("user.dir"), new String[0]);
    private final List<String> arguments;
    private final Path jrePath = this.basedir.resolve("jre");
    private final boolean debugApplication;
    private final boolean debugUpdater;

    public static void main(String ... args) {
        Launcher launcher = new Launcher(args);
        launcher.execute();
    }

    public Launcher(String ... args) {
        ArrayList<String> fullArguments = new ArrayList<String>(Arrays.asList(args));
        this.debugApplication = fullArguments.remove(DEBUG_APPLICATION_ARG);
        this.debugUpdater = fullArguments.remove(DEBUG_UPDATER_ARG);
        this.arguments = Collections.unmodifiableList(fullArguments);
    }

    public void execute() {
        try {
            ExitCode exitCode;
            do {
                if (ExitCodes.isRuntimeUpdateExitCode(exitCode = this.executeUpdater())) {
                    System.exit(exitCode.getExitCode());
                }
                if (ExitCodes.isNormalExitCode(exitCode)) continue;
                throw new RuntimeException("Allegro Campaign Updater has encountered a problem, program stopped.\nPlease check updater log file.");
            } while ((exitCode = this.executeApplication()).isRelaunch());
            if (!ExitCodes.isNormalExitCode(exitCode)) {
                throw new RuntimeException("exit code = " + exitCode.getExitCode());
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString(), APPLICATION_LAUNCHER_TITLE, 0);
        }
    }

    protected ExitCode executeUpdater() throws Exception {
        LauncherProperties launcherProperties = new LauncherProperties(this.basedir);
        launcherProperties.load();
        Path logFile = launcherProperties.getUpdaterLogFile();
        if (Files.notExists(logFile.getParent(), new LinkOption[0])) {
            Files.createDirectory(logFile.getParent(), new FileAttribute[0]);
        }
        Path tempFile = Files.createTempFile("tutti-launcher", "jar", new FileAttribute[0]);
        Path updaterJarFile = Files.copy(launcherProperties.getUpdaterJarFile(), tempFile, StandardCopyOption.REPLACE_EXISTING);
        System.out.println("Will use launcher: " + updaterJarFile);
        JavaCommand program = JavaCommand.create(this.jrePath).setDebug(this.debugUpdater).setJarPath(updaterJarFile).setLogFile(logFile);
        ExitCode exitCode = program.execute();
        return exitCode;
    }

    protected ExitCode executeApplication() throws Exception {
        LauncherProperties launcherProperties = new LauncherProperties(this.basedir);
        launcherProperties.load();
        Path logFile = launcherProperties.getApplicationLogFile();
        if (Files.notExists(logFile.getParent(), new LinkOption[0])) {
            Files.createDirectory(logFile.getParent(), new FileAttribute[0]);
        }
        JavaCommand program = JavaCommand.create(this.jrePath).setDebug(this.debugApplication).setInheritIO(true).addArguments(launcherProperties.getApplicationJvmOptions()).addSystemProperty("tutti.log.file", logFile.toString()).setJarPath(launcherProperties.getApplicationJarFile()).addArguments("--launch-mode", "full").addArguments("--basedir", this.basedir.toFile().getAbsolutePath()).addArguments(launcherProperties.getApplicationOtherOptions()).addArgument(this.arguments);
        ExitCode exitCode = program.execute();
        return exitCode;
    }
}

