/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;

public class ShellContextFactory
extends ContextFactory {
    private boolean strictMode;
    private int languageVersion;
    private int optimizationLevel;
    private ErrorReporter errorReporter;

    protected boolean hasFeature(Context context, int n) {
        switch (n) {
            case 8: 
            case 9: {
                return this.strictMode;
            }
        }
        return super.hasFeature(context, n);
    }

    protected void onContextCreated(Context context) {
        context.setLanguageVersion(this.languageVersion);
        context.setOptimizationLevel(this.optimizationLevel);
        if (this.errorReporter != null) {
            context.setErrorReporter(this.errorReporter);
        }
        super.onContextCreated(context);
    }

    public void setStrictMode(boolean bl) {
        this.checkNotSealed();
        this.strictMode = bl;
    }

    public void setLanguageVersion(int n) {
        Context.checkLanguageVersion(n);
        this.checkNotSealed();
        this.languageVersion = n;
    }

    public void setOptimizationLevel(int n) {
        Context.checkOptimizationLevel(n);
        this.checkNotSealed();
        this.optimizationLevel = n;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException();
        }
        this.errorReporter = errorReporter;
    }
}

