/*
 * Decompiled with CFR 0.152.
 */
package liquibase.precondition.core;

import java.util.ArrayList;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.precondition.core.AndPrecondition;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

public class PreconditionContainer
extends AndPrecondition {
    private FailOption onFail = FailOption.HALT;
    private ErrorOption onError = ErrorOption.HALT;
    private OnSqlOutputOption onSqlOutput = OnSqlOutputOption.IGNORE;
    private String onFailMessage;
    private String onErrorMessage;

    public FailOption getOnFail() {
        return this.onFail;
    }

    public void setOnFail(String onFail) {
        if (onFail != null) {
            FailOption[] failOptionArray = FailOption.values();
            int n = failOptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                FailOption option = failOptionArray[n2];
                if (option.key.equalsIgnoreCase(onFail)) {
                    this.onFail = option;
                    return;
                }
                ++n2;
            }
            ArrayList<String> possibleOptions = new ArrayList<String>();
            FailOption[] failOptionArray2 = FailOption.values();
            int n3 = failOptionArray2.length;
            n = 0;
            while (n < n3) {
                FailOption option = failOptionArray2[n];
                possibleOptions.add(option.key);
                ++n;
            }
            throw new RuntimeException("Unknown onFail attribute value '" + onFail + "'.  Possible values: " + StringUtils.join(possibleOptions, ", "));
        }
        this.onFail = FailOption.HALT;
    }

    public ErrorOption getOnError() {
        return this.onError;
    }

    public void setOnError(String onError) {
        if (onError != null) {
            ErrorOption[] errorOptionArray = ErrorOption.values();
            int n = errorOptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ErrorOption option = errorOptionArray[n2];
                if (option.key.equalsIgnoreCase(onError)) {
                    this.onError = option;
                    return;
                }
                ++n2;
            }
            ArrayList<String> possibleOptions = new ArrayList<String>();
            ErrorOption[] errorOptionArray2 = ErrorOption.values();
            int n3 = errorOptionArray2.length;
            n = 0;
            while (n < n3) {
                ErrorOption option = errorOptionArray2[n];
                possibleOptions.add(option.key);
                ++n;
            }
            throw new RuntimeException("Unknown onError attribute value '" + onError + "'.  Possible values: " + StringUtils.join(possibleOptions, ", "));
        }
        this.onError = ErrorOption.HALT;
    }

    public OnSqlOutputOption getOnSqlOutput() {
        return this.onSqlOutput;
    }

    public void setOnSqlOutput(String onSqlOutput) {
        if (onSqlOutput == null) {
            this.setOnSqlOutput((OnSqlOutputOption)null);
            return;
        }
        OnSqlOutputOption[] onSqlOutputOptionArray = OnSqlOutputOption.values();
        int n = onSqlOutputOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            OnSqlOutputOption option = onSqlOutputOptionArray[n2];
            if (option.key.equalsIgnoreCase(onSqlOutput)) {
                this.setOnSqlOutput(option);
                return;
            }
            ++n2;
        }
        ArrayList<String> possibleOptions = new ArrayList<String>();
        OnSqlOutputOption[] onSqlOutputOptionArray2 = OnSqlOutputOption.values();
        int n3 = onSqlOutputOptionArray2.length;
        n = 0;
        while (n < n3) {
            OnSqlOutputOption option = onSqlOutputOptionArray2[n];
            possibleOptions.add(option.key);
            ++n;
        }
        throw new RuntimeException("Unknown onSqlOutput attribute value '" + onSqlOutput + "'.  Possible values: " + StringUtils.join(possibleOptions, ", "));
    }

    public void setOnSqlOutput(OnSqlOutputOption onSqlOutput) {
        this.onSqlOutput = onSqlOutput == null ? OnSqlOutputOption.IGNORE : onSqlOutput;
    }

    public String getOnFailMessage() {
        return this.onFailMessage;
    }

    public void setOnFailMessage(String onFailMessage) {
        this.onFailMessage = onFailMessage;
    }

    public String getOnErrorMessage() {
        return this.onErrorMessage;
    }

    public void setOnErrorMessage(String onErrorMessage) {
        this.onErrorMessage = onErrorMessage;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void check(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet) throws PreconditionFailedException, PreconditionErrorException {
        block21: {
            ranOn = String.valueOf(changeLog);
            if (changeSet != null) {
                ranOn = String.valueOf(changeSet);
            }
            executor = ExecutorService.getInstance().getExecutor(database);
            try {
                testPrecondition = false;
                if (executor.updatesDatabase()) {
                    testPrecondition = true;
                } else if (this.getOnSqlOutput().equals((Object)OnSqlOutputOption.TEST)) {
                    testPrecondition = true;
                } else {
                    if (this.getOnSqlOutput().equals((Object)OnSqlOutputOption.FAIL)) {
                        throw new PreconditionFailedException("Unexpected precondition in updateSQL mode with onUpdateSQL value: " + (Object)this.getOnSqlOutput(), changeLog, this);
                    }
                    if (this.getOnSqlOutput().equals((Object)OnSqlOutputOption.IGNORE)) {
                        testPrecondition = false;
                    }
                }
                if (testPrecondition) {
                    super.check(database, changeLog, changeSet);
                }
                break block21;
            }
            catch (PreconditionFailedException e) {
                message = new StringBuffer();
                message.append("     ").append(e.getFailedPreconditions().size()).append(" preconditions failed").append(StreamUtil.getLineSeparator());
                ** for (invalid : e.getFailedPreconditions())
            }
lbl-1000:
            // 1 sources

            {
                message.append("     ").append(invalid.toString());
                message.append(StreamUtil.getLineSeparator());
                continue;
            }
lbl30:
            // 1 sources

            if (this.getOnFailMessage() != null) {
                message = new StringBuffer(this.getOnFailMessage());
            }
            if (this.getOnFail().equals((Object)FailOption.WARN)) {
                LogFactory.getLogger().info("Executing: " + ranOn + " despite precondition failure due to onFail='WARN':\n " + message);
            } else {
                if (this.getOnFailMessage() == null) {
                    throw e;
                }
                throw new PreconditionFailedException(this.getOnFailMessage(), changeLog, this);
                catch (PreconditionErrorException e) {
                    message = new StringBuffer();
                    message.append("     ").append(e.getErrorPreconditions().size()).append(" preconditions failed").append(StreamUtil.getLineSeparator());
                    ** for (invalid : e.getErrorPreconditions())
                }
lbl-1000:
                // 1 sources

                {
                    message.append("     ").append(invalid.toString());
                    message.append(StreamUtil.getLineSeparator());
                    continue;
                }
lbl48:
                // 1 sources

                if (this.getOnError().equals((Object)ErrorOption.CONTINUE)) {
                    LogFactory.getLogger().info("Continuing past: " + this.toString() + " despite precondition error:\n " + message);
                    throw e;
                }
                if (this.getOnError().equals((Object)ErrorOption.WARN)) {
                    LogFactory.getLogger().warning("Continuing past: " + this.toString() + " despite precondition error:\n " + message);
                } else {
                    if (this.getOnErrorMessage() == null) {
                        throw e;
                    }
                    throw new PreconditionErrorException(this.getOnErrorMessage(), e.getErrorPreconditions());
                }
            }
        }
    }

    public static enum ErrorOption {
        HALT("HALT"),
        CONTINUE("CONTINUE"),
        MARK_RAN("MARK_RAN"),
        WARN("WARN");

        String key;

        private ErrorOption(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }

    public static enum FailOption {
        HALT("HALT"),
        CONTINUE("CONTINUE"),
        MARK_RAN("MARK_RAN"),
        WARN("WARN");

        String key;

        private FailOption(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }

    public static enum OnSqlOutputOption {
        IGNORE("IGNORE"),
        TEST("TEST"),
        FAIL("FAIL");

        String key;

        private OnSqlOutputOption(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }
}

