/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.csv.ValueParserFormatter;
import org.nuiton.i18n.I18n;

public class ForeignKeyListParserFormatter<E extends TuttiEntity>
implements ValueParserFormatter<List<E>> {
    public static final String LIST_SEPARATOR = ",";
    protected final String propertyName;
    protected final Class<E> entityType;
    protected final Map<String, E> universe;

    public ForeignKeyListParserFormatter(Class<E> entityType, String propertyName, Map<String, E> universe) {
        this.entityType = entityType;
        this.propertyName = propertyName;
        this.universe = universe;
    }

    public List<E> parse(String value) throws ParseException {
        ArrayList<TuttiEntity> result = new ArrayList<TuttiEntity>();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String[] ids;
            for (String id : ids = value.split(LIST_SEPARATOR)) {
                TuttiEntity entity = (TuttiEntity)this.universe.get(id);
                if (entity == null) {
                    throw new ImportRuntimeException(I18n.t((String)"tutti.service.csv.parse.entityNotFound", (Object[])new Object[]{this.entityType.getSimpleName(), this.propertyName, id}));
                }
                result.add(entity);
            }
        }
        return result;
    }

    public String format(List<E> e) {
        ArrayList<String> ids = new ArrayList<String>();
        for (TuttiEntity entity : e) {
            if (entity == null) continue;
            ids.add(entity.getId());
        }
        return StringUtils.join(ids, (String)LIST_SEPARATOR);
    }
}

