/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.i18n.CoreMessages;

public class RAFileInputStream
extends RAInputStream {
    private RandomAccessFile parent;
    private long startPos;
    private long endPos;
    private long cur;
    private byte[] buf;
    private int bufLen;
    private int bufCur;

    public RAFileInputStream(RandomAccessFile parentFile, long startPos, long endPos) {
        this.parent = parentFile;
        this.startPos = startPos;
        this.endPos = endPos;
        this.buf = new byte[8192];
        this.cur = 0L;
        this.bufLen = 0;
        this.bufCur = 0;
    }

    @Override
    public void refresh() throws IOException {
        this.bufLen = 0;
        this.bufCur = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readToBuffer() throws IOException {
        this.bufLen = 0;
        this.bufCur = 0;
        long parentPos = this.startPos + this.cur;
        long availableSize = this.endPos - parentPos;
        if (availableSize <= 0L) {
            return;
        }
        int len = this.buf.length;
        if ((long)len > availableSize) {
            len = (int)availableSize;
        }
        RandomAccessFile randomAccessFile = this.parent;
        synchronized (randomAccessFile) {
            this.parent.seek(parentPos);
            this.bufLen = this.parent.read(this.buf, 0, len);
        }
        this.cur += (long)this.bufLen;
    }

    @Override
    public int read() throws IOException {
        if (this.bufLen <= 0 || this.bufLen == this.bufCur) {
            this.readToBuffer();
        }
        if (this.bufLen <= 0) {
            return -1;
        }
        return this.buf[this.bufCur++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        while ((count = this.read1(b, off + n, len - n)) >= 0 && (n += count) < len) {
        }
        return n > 0 ? n : -1;
    }

    private int read1(byte[] b, int off, int len) throws IOException {
        if (this.bufLen <= 0 || this.bufLen == this.bufCur) {
            this.readToBuffer();
        }
        if (this.bufLen <= 0) {
            return -1;
        }
        int availableSize = this.bufLen - this.bufCur;
        if (len > availableSize) {
            len = availableSize;
        }
        System.arraycopy(this.buf, this.bufCur, b, off, len);
        this.bufCur += len;
        return len;
    }

    @Override
    public int readInt() throws IOException {
        byte[] ch = new byte[4];
        this.readFully(ch, 0, 4);
        int ret = 0;
        int i = 0;
        while (i < ch.length) {
            ret = ret << 8 & 0xFFFFFF00 | ch[i] & 0xFF;
            ++i;
        }
        return ret;
    }

    @Override
    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = this.read(b, off + n, len - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < len);
    }

    public long getStreamLength() {
        return this.endPos - this.startPos;
    }

    @Override
    public void seek(long localPos) throws IOException {
        if (this.localPosToGlobalPos(localPos) >= this.endPos) {
            throw new IOException(CoreMessages.getString("error.OutOfRange"));
        }
        if (localPos < this.cur - (long)this.bufLen || localPos > this.cur) {
            this.cur = localPos;
            this.bufCur = 0;
            this.bufLen = 0;
        } else {
            this.bufCur = this.bufLen - (int)(this.cur - localPos);
        }
    }

    @Override
    public long getOffset() throws IOException {
        return this.cur - (long)this.bufLen + (long)this.bufCur;
    }

    @Override
    public long length() throws IOException {
        return this.getStreamLength();
    }

    @Override
    public int available() throws IOException {
        long availableSize = this.endPos - this.localPosToGlobalPos(this.cur);
        if (availableSize > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (availableSize <= 0L) {
            return -1;
        }
        return (int)availableSize;
    }

    private long localPosToGlobalPos(long localPos) {
        return localPos + this.startPos;
    }
}

