// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.technical.optimization.location;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.io.Serializable;

/**
 * Table permattant de tracer les exceptions de lien père/fils à ne jamais construire.
 * Cette table permet de gérer ces exception lors du remplissage de la table LOCATION_HIERARCHY.
 * Exemple :
 * - A est père de B
 * - B est père de C et D
 * Mais D n'est pas à rattacher à A (car l'empreinte géographique ne correspond pas)
 * => Ajout d'une exception entre A et D.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class LocationHierarchyException
    implements Serializable, Comparable<LocationHierarchyException>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 7857332656835014625L;

    private LocationHierarchyExceptionPK locationHierarchyExceptionPk;

    /**
     * Get the composite primary key identifier class
     * @return locationHierarchyExceptionPk
     */
    public LocationHierarchyExceptionPK getLocationHierarchyExceptionPk()
    {
        return this.locationHierarchyExceptionPk;
    }

    /**
     * Set the composite primary key identifier class
     * @param locationHierarchyExceptionPkIn
     */
    public void setLocationHierarchyExceptionPk(LocationHierarchyExceptionPK locationHierarchyExceptionPkIn) {
        this.locationHierarchyExceptionPk = locationHierarchyExceptionPkIn;
    }

    // Generate 1 attributes
    private Float childSurfaceRatio = Float.valueOf("1.0");

    /**
     * 
     * @return this.childSurfaceRatio Float
     */
    public Float getChildSurfaceRatio()
    {
        return this.childSurfaceRatio;
    }

    /**
     * 
     * @param childSurfaceRatioIn Float
     */
    public void setChildSurfaceRatio(Float childSurfaceRatioIn)
    {
        this.childSurfaceRatio = childSurfaceRatioIn;
    }

    // Generate 2 associations
    private Location location;

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.location Location
     */
    public Location getLocation()
    {
        return this.location;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param locationIn Location
     */
    public void setLocation(Location locationIn)
    {
        this.location = locationIn;
    }

    private Location parent;

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.parent Location
     */
    public Location getParent()
    {
        return this.parent;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param parentIn Location
     */
    public void setParent(Location parentIn)
    {
        this.parent = parentIn;
    }

    /**
     * This entity does not have any identifiers
     * and is not extending any other entity,
     * so this method will only return <code>true</code> if the argument reference and <code>this</code>
     * refer to the same object.
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * and is not extending any other entity,
     * so this method will only take the identifiers of this entity into account when calculating the hash code.
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link LocationHierarchyException}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link LocationHierarchyException}.
         * @return new LocationHierarchyExceptionImpl()
         */
        public static LocationHierarchyException newInstance()
        {
            return new LocationHierarchyExceptionImpl();
        }


        /**
         * Constructs a new instance of {@link LocationHierarchyException}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param childSurfaceRatio Float
         * @param location Location
         * @param parent Location
         * @return newInstance LocationHierarchyException
         */
        public static LocationHierarchyException newInstance(Float childSurfaceRatio, Location location, Location parent)
        {
            final LocationHierarchyException entity = new LocationHierarchyExceptionImpl();
            entity.setChildSurfaceRatio(childSurfaceRatio);
            entity.setLocation(location);
            entity.setParent(parent);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(LocationHierarchyException o)
    {
        int cmp = 0;
        if (this.getLocationHierarchyExceptionPk() != null)
        {
            cmp = this.getLocationHierarchyExceptionPk().compareTo(o.getLocationHierarchyExceptionPk());
        }
            if (this.getChildSurfaceRatio() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getChildSurfaceRatio().compareTo(o.getChildSurfaceRatio()));
            }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// LocationHierarchyException.java merge-point
}