/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.style;

import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.style.IStyle;

public final class SimpleStyle
implements IStyle {
    private FontDefinition font;
    private ColorDefinition color;
    private ColorDefinition backcolor;
    private Image backimage;
    private Insets padding;
    private FormatSpecifier dateTimeFormat;
    private FormatSpecifier stringFormat;
    private FormatSpecifier numberFormat;
    private static final IGObjectFactory goFactory = GObjectFactory.instance();

    public SimpleStyle() {
    }

    public SimpleStyle(FontDefinition font, ColorDefinition color, ColorDefinition backcolor, Image backimage, Insets padding) {
        this.setFont(font);
        this.setColor(color);
        this.setBackgroundColor(backcolor);
        this.setBackgroundImage(backimage);
        this.setPadding(padding);
    }

    public SimpleStyle(IStyle src) {
        if (src != null) {
            if (src.getFont() != null) {
                this.setFont(goFactory.copyOf(src.getFont()));
            }
            if (src.getColor() != null) {
                this.setColor(goFactory.copyOf(src.getColor()));
            }
            if (src.getBackgroundColor() != null) {
                this.setBackgroundColor(goFactory.copyOf(src.getBackgroundColor()));
            }
            if (src.getBackgroundImage() != null) {
                this.setBackgroundImage(goFactory.copyOf(src.getBackgroundImage()));
            }
            if (src.getPadding() != null) {
                this.setPadding(goFactory.copyOf(src.getPadding()));
            }
            if (src.getDateTimeFormat() != null) {
                this.setDateTimeFormat(src.getDateTimeFormat().copyInstance());
            }
            if (src.getNumberFormat() != null) {
                this.setNumberFormat(src.getNumberFormat().copyInstance());
            }
            if (src.getStringFormat() != null) {
                this.setStringFormat(src.getStringFormat().copyInstance());
            }
        }
    }

    public SimpleStyle copy() {
        SimpleStyle ss = new SimpleStyle();
        if (this.font != null) {
            ss.setFont(goFactory.copyOf(this.font));
        }
        if (this.color != null) {
            ss.setColor(goFactory.copyOf(this.color));
        }
        if (this.backcolor != null) {
            ss.setBackgroundColor(goFactory.copyOf(this.backcolor));
        }
        if (this.backimage != null) {
            ss.setBackgroundImage(goFactory.copyOf(this.backimage));
        }
        if (this.padding != null) {
            ss.setPadding(goFactory.copyOf(this.padding));
        }
        if (this.dateTimeFormat != null) {
            ss.setDateTimeFormat(this.dateTimeFormat.copyInstance());
        }
        if (this.numberFormat != null) {
            ss.setNumberFormat(this.numberFormat.copyInstance());
        }
        if (this.stringFormat != null) {
            ss.setStringFormat(this.stringFormat.copyInstance());
        }
        return ss;
    }

    public void setFont(FontDefinition font) {
        this.font = font;
    }

    public void setColor(ColorDefinition color) {
        this.color = color;
    }

    public void setBackgroundColor(ColorDefinition backcolor) {
        this.backcolor = backcolor;
    }

    public void setBackgroundImage(Image backimage) {
        this.backimage = backimage;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
    }

    @Override
    public FontDefinition getFont() {
        return this.font;
    }

    @Override
    public ColorDefinition getBackgroundColor() {
        return this.backcolor;
    }

    @Override
    public Image getBackgroundImage() {
        return this.backimage;
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public ColorDefinition getColor() {
        return this.color;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.backcolor == null ? 0 : this.backcolor.hashCode());
        result = 31 * result + (this.backimage == null ? 0 : this.backimage.hashCode());
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
        result = 31 * result + (this.padding == null ? 0 : this.padding.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleStyle other = (SimpleStyle)obj;
        if (this.backcolor == null ? other.backcolor != null : !this.backcolor.equals(other.backcolor)) {
            return false;
        }
        if (this.backimage == null ? other.backimage != null : !this.backimage.equals(other.backimage)) {
            return false;
        }
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (this.font == null ? other.font != null : !this.font.equals(other.font)) {
            return false;
        }
        return !(this.padding == null ? other.padding != null : !this.padding.equals(other.padding));
    }

    @Override
    public FormatSpecifier getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(FormatSpecifier df) {
        this.dateTimeFormat = df;
    }

    @Override
    public FormatSpecifier getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(FormatSpecifier nf) {
        this.numberFormat = nf;
    }

    @Override
    public FormatSpecifier getStringFormat() {
        return this.stringFormat;
    }

    public void setStringFormat(FormatSpecifier sf) {
        this.stringFormat = sf;
    }
}

