/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;

public class TuttiNumberTickUnitSource
implements TickUnitSource,
Serializable {
    private boolean integers;
    private int power = 0;
    private int factor = 1;
    private DecimalFormat dfNeg4 = new DecimalFormat("0.0000");
    private DecimalFormat dfNeg3 = new DecimalFormat("0.000");
    private DecimalFormat dfNeg2 = new DecimalFormat("0.00");
    private DecimalFormat dfNeg1 = new DecimalFormat("0.0");
    private DecimalFormat df0 = new DecimalFormat("#,##0");
    private DecimalFormat df = new DecimalFormat("#.######E0");

    public TuttiNumberTickUnitSource(boolean integers) {
        this.integers = integers;
        this.power = 0;
        this.factor = 1;
    }

    public TickUnit getLargerTickUnit(TickUnit unit) {
        TickUnit t = this.getCeilingTickUnit(unit);
        if (t.equals((Object)unit)) {
            this.next();
            t = new NumberTickUnit(this.getTickSize(), this.getTickLabelFormat(), this.getMinorTickCount());
        }
        return t;
    }

    public TickUnit getCeilingTickUnit(TickUnit unit) {
        return this.getCeilingTickUnit(unit.getSize());
    }

    public TickUnit getCeilingTickUnit(double size) {
        if (Double.isInfinite(size)) {
            throw new IllegalArgumentException("Must be finite.");
        }
        this.power = (int)Math.ceil(Math.log10(size));
        if (this.integers) {
            this.power = Math.max(this.power, 0);
        }
        this.factor = 1;
        boolean done = false;
        while (!done) {
            boolean bl = done = !this.previous();
            if (!(this.getTickSize() < size)) continue;
            this.next();
            done = true;
        }
        return new NumberTickUnit(this.getTickSize(), this.getTickLabelFormat(), this.getMinorTickCount());
    }

    private boolean next() {
        if (this.factor == 1) {
            this.factor = 5;
            return true;
        }
        if (this.factor == 5) {
            if (this.power == 300) {
                return false;
            }
            ++this.power;
            this.factor = 1;
            return true;
        }
        throw new IllegalStateException("We should never get here.");
    }

    private boolean previous() {
        if (this.factor == 1) {
            if (this.integers && this.power == 0 || this.power == -1) {
                return false;
            }
            this.factor = 5;
            --this.power;
            return true;
        }
        if (this.factor == 5) {
            this.factor = 1;
            return true;
        }
        throw new IllegalStateException("We should never get here.");
    }

    private double getTickSize() {
        return (double)this.factor * Math.pow(10.0, this.power);
    }

    private NumberFormat getTickLabelFormat() {
        if (this.power == -4) {
            return this.dfNeg4;
        }
        if (this.power == -3) {
            return this.dfNeg3;
        }
        if (this.power == -2) {
            return this.dfNeg2;
        }
        if (this.power == -1) {
            return this.dfNeg1;
        }
        if (this.power >= 0 && this.power <= 6) {
            return this.df0;
        }
        return this.df;
    }

    private int getMinorTickCount() {
        return (int)(this.getTickSize() * (double)(this.integers ? 1 : 2));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TuttiNumberTickUnitSource)) {
            return false;
        }
        TuttiNumberTickUnitSource that = (TuttiNumberTickUnitSource)obj;
        if (this.integers != that.integers) {
            return false;
        }
        if (this.power != that.power) {
            return false;
        }
        return this.factor == that.factor;
    }
}

