/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.csv.ValueParserFormatter;
import org.nuiton.i18n.I18n;

public class ForeignKeyParserFormatter<E extends TuttiEntity>
implements ValueParserFormatter<E> {
    protected final String propertyName;
    protected final Class<E> entityType;
    protected final Map<String, E> universe;

    public ForeignKeyParserFormatter(Class<E> entityType, String propertyName, Map<String, E> universe) {
        this.entityType = entityType;
        this.propertyName = propertyName;
        this.universe = universe;
    }

    public E parse(String value) throws ParseException {
        TuttiEntity result = null;
        if (StringUtils.isNotBlank((CharSequence)value) && (result = (TuttiEntity)this.universe.get(value)) == null) {
            throw new ImportRuntimeException(I18n.t((String)"tutti.service.csv.parse.entityNotFound", (Object[])new Object[]{this.entityType.getSimpleName(), this.propertyName, value}));
        }
        return (E)result;
    }

    public String format(E e) {
        String value = "";
        if (e != null) {
            value = e.getId();
        }
        return value;
    }
}

