// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.measure;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.referential.AnalysisInstrument;
import fr.ifremer.adagio.core.dao.referential.NumericalPrecision;
import fr.ifremer.adagio.core.dao.referential.PrecisionType;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.pmfm.AggregationLevel;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import java.util.Date;

/**
 * Résulat de classement destiné à classifier un lot ou un produit.
 * Cela peut-être aussi les caractéristiques d'un produit (Produce), par exemple :
 * - Valorisation de la commercialisation : Label rouge, Eco Label, marque collective controlée par
 * un organisme tier.
 * - Destination commerciale : consommation humaine, consommation animale, etc.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class SortingMeasurement
    extends MeasurementImpl
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 7151184891629942077L;

    // Generate 1 attributes
    private Integer rankOrder;

    /**
     * Numéro d'ordre de la mesure de classement (au sein d'un un lot).
     * @return this.rankOrder Integer
     */
    public Integer getRankOrder()
    {
        return this.rankOrder;
    }

    /**
     * Numéro d'ordre de la mesure de classement (au sein d'un un lot).
     * @param rankOrderIn Integer
     */
    public void setRankOrder(Integer rankOrderIn)
    {
        this.rankOrder = rankOrderIn;
    }

    // Generate 1 associations
    private SortingBatch sortingBatch;

    /**
     * Lot auquel est rattaché le critère de classement (optionnel).
     * @return this.sortingBatch SortingBatch
     */
    public SortingBatch getSortingBatch()
    {
        return this.sortingBatch;
    }

    /**
     * Lot auquel est rattaché le critère de classement (optionnel).
     * @param sortingBatchIn SortingBatch
     */
    public void setSortingBatch(SortingBatch sortingBatchIn)
    {
        this.sortingBatch = sortingBatchIn;
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>MeasurementImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.measure.Measurement#equals(Object)
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>MeasurementImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.measure.Measurement#hashCode()
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link SortingMeasurement}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link SortingMeasurement}.
         * @return new SortingMeasurementImpl()
         */
        public static SortingMeasurement newInstance()
        {
            return new SortingMeasurementImpl();
        }

        /**
         * Constructs a new instance of {@link SortingMeasurement}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param qualityFlag QualityFlag
         * @param pmfm Pmfm
         * @param rankOrder Integer
         * @param sortingBatch SortingBatch
         * @return newInstance
         */
        public static SortingMeasurement newInstance(QualityFlag qualityFlag, Pmfm pmfm, Integer rankOrder, SortingBatch sortingBatch)
        {
            final SortingMeasurement entity = new SortingMeasurementImpl();
            entity.setQualityFlag(qualityFlag);
            entity.setPmfm(pmfm);
            entity.setRankOrder(rankOrder);
            entity.setSortingBatch(sortingBatch);
            return entity;
        }

        /**
         * Constructs a new instance of {@link SortingMeasurement}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param numericalValue Float
         * @param alphanumericalValue String
         * @param digitCount Integer
         * @param precisionValue Float
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param remoteId Integer
         * @param aggregationLevel AggregationLevel
         * @param qualityFlag QualityFlag
         * @param precisionType PrecisionType
         * @param analysisInstrument AnalysisInstrument
         * @param numericalPrecision NumericalPrecision
         * @param department Department
         * @param pmfm Pmfm
         * @param qualitativeValue QualitativeValue
         * @param rankOrder Integer
         * @param sortingBatch SortingBatch
         * @return newInstance SortingMeasurement
         */
        public static SortingMeasurement newInstance(Float numericalValue, String alphanumericalValue, Integer digitCount, Float precisionValue, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Integer remoteId, AggregationLevel aggregationLevel, QualityFlag qualityFlag, PrecisionType precisionType, AnalysisInstrument analysisInstrument, NumericalPrecision numericalPrecision, Department department, Pmfm pmfm, QualitativeValue qualitativeValue, Integer rankOrder, SortingBatch sortingBatch)
        {
            final SortingMeasurement entity = new SortingMeasurementImpl();
            entity.setNumericalValue(numericalValue);
            entity.setAlphanumericalValue(alphanumericalValue);
            entity.setDigitCount(digitCount);
            entity.setPrecisionValue(precisionValue);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setRemoteId(remoteId);
            entity.setAggregationLevel(aggregationLevel);
            entity.setQualityFlag(qualityFlag);
            entity.setPrecisionType(precisionType);
            entity.setAnalysisInstrument(analysisInstrument);
            entity.setNumericalPrecision(numericalPrecision);
            entity.setDepartment(department);
            entity.setPmfm(pmfm);
            entity.setQualitativeValue(qualitativeValue);
            entity.setRankOrder(rankOrder);
            entity.setSortingBatch(sortingBatch);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(SortingMeasurement o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getRankOrder() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRankOrder().compareTo(o.getRankOrder()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// SortingMeasurement.java merge-point
}