/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.CacheEvaluationContext;
import org.springframework.cache.interceptor.CacheExpressionRootObject;
import org.springframework.cache.interceptor.MethodCacheKey;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.ObjectUtils;

class ExpressionEvaluator {
    public static final Object NO_RESULT = new Object();
    public static final Object RESULT_UNAVAILABLE = new Object();
    public static final String RESULT_VARIABLE = "result";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private final ParameterNameDiscoverer paramNameDiscoverer = new DefaultParameterNameDiscoverer();
    private final Map<ExpressionKey, Expression> keyCache = new ConcurrentHashMap<ExpressionKey, Expression>(64);
    private final Map<ExpressionKey, Expression> conditionCache = new ConcurrentHashMap<ExpressionKey, Expression>(64);
    private final Map<ExpressionKey, Expression> unlessCache = new ConcurrentHashMap<ExpressionKey, Expression>(64);
    private final Map<MethodCacheKey, Method> targetMethodCache = new ConcurrentHashMap<MethodCacheKey, Method>(64);

    ExpressionEvaluator() {
    }

    public EvaluationContext createEvaluationContext(Collection<? extends Cache> caches, Method method, Object[] args, Object target, Class<?> targetClass) {
        return this.createEvaluationContext(caches, method, args, target, targetClass, NO_RESULT);
    }

    public EvaluationContext createEvaluationContext(Collection<? extends Cache> caches, Method method, Object[] args, Object target, Class<?> targetClass, Object result) {
        CacheExpressionRootObject rootObject = new CacheExpressionRootObject(caches, method, args, target, targetClass);
        CacheEvaluationContext evaluationContext = new CacheEvaluationContext(rootObject, this.paramNameDiscoverer, method, args, targetClass, this.targetMethodCache);
        if (result == RESULT_UNAVAILABLE) {
            evaluationContext.addUnavailableVariable(RESULT_VARIABLE);
        } else if (result != NO_RESULT) {
            evaluationContext.setVariable(RESULT_VARIABLE, result);
        }
        return evaluationContext;
    }

    public Object key(String keyExpression, MethodCacheKey methodKey, EvaluationContext evalContext) {
        return this.getExpression(this.keyCache, keyExpression, methodKey).getValue(evalContext);
    }

    public boolean condition(String conditionExpression, MethodCacheKey methodKey, EvaluationContext evalContext) {
        return (Boolean)this.getExpression(this.conditionCache, conditionExpression, methodKey).getValue(evalContext, Boolean.TYPE);
    }

    public boolean unless(String unlessExpression, MethodCacheKey methodKey, EvaluationContext evalContext) {
        return (Boolean)this.getExpression(this.unlessCache, unlessExpression, methodKey).getValue(evalContext, Boolean.TYPE);
    }

    private Expression getExpression(Map<ExpressionKey, Expression> cache, String expression, MethodCacheKey methodKey) {
        ExpressionKey key = this.createKey(methodKey, expression);
        Expression expr = cache.get(key);
        if (expr == null) {
            expr = this.parser.parseExpression(expression);
            cache.put(key, expr);
        }
        return expr;
    }

    private ExpressionKey createKey(MethodCacheKey methodCacheKey, String expression) {
        return new ExpressionKey(methodCacheKey, expression);
    }

    private static class ExpressionKey {
        private final MethodCacheKey methodCacheKey;
        private final String expression;

        public ExpressionKey(MethodCacheKey methodCacheKey, String expression) {
            this.methodCacheKey = methodCacheKey;
            this.expression = expression;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExpressionKey)) {
                return false;
            }
            ExpressionKey otherKey = (ExpressionKey)other;
            return this.methodCacheKey.equals(otherKey.methodCacheKey) && ObjectUtils.nullSafeEquals((Object)this.expression, (Object)otherKey.expression);
        }

        public int hashCode() {
            return this.methodCacheKey.hashCode() * 29 + (this.expression != null ? this.expression.hashCode() : 0);
        }
    }
}

