/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.jdbc.config.DatabasePopulatorConfigUtils;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class EmbeddedDatabaseBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    EmbeddedDatabaseBeanDefinitionParser() {
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(EmbeddedDatabaseFactoryBean.class);
        this.setDatabaseType(element, builder);
        DatabasePopulatorConfigUtils.setDatabasePopulator(element, builder);
        this.useIdAsDatabaseNameIfGiven(element, builder);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        return builder.getBeanDefinition();
    }

    private void useIdAsDatabaseNameIfGiven(Element element, BeanDefinitionBuilder builder) {
        String id = element.getAttribute("id");
        if (StringUtils.hasText((String)id)) {
            builder.addPropertyValue("databaseName", (Object)id);
        }
    }

    private void setDatabaseType(Element element, BeanDefinitionBuilder builder) {
        String type = element.getAttribute("type");
        if (StringUtils.hasText((String)type)) {
            builder.addPropertyValue("databaseType", (Object)type);
        }
    }
}

