/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.svg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.chart.device.ImageWriterFactory;
import org.eclipse.birt.chart.device.svg.EventHandlers;
import org.eclipse.birt.chart.device.svg.SVGGradientPaint;
import org.eclipse.birt.chart.device.svg.SVGImage;
import org.eclipse.birt.chart.device.svg.i18n.Messages;
import org.eclipse.birt.chart.device.util.ChartGraphics2D;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGGraphics2D
extends ChartGraphics2D {
    protected Document dom;
    protected Paint paint;
    protected Color color;
    protected Font font;
    protected Shape clip;
    protected Stroke stroke;
    protected Color background;
    protected Element currentElement;
    protected Stack<Element> parentStack = new Stack();
    protected Element currentParent;
    protected FontRenderContext fontRenderContext;
    protected AffineTransform transforms;
    protected List<SVGGradientPaint> paints = new ArrayList<SVGGradientPaint>();
    protected Set<TexturePaint> textures = new HashSet<TexturePaint>();
    protected Element definitions;
    protected Element styles;
    protected Element codeScript;
    protected String styleClass;
    protected String id;
    protected StringBuffer scriptBuffer = new StringBuffer();
    protected StringBuffer styleBuffer = new StringBuffer();
    protected Element deferStrokColor = null;
    protected String primitiveId = null;
    private RenderingHints renderingHints = new RenderingHints(null);
    protected boolean scriptable = true;
    protected static final String defaultStyles = "fill:none;stroke:none";
    protected static final char chRLE = '\u202b';
    protected static final char chPDF = '\u202c';
    protected static final String sStyleBidi = "direction:rtl; unicode-bidi:embed; ";
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.device.svg/trace");

    public SVGGraphics2D(Document dom) {
        this(dom, true);
    }

    public SVGGraphics2D(Document dom, boolean scriptable) {
        this.dom = dom;
        this.scriptable = scriptable;
        this.fontRenderContext = new FontRenderContext(new AffineTransform(), true, false);
        this.currentElement = dom.getDocumentElement();
        this.parentStack.push(this.currentElement);
        this.currentParent = this.currentElement;
        this.currentElement = dom.createElement("g");
        this.definitions = dom.createElement("defs");
        this.currentElement.setAttribute("id", "outerG");
        this.currentElement.appendChild(this.definitions);
        this.currentElement.setAttribute("style", defaultStyles);
        this.pushParent(this.currentElement);
        this.transforms = new AffineTransform();
        this.initializeScriptStyles();
    }

    public void pushParent(Element parent) {
        this.appendChild(parent);
        this.parentStack.push(parent);
        this.currentParent = parent;
    }

    public Element popParent() {
        Element popElement = null;
        if (!this.parentStack.isEmpty()) {
            popElement = this.parentStack.pop();
        }
        if (!this.parentStack.isEmpty()) {
            this.currentParent = this.parentStack.peek();
        }
        return popElement;
    }

    protected void appendChild(Element child) {
        this.currentParent.appendChild(child);
    }

    @Override
    public void draw(Shape shape) {
        this.currentElement = this.createGeneralPath(shape);
        this.appendChild(this.currentElement);
        this.setStrokeStyle(this.currentElement);
    }

    @Override
    public boolean drawImage(Image arg0, AffineTransform arg1, ImageObserver arg2) {
        logger.log(new Exception(Messages.getString("SVGGraphics2D.drawImage.image")));
        return false;
    }

    @Override
    public void drawImage(BufferedImage arg0, BufferedImageOp arg1, int arg2, int arg3) {
        logger.log(new Exception(Messages.getString("SVGGraphics2D.drawImage.buffer")));
    }

    @Override
    public void drawRenderedImage(RenderedImage arg0, AffineTransform arg1) {
        logger.log(new Exception(Messages.getString("SVGGraphics2D.drawRenderImage.RenderImage")));
    }

    @Override
    public void drawRenderableImage(RenderableImage arg0, AffineTransform arg1) {
        logger.log(new Exception(Messages.getString("SVGGraphics2D.drawRenderableImage.RenderableImage")));
    }

    private void drawString(String arg0, String sX, String sY) {
        this.currentElement = this.createText(arg0);
        this.currentElement.setAttribute("x", sX);
        this.currentElement.setAttribute("y", sY);
        this.appendChild(this.currentElement);
    }

    @Override
    public void drawString(String arg0, int arg1, int arg2) {
        this.drawString(arg0, Integer.toString(arg1), Integer.toString(arg2));
    }

    @Override
    public void drawString(String arg0, float arg1, float arg2) {
        this.drawString(arg0, SVGGraphics2D.toString(arg1), SVGGraphics2D.toString(arg2));
    }

    @Override
    public void drawString(AttributedCharacterIterator arg0, int arg1, int arg2) {
        logger.log(new Exception(Messages.getString("SVGGraphics2D.drawString.AttributeInt")));
    }

    @Override
    public void drawString(AttributedCharacterIterator arg0, float arg1, float arg2) {
        logger.log(new Exception(Messages.getString("SVGGraphics2D.drawString.AttributeFloat")));
    }

    @Override
    public void drawGlyphVector(GlyphVector glyph, float x, float y) {
        this.translate(x, y);
        Element currentElement = this.dom.createElement("g");
        Element transElement = this.createElement("g");
        currentElement.appendChild(transElement);
        this.setFillColor(transElement, true);
        int idx = 0;
        while (idx < glyph.getNumGlyphs()) {
            Element glyphElem = this.createShape(glyph.getGlyphOutline(idx));
            transElement.appendChild(glyphElem);
            ++idx;
        }
        if (this.clip != null) {
            currentElement.setAttribute("clip-path", "url(#clip" + this.clip.hashCode() + ")");
        }
        this.appendChild(currentElement);
        this.translate(-x, -y);
    }

    @Override
    public void fill(Shape shape, boolean defered) {
        Element tempDeferred = null;
        if (!defered) {
            tempDeferred = this.deferStrokColor;
            this.deferStrokColor = null;
        }
        this.currentElement = this.createGeneralPath(shape);
        this.appendChild(this.currentElement);
        this.setFillColor(this.currentElement);
        if (!defered) {
            this.deferStrokColor = tempDeferred;
        }
    }

    @Override
    public void fill(Shape shape) {
        this.currentElement = this.createGeneralPath(shape);
        this.appendChild(this.currentElement);
        this.setFillColor(this.currentElement);
    }

    @Override
    public boolean hit(Rectangle arg0, Shape arg1, boolean arg2) {
        logger.log(new Exception(Messages.getString("SVGGraphics2D.hit.Rectangle")));
        return false;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        logger.log(new Exception(Messages.getString("SVGGraphics2D.getDeviceConfig")));
        return null;
    }

    @Override
    public void setComposite(Composite arg0) {
        logger.log(new Exception(Messages.getString("SVGGraphics2D.setComposite")));
    }

    @Override
    public void setRenderingHint(RenderingHints.Key arg0, Object arg1) {
        this.renderingHints.put(arg0, arg1);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key arg0) {
        return this.renderingHints.get(arg0);
    }

    public void setRenderingHints(Map arg0) {
        this.renderingHints = new RenderingHints(arg0);
    }

    public void addRenderingHints(Map arg0) {
        this.renderingHints.add(new RenderingHints(arg0));
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    @Override
    public void translate(int arg0, int arg1) {
        String transform = this.currentElement.getAttribute("transform");
        if (transform == null) {
            transform = "";
        }
        this.currentElement.setAttribute("transform", String.valueOf(transform) + " translate(" + arg0 + " " + arg1 + ")");
    }

    @Override
    public void translate(double arg0, double arg1) {
        this.transforms.translate(arg0, arg1);
    }

    @Override
    public void rotate(double arg0) {
        this.transforms.rotate(arg0);
    }

    @Override
    public void rotate(double arg0, double arg1, double arg2) {
        this.transforms.rotate(arg0, arg1, arg2);
    }

    @Override
    public void scale(double arg0, double arg1) {
        this.transforms.scale(arg0, arg1);
    }

    @Override
    public void shear(double arg0, double arg1) {
        this.transforms.shear(arg0, arg1);
    }

    @Override
    public void transform(AffineTransform arg0) {
        this.transforms.concatenate((AffineTransform)arg0.clone());
    }

    @Override
    public void setTransform(AffineTransform transform) {
        this.transforms = transform;
    }

    @Override
    public AffineTransform getTransform() {
        return this.transforms;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Composite getComposite() {
        logger.log(new Exception(Messages.getString("SVGGraphics2D.getComposite")));
        return null;
    }

    @Override
    public void clip(Shape shape) {
        this.setClip(shape);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    @Override
    public Graphics create() {
        return new SVGGraphics2D(this.dom);
    }

    @Override
    public void setPaintMode() {
        logger.log(new Exception(Messages.getString("SVGGraphics2D.setPaintMode")));
    }

    @Override
    public void setXORMode(Color xorColor) {
        if (this.color == null || xorColor == null) {
            return;
        }
        int newColor = (xorColor.getRed() << 16) + (xorColor.getGreen() << 8) + xorColor.getBlue() ^ (this.color.getRed() << 16) + (this.color.getGreen() << 8) + this.color.getBlue();
        int r = newColor >> 16 & 0xFF;
        int g = (0xFF00 & newColor) >> 8;
        int b = 0xFF & newColor;
        this.color = new Color(r, g, b);
    }

    @Override
    public FontMetrics getFontMetrics(Font arg0) {
        logger.log(new Exception(Messages.getString("SVGGraphics2D.getFontMetrics.Font")));
        return null;
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clip.getBounds();
    }

    @Override
    public void clipRect(int arg0, int arg1, int arg2, int arg3) {
        Rectangle2D.Double rect = new Rectangle2D.Double(arg0, arg1, arg2, arg3);
        this.setClip(rect);
    }

    @Override
    public void setClip(int arg0, int arg1, int arg2, int arg3) {
        Rectangle2D.Double rect = new Rectangle2D.Double(arg0, arg1, arg2, arg3);
        this.setClip(rect);
    }

    @Override
    public void copyArea(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        logger.log(new Exception(Messages.getString("SVGGraphics2D.CopyArea.Int")));
    }

    @Override
    public void drawLine(int arg0, int arg1, int arg2, int arg3) {
        this.drawLine((double)arg0, (double)arg1, (double)arg2, (double)arg3);
    }

    public void drawLine(double arg0, double arg1, double arg2, double arg3) {
        this.currentElement = this.createLine(arg0, arg1, arg2, arg3);
        this.appendChild(this.currentElement);
        this.setStrokeStyle(this.currentElement);
    }

    @Override
    public void drawRect(int arg0, int arg1, int arg2, int arg3) {
        this.drawRect((double)arg0, (double)arg1, (double)arg2, (double)arg3);
    }

    public void drawRect(double arg0, double arg1, double arg2, double arg3) {
        this.currentElement = this.createRect(arg0, arg1, arg2, arg3);
        this.appendChild(this.currentElement);
        this.setStrokeStyle(this.currentElement);
    }

    @Override
    public void fillRect(int arg0, int arg1, int arg2, int arg3) {
        this.fillRect((double)arg0, (double)arg1, (double)arg2, (double)arg3);
    }

    public void fillRect(double arg0, double arg1, double arg2, double arg3) {
        this.currentElement = this.createRect(arg0, arg1, arg2, arg3);
        this.appendChild(this.currentElement);
        this.setFillColor(this.currentElement);
    }

    @Override
    public void clearRect(int arg0, int arg1, int arg2, int arg3) {
        logger.log(new Exception(Messages.getString("SVGGraphics2D.clearRect.Int")));
    }

    @Override
    public void drawRoundRect(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        this.currentElement = this.createRoundRect(arg0, arg1, arg2, arg3, arg4, arg5);
        this.appendChild(this.currentElement);
        this.setStrokeStyle(this.currentElement);
    }

    @Override
    public void fillRoundRect(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        this.currentElement = this.createRoundRect(arg0, arg1, arg2, arg3, arg4, arg5);
        this.appendChild(this.currentElement);
        this.setFillColor(this.currentElement);
    }

    @Override
    public void drawOval(int arg0, int arg1, int arg2, int arg3) {
        this.drawOval((double)arg0, (double)arg1, (double)arg2, (double)arg3);
    }

    public void drawOval(double arg0, double arg1, double arg2, double arg3) {
        this.currentElement = this.createOval(arg0, arg1, arg2, arg3);
        this.appendChild(this.currentElement);
        this.setStrokeStyle(this.currentElement);
    }

    @Override
    public void fillOval(int arg0, int arg1, int arg2, int arg3) {
        this.fillOval((double)arg0, (double)arg1, (double)arg2, (double)arg3);
    }

    public void fillOval(double arg0, double arg1, double arg2, double arg3) {
        this.currentElement = this.createOval(arg0, arg1, arg2, arg3);
        this.appendChild(this.currentElement);
        this.setFillColor(this.currentElement);
    }

    @Override
    public void drawArc(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        this.drawArc((double)arg0, (double)arg1, (double)arg2, (double)arg3, (double)arg4, (double)arg5);
    }

    public void drawArc(double arg0, double arg1, double arg2, double arg3, double arg4, double arg5) {
        this.currentElement = this.createArc(arg0, arg1, arg2, arg3, arg4, arg5);
        this.appendChild(this.currentElement);
        this.setStrokeStyle(this.currentElement);
    }

    protected void setStrokeStyle(Element currentElement) {
        this.setStrokeStyle(currentElement, false);
    }

    protected void setStrokeStyle(Element currentElement, boolean deferClipped) {
        String style;
        Element element = currentElement;
        if (this.deferStrokColor != null) {
            element = this.deferStrokColor;
        }
        if ((style = element.getAttribute("style")) == null) {
            style = "";
        }
        if (this.color != null) {
            style = String.valueOf(style) + "stroke:" + this.serializeToString(this.color) + ";";
        }
        if (this.stroke != null && this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            if (bs.getLineWidth() > 0.0f) {
                style = String.valueOf(style) + "stroke-width:" + bs.getLineWidth() + ";";
            }
            if (bs.getDashArray() != null) {
                StringBuffer dashArrayStr = new StringBuffer();
                int x = 0;
                while (x < bs.getDashArray().length) {
                    dashArrayStr.append(" ").append(bs.getDashArray()[x]);
                    ++x;
                }
                if (!dashArrayStr.toString().equals("")) {
                    style = String.valueOf(style) + "stroke-dasharray:" + dashArrayStr + ";";
                }
            }
            style = String.valueOf(style) + "stroke-miterlimit:" + bs.getMiterLimit() + ";";
            switch (bs.getLineJoin()) {
                case 2: {
                    style = String.valueOf(style) + "stroke-linejoin:bevel;";
                    break;
                }
                case 1: {
                    style = String.valueOf(style) + "stroke-linejoin:round;";
                }
            }
            switch (bs.getEndCap()) {
                case 1: {
                    style = String.valueOf(style) + "stroke-linecap:round;";
                    break;
                }
                case 2: {
                    style = String.valueOf(style) + "stroke-linecap:square;";
                }
            }
        }
        element.setAttribute("style", style);
        if (this.styleClass != null) {
            element.setAttribute("class", this.styleClass);
        }
        if (this.id != null) {
            element.setAttribute("id", this.id);
        }
        if (this.clip != null && !deferClipped) {
            element.setAttribute("clip-path", "url(#clip" + this.clip.hashCode() + ")");
        }
    }

    protected void setFillColor(Element currentElement) {
        this.setFillColor(currentElement, false);
    }

    protected void setNoFillColor(Element currentElement) {
        String style = currentElement.getAttribute("style");
        if (style == null) {
            style = "";
        }
        currentElement.setAttribute("style", String.valueOf(style) + "fill:none;");
    }

    protected void setFillColor(Element currentElement, boolean deferClipped) {
        String style;
        Element element = currentElement;
        if (this.deferStrokColor != null) {
            element = this.deferStrokColor;
        }
        if ((style = element.getAttribute("style")) == null) {
            style = "";
        }
        if (this.paint == null) {
            if (this.color == null) {
                return;
            }
            String alpha = this.alphaToString(this.color);
            if (alpha != null) {
                style = String.valueOf(style) + "fill-opacity:" + alpha + ";";
            }
            element.setAttribute("style", String.valueOf(style) + "fill:" + this.serializeToString(this.color) + ";stroke:none;");
        } else if (this.paint instanceof SVGGradientPaint) {
            element.setAttribute("style", String.valueOf(style) + "fill:url(#" + ((SVGGradientPaint)this.paint).getId() + ");stroke:none;fill-opacity:1.0");
        } else if (this.paint instanceof TexturePaint) {
            element.setAttribute("style", String.valueOf(style) + "fill:url(#" + this.getTextureId((TexturePaint)this.paint) + ");stroke:none;fill-opacity:1.0");
        }
        if (this.styleClass != null) {
            element.setAttribute("class", this.styleClass);
        }
        if (this.id != null) {
            element.setAttribute("id", this.id);
        }
        if (this.clip != null && !deferClipped) {
            element.setAttribute("clip-path", "url(#clip" + this.clip.hashCode() + ")");
        }
    }

    protected String serializeToString(Color color) {
        String r = Integer.toHexString(color.getRed());
        if (color.getRed() <= 15) {
            r = "0" + r;
        }
        String g = Integer.toHexString(color.getGreen());
        if (color.getGreen() <= 15) {
            g = "0" + g;
        }
        String b = Integer.toHexString(color.getBlue());
        if (color.getBlue() <= 15) {
            b = "0" + b;
        }
        String ret = "#" + r + g + b;
        return ret;
    }

    protected String alphaToString(Color color) {
        double a = 1.0;
        if (color.getAlpha() < 255) {
            a = (double)color.getAlpha() / 255.0;
        }
        return SVGGraphics2D.toString(a);
    }

    @Override
    public void fillArc(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        this.fillArc((double)arg0, (double)arg1, (double)arg2, (double)arg3, (double)arg4, (double)arg5);
    }

    public void fillArc(double arg0, double arg1, double arg2, double arg3, double arg4, double arg5) {
        this.currentElement = this.createArc(arg0, arg1, arg2, arg3, arg4, arg5);
        this.appendChild(this.currentElement);
        this.setFillColor(this.currentElement);
    }

    @Override
    public void drawPolyline(int[] arg0, int[] arg1, int arg2) {
        this.currentElement = this.createPolyline(arg0, arg1, arg2);
        this.appendChild(this.currentElement);
        this.setStrokeStyle(this.currentElement);
    }

    @Override
    public void drawPolygon(int[] arg0, int[] arg1, int arg2) {
        this.currentElement = this.createPolygon(arg0, arg1, arg2);
        this.appendChild(this.currentElement);
        this.setStrokeStyle(this.currentElement);
    }

    @Override
    public void fillPolygon(int[] arg0, int[] arg1, int arg2) {
        this.currentElement = this.createPolygon(arg0, arg1, arg2);
        this.appendChild(this.currentElement);
        this.setFillColor(this.currentElement);
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, ImageObserver arg3) {
        SVGImage image = (SVGImage)arg0;
        Element currentElement = this.createElement("image");
        currentElement.setAttribute("xlink:href", image.getUrl());
        currentElement.setAttribute("x", SVGGraphics2D.toString(arg1));
        currentElement.setAttribute("y", SVGGraphics2D.toString(arg2));
        currentElement.setAttribute("width", Integer.toString(arg0.getWidth(arg3)));
        currentElement.setAttribute("height", Integer.toString(arg0.getHeight(arg3)));
        if (this.clip != null) {
            currentElement.setAttribute("clip-path", "url(#clip" + this.clip.hashCode() + ")");
        }
        this.appendChild(currentElement);
        return true;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, int arg3, int arg4, ImageObserver arg5) {
        SVGImage image = (SVGImage)arg0;
        Element currentElement = this.createElement("image");
        currentElement.setAttribute("xlink:href", image.getUrl());
        currentElement.setAttribute("x", SVGGraphics2D.toString(arg1));
        currentElement.setAttribute("y", SVGGraphics2D.toString(arg2));
        currentElement.setAttribute("width", SVGGraphics2D.toString(arg3));
        currentElement.setAttribute("height", SVGGraphics2D.toString(arg4));
        if (this.clip != null) {
            currentElement.setAttribute("clip-path", "url(#clip" + this.clip.hashCode() + ")");
        }
        this.appendChild(currentElement);
        return true;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, Color arg3, ImageObserver arg4) {
        SVGImage image = (SVGImage)arg0;
        image.getUrl();
        Element currentElement = this.createElement("image");
        currentElement.setAttribute("x", SVGGraphics2D.toString(arg1));
        currentElement.setAttribute("y", SVGGraphics2D.toString(arg2));
        currentElement.setAttribute("width", Integer.toString(arg0.getWidth(arg4)));
        currentElement.setAttribute("height", Integer.toString(arg0.getHeight(arg4)));
        currentElement.setAttribute("fill", this.serializeToString(arg3));
        if (this.clip != null) {
            currentElement.setAttribute("clip-path", "url(#clip" + this.clip.hashCode() + ")");
        }
        this.appendChild(currentElement);
        return true;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, int arg3, int arg4, Color arg5, ImageObserver arg6) {
        SVGImage image = (SVGImage)arg0;
        Element currentElement = this.createElement("image");
        currentElement.setAttribute("xlink:href", image.getUrl());
        currentElement.setAttribute("x", SVGGraphics2D.toString(arg1));
        currentElement.setAttribute("y", SVGGraphics2D.toString(arg2));
        currentElement.setAttribute("width", SVGGraphics2D.toString(arg3));
        currentElement.setAttribute("height", SVGGraphics2D.toString(arg4));
        currentElement.setAttribute("fill", this.serializeToString(arg5));
        if (this.clip != null) {
            currentElement.setAttribute("clip-path", "url(#clip" + this.clip.hashCode() + ")");
        }
        this.appendChild(currentElement);
        return true;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, ImageObserver arg9) {
        SVGImage image = (SVGImage)arg0;
        Element currentElement = this.createElement("image");
        currentElement.setAttribute("xlink:href", image.getUrl());
        currentElement.setAttribute("x", SVGGraphics2D.toString(arg1));
        currentElement.setAttribute("y", SVGGraphics2D.toString(arg2));
        currentElement.setAttribute("width", SVGGraphics2D.toString(arg3));
        currentElement.setAttribute("height", SVGGraphics2D.toString(arg4));
        if (this.clip != null) {
            currentElement.setAttribute("clip-path", "url(#clip" + this.clip.hashCode() + ")");
        }
        this.appendChild(currentElement);
        return true;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, Color arg9, ImageObserver arg10) {
        SVGImage image = (SVGImage)arg0;
        Element currentElement = this.createElement("image");
        currentElement.setAttribute("xlink:href", image.getUrl());
        currentElement.setAttribute("x", SVGGraphics2D.toString(arg1));
        currentElement.setAttribute("y", SVGGraphics2D.toString(arg2));
        currentElement.setAttribute("width", SVGGraphics2D.toString(arg3));
        currentElement.setAttribute("height", SVGGraphics2D.toString(arg4));
        currentElement.setAttribute("fill", this.serializeToString(arg9));
        if (this.clip != null) {
            currentElement.setAttribute("clip-path", "url(#clip" + this.clip.hashCode() + ")");
        }
        this.appendChild(currentElement);
        return true;
    }

    public void flush() {
        StringBuffer buffer = new StringBuffer(EventHandlers.getJSMenuLib());
        this.codeScript.appendChild(this.dom.createCDATASection(buffer.append(this.scriptBuffer).toString()));
        buffer = new StringBuffer(EventHandlers.STYLES.toString());
        this.styles.appendChild(this.dom.createCDATASection(buffer.append(this.styleBuffer).toString()));
        this.scriptBuffer = new StringBuffer();
        this.styleBuffer = new StringBuffer();
    }

    @Override
    public void dispose() {
        this.paints.clear();
        this.textures.clear();
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Color background) {
        this.background = background;
    }

    @Override
    public Shape getClip() {
        return this.clip;
    }

    @Override
    public void setClip(Shape clip) {
        this.clip = clip;
        if (clip != null) {
            Element clipPath = this.dom.createElement("clipPath");
            clipPath.setAttribute("id", "clip" + clip.hashCode());
            clipPath.appendChild(this.createGeneralPath(clip));
            this.definitions.appendChild(clipPath);
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        this.paint = null;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    private Element createEmbeddeImage(BufferedImage img) {
        String sUrl;
        int height;
        int width;
        block6: {
            if (img == null) {
                return null;
            }
            width = img.getWidth();
            height = img.getHeight();
            ImageWriter iw = ImageWriterFactory.instance().createByFormatName("png");
            ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
            sUrl = null;
            try {
                try {
                    ImageOutputStream ios = SecurityUtil.newImageOutputStream(baos);
                    ImageWriteParam iwp = iw.getDefaultWriteParam();
                    iw.setOutput(ios);
                    iw.write(null, new IIOImage(img, null, null), iwp);
                    img.flush();
                    ios.close();
                    sUrl = "data:;base64," + new String(Base64.encodeBase64(baos.toByteArray()));
                }
                catch (Exception ex) {
                    logger.log(ex);
                    iw.dispose();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                iw.dispose();
                throw throwable;
            }
            iw.dispose();
        }
        Element elemG = this.dom.createElement("g");
        elemG.setAttribute("id", "img_" + img.hashCode());
        Element elem = this.dom.createElement("image");
        elem.setAttribute("x", "0");
        elem.setAttribute("y", "0");
        elem.setAttribute("width", Integer.toString(width));
        elem.setAttribute("height", Integer.toString(height));
        elem.setAttribute("xlink:href", sUrl);
        elemG.appendChild(elem);
        return elemG;
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint instanceof GradientPaint) {
            SVGGradientPaint gp = new SVGGradientPaint((GradientPaint)paint);
            int index = this.paints.indexOf(gp);
            if (index == -1) {
                this.paints.add(gp);
                this.definitions.appendChild(this.createGradientPaint(gp, false));
                this.definitions.appendChild(this.createGradientPaint(gp, true));
            } else {
                gp = this.paints.get(index);
            }
            this.paint = gp;
        } else if (paint instanceof TexturePaint) {
            TexturePaint tp = (TexturePaint)paint;
            if (!this.textures.contains(tp)) {
                this.textures.add(tp);
                Element elemImg = this.createEmbeddeImage(tp.getImage());
                if (elemImg != null) {
                    this.definitions.appendChild(elemImg);
                    String imgId = elemImg.getAttribute("id");
                    this.definitions.appendChild(this.createTexturePaint(tp, imgId, false));
                    this.definitions.appendChild(this.createTexturePaint(tp, imgId, true));
                }
            }
            this.paint = tp;
        } else {
            this.paint = paint;
        }
    }

    protected Element createGradientPaint(SVGGradientPaint paint, boolean highlight) {
        Element elem = this.dom.createElement("linearGradient");
        if (highlight) {
            elem.setAttribute("id", String.valueOf(paint.getId()) + "h");
        } else {
            elem.setAttribute("id", paint.getId());
        }
        elem.setAttribute("x1", SVGGraphics2D.toString(paint.getPoint1().getX()));
        elem.setAttribute("y1", SVGGraphics2D.toString(paint.getPoint1().getY()));
        elem.setAttribute("x2", SVGGraphics2D.toString(paint.getPoint2().getX()));
        elem.setAttribute("y2", SVGGraphics2D.toString(paint.getPoint2().getY()));
        elem.setAttribute("gradientUnits", "userSpaceOnUse");
        if (paint.isCyclic()) {
            elem.setAttribute("spreadMethod", "repeat");
        }
        Element startColor = this.dom.createElement("stop");
        startColor.setAttribute("offset", "0%");
        if (highlight) {
            startColor.setAttribute("stop-color", this.serializeHighlightToString(paint.getColor1()));
        } else {
            startColor.setAttribute("stop-color", this.serializeToString(paint.getColor1()));
        }
        String alpha = this.alphaToString(paint.getColor1());
        if (alpha != null) {
            startColor.setAttribute("stop-opacity", alpha);
        }
        elem.appendChild(startColor);
        Element endColor = this.dom.createElement("stop");
        endColor.setAttribute("offset", "100%");
        if (highlight) {
            endColor.setAttribute("stop-color", this.serializeHighlightToString(paint.getColor2()));
        } else {
            endColor.setAttribute("stop-color", this.serializeToString(paint.getColor2()));
        }
        alpha = this.alphaToString(paint.getColor2());
        if (alpha != null) {
            endColor.setAttribute("stop-opacity", alpha);
        }
        elem.appendChild(endColor);
        return elem;
    }

    private String getTextureId(TexturePaint paint) {
        return "tp" + paint.hashCode();
    }

    protected Element createTexturePaint(TexturePaint paint, String imgId, boolean highlight) {
        Element elem = this.dom.createElement("pattern");
        if (highlight) {
            elem.setAttribute("id", String.valueOf(this.getTextureId(paint)) + "h");
        } else {
            elem.setAttribute("id", this.getTextureId(paint));
        }
        BufferedImage img = paint.getImage();
        int width = img.getWidth();
        int height = img.getHeight();
        elem.setAttribute("patternUnits", "userSpaceOnUse");
        elem.setAttribute("width", Integer.toString(width));
        elem.setAttribute("height", Integer.toString(height));
        Element elemUse = this.dom.createElement("use");
        elemUse.setAttribute("x", "0");
        elemUse.setAttribute("y", "0");
        elemUse.setAttribute("xlink:href", "#" + imgId);
        elem.appendChild(elemUse);
        return elem;
    }

    private String serializeHighlightToString(Color cd) {
        if (cd != null) {
            int red = (cd.getRed() + 255) / 2;
            int green = (cd.getGreen() + 255) / 2;
            int blue = (cd.getBlue() + 255) / 2;
            String r = Integer.toHexString(red);
            if (red <= 15) {
                r = "0" + r;
            }
            String g = Integer.toHexString(green);
            if (green <= 15) {
                g = "0" + g;
            }
            String b = Integer.toHexString(blue);
            if (blue <= 15) {
                b = "0" + b;
            }
            return "#" + r + g + b;
        }
        return "";
    }

    protected Element createLine(double arg0, double arg1, double arg2, double arg3) {
        Element elem = this.createElement("line");
        elem.setAttribute("x1", SVGGraphics2D.toString(arg0));
        elem.setAttribute("y1", SVGGraphics2D.toString(arg1));
        elem.setAttribute("x2", SVGGraphics2D.toString(arg2));
        elem.setAttribute("y2", SVGGraphics2D.toString(arg3));
        return elem;
    }

    protected Element createShape(Shape shape) {
        PathIterator pathIter = shape.getPathIterator(null);
        StringBuffer pathStr = new StringBuffer();
        while (!pathIter.isDone()) {
            double[] points = new double[6];
            int TYPE = pathIter.currentSegment(points);
            switch (TYPE) {
                case 4: {
                    pathStr.append(" Z");
                    break;
                }
                case 1: {
                    pathStr.append(" L").append(SVGGraphics2D.toString(points, 2, ' '));
                    break;
                }
                case 2: {
                    pathStr.append(" Q").append(SVGGraphics2D.toString(points, 4, ' '));
                    break;
                }
                case 3: {
                    pathStr.append(" C").append(SVGGraphics2D.toString(points, 6, ' '));
                    break;
                }
                case 0: {
                    pathStr.append(" M").append(SVGGraphics2D.toString(points, 2, ' '));
                }
            }
            pathIter.next();
        }
        Element elem = this.dom.createElement("path");
        elem.setAttribute("d", pathStr.toString());
        return elem;
    }

    protected Element createGeneralPath(Shape path) {
        Element elem = this.createShape(path);
        if (this.transforms.getType() != 0) {
            double[] matrix = new double[6];
            this.transforms.getMatrix(matrix);
            elem.setAttribute("transform", "matrix(" + SVGGraphics2D.toString(matrix, ',') + ")");
        }
        return elem;
    }

    protected Element createText(String text) {
        boolean bRtl = false;
        if (text.length() > 0) {
            int iEnd = text.length();
            if ('\u202c' == text.charAt(text.length() - 1)) {
                --iEnd;
            }
            if ('\u202b' == text.charAt(0)) {
                bRtl = true;
                text = text.substring(1, iEnd);
            }
        }
        Element elem = this.dom.createElement("text");
        elem.appendChild(this.dom.createTextNode(text));
        switch (this.getFont().getStyle()) {
            case 1: {
                elem.setAttribute("font-weight", "bold");
                break;
            }
            case 2: {
                elem.setAttribute("font-style", "italic");
                break;
            }
            case 3: {
                elem.setAttribute("font-style", "italic");
                elem.setAttribute("font-weight", "bold");
            }
        }
        String textDecorator = null;
        Map<TextAttribute, ?> attributes = this.getFont().getAttributes();
        if (attributes.get(TextAttribute.UNDERLINE) == TextAttribute.UNDERLINE_ON) {
            textDecorator = "underline";
        }
        if (attributes.get(TextAttribute.STRIKETHROUGH) == TextAttribute.STRIKETHROUGH_ON) {
            textDecorator = textDecorator == null ? "line-through" : String.valueOf(textDecorator) + ",line-through";
        }
        if (textDecorator != null) {
            elem.setAttribute("text-decoration", textDecorator);
        }
        elem.setAttribute("xml:space", "preserve");
        elem.setAttribute("stroke", "none");
        elem.setAttribute("font-family", this.getFont().getName());
        elem.setAttribute("font-size", Integer.toString(this.getFont().getSize()));
        String style = this.getRenderingStyle(RenderingHints.KEY_TEXT_ANTIALIASING);
        if (this.color != null) {
            String alpha = this.alphaToString(this.color);
            if (alpha != null) {
                style = String.valueOf(style) + "fill-opacity:" + alpha + ";";
            }
            style = String.valueOf(style) + "fill:" + this.serializeToString(this.color) + ";";
        }
        if (bRtl) {
            style = String.valueOf(style) + sStyleBidi;
        }
        elem.setAttribute("style", style);
        if (this.transforms.getType() != 0) {
            double[] matrix = new double[6];
            this.transforms.getMatrix(matrix);
            elem.setAttribute("transform", "matrix(" + SVGGraphics2D.toString(matrix, ',') + ")");
        }
        return elem;
    }

    protected String getRenderingStyle(Object key) {
        Object value = this.renderingHints.get(key);
        if (key.equals(RenderingHints.KEY_TEXT_ANTIALIASING)) {
            if (value.equals(RenderingHints.VALUE_TEXT_ANTIALIAS_OFF)) {
                if (this.transforms.getType() != 0) {
                    return "text-rendering:optimizeSpeed;";
                }
                return "text-rendering:optimizeLegibility;";
            }
            return "";
        }
        return "";
    }

    protected Element createRect(double arg0, double arg1, double arg2, double arg3) {
        Element elem = this.createElement("rect");
        elem.setAttribute("x", SVGGraphics2D.toString(arg0));
        elem.setAttribute("y", SVGGraphics2D.toString(arg1));
        elem.setAttribute("width", SVGGraphics2D.toString(arg2));
        elem.setAttribute("height", SVGGraphics2D.toString(arg3));
        return elem;
    }

    protected Element createRoundRect(double arg0, double arg1, double arg2, double arg3, double arg4, double arg5) {
        Element elem = this.createElement("rect");
        elem.setAttribute("x", SVGGraphics2D.toString(arg0));
        elem.setAttribute("y", SVGGraphics2D.toString(arg1));
        elem.setAttribute("width", SVGGraphics2D.toString(arg2));
        elem.setAttribute("height", SVGGraphics2D.toString(arg3));
        elem.setAttribute("rx", SVGGraphics2D.toString(arg2));
        elem.setAttribute("ry", SVGGraphics2D.toString(arg3));
        return elem;
    }

    protected Element createOval(double arg0, double arg1, double arg2, double arg3) {
        Element elem = this.createElement("ellipse");
        elem.setAttribute("cx", SVGGraphics2D.toString(arg0));
        elem.setAttribute("cy", SVGGraphics2D.toString(arg1));
        elem.setAttribute("rx", SVGGraphics2D.toString(arg2));
        elem.setAttribute("ry", SVGGraphics2D.toString(arg3));
        return elem;
    }

    protected Element createArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        Element elem = this.createElement("path");
        double startX = x * Math.cos(startAngle);
        double startY = y * Math.sin(startAngle);
        double endX = x * Math.cos(startAngle + arcAngle);
        double endY = y * Math.sin(startAngle + arcAngle);
        int sweepFlag = arcAngle < 0.0 ? 0 : 1;
        elem.setAttribute("d", "M" + SVGGraphics2D.toString(startX) + "," + SVGGraphics2D.toString(startY) + " a" + SVGGraphics2D.toString(width / 2.0) + "," + SVGGraphics2D.toString(height / 2.0) + " " + SVGGraphics2D.toString(Math.abs(arcAngle)) + " 0 " + sweepFlag + " " + SVGGraphics2D.toString(endX) + " " + SVGGraphics2D.toString(endY));
        return elem;
    }

    public Element createPolyline(int[] arg0, int[] arg1, int arg2) {
        Element elem = this.createElement("polyline");
        StringBuffer pointsStr = new StringBuffer();
        int x = 0;
        while (x < arg2) {
            pointsStr.append(arg0[x]).append(",").append(arg1[x]).append(" ");
            ++x;
        }
        elem.setAttribute("points", pointsStr.toString());
        return elem;
    }

    public Element createPolygon(int[] arg0, int[] arg1, int arg2) {
        Element elem = this.createElement("polygon");
        StringBuffer pointsStr = new StringBuffer();
        int x = 0;
        while (x < arg2) {
            pointsStr.append(arg0[x]).append(",").append(arg1[x]).append(" ");
            ++x;
        }
        elem.setAttribute("points", pointsStr.toString());
        return elem;
    }

    public Element createPolygon(double[] arg0, double[] arg1, int arg2) {
        Element elem = this.createElement("polygon");
        StringBuffer pointsStr = new StringBuffer();
        int x = 0;
        while (x < arg2) {
            pointsStr.append(arg0[x]).append(",").append(arg1[x]).append(" ");
            ++x;
        }
        elem.setAttribute("points", pointsStr.toString());
        return elem;
    }

    protected void initializeScriptStyles() {
        this.codeScript = this.dom.createElement("script");
        if (this.scriptable) {
            this.appendChild(this.codeScript);
        }
        this.styles = this.dom.createElement("style");
        this.styles.setAttribute("type", "text/css");
        this.appendChild(this.styles);
    }

    protected Element createElement(String id) {
        Element elem = this.dom.createElement(id);
        if (this.primitiveId != null) {
            elem.setAttribute("id", this.primitiveId);
        }
        if (this.transforms.getType() != 0) {
            double[] matrix = new double[6];
            this.transforms.getMatrix(matrix);
            elem.setAttribute("transform", "matrix(" + SVGGraphics2D.toString(matrix, ',') + ")");
        }
        return elem;
    }

    public void drawTooltip(String tooltip) {
        Element title = this.dom.createElement("title");
        title.appendChild(this.dom.createTextNode(tooltip));
        this.appendChild(title);
        this.currentParent.setAttribute("onmouseout", "TM.remove()");
        this.currentParent.setAttribute("onmouseover", "TM.show(evt)");
    }

    public Element getCurrentParent() {
        return this.currentParent;
    }

    public Element getCurrentElement() {
        return this.currentElement;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public void addCSSStyle(String className, String styleName, String styleValue) {
        this.styleBuffer.append(className).append("{").append(styleName).append(":").append(styleValue).append(";}");
    }

    public void addScript(String script) {
        this.scriptBuffer.append(script);
    }

    public void addScriptRef(String ref) {
        Element rootElem = this.dom.getDocumentElement();
        Element scriptElem = this.dom.createElement("script");
        if (this.scriptable) {
            rootElem.appendChild(scriptElem);
        }
        scriptElem.setAttribute("language", "JavaScript");
        scriptElem.setAttribute("xlink:href", ref);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Element getDeferStrokColor() {
        return this.deferStrokColor;
    }

    public void setDeferStrokColor(Element deferStrokColor) {
        this.deferStrokColor = deferStrokColor;
    }

    public String getPrimitiveId() {
        return this.primitiveId;
    }

    public void setPrimitiveId(String primitiveId) {
        this.primitiveId = primitiveId;
    }

    public boolean isScriptable() {
        return this.scriptable;
    }

    public void setScriptable(boolean scriptable) {
        this.scriptable = scriptable;
    }

    static String toString(double v) {
        if (Double.isNaN(v)) {
            return "0";
        }
        return String.valueOf(v);
    }

    static String toString(float v) {
        if (Float.isNaN(v)) {
            return "0";
        }
        return String.valueOf(v);
    }

    static String toString(double[] v, char separator) {
        return SVGGraphics2D.toString(v, v.length, separator);
    }

    static String toString(double[] v, int length, char separator) {
        if (v.length == 0) {
            return "";
        }
        if (v.length == 1) {
            return SVGGraphics2D.toString(v[0]);
        }
        if (length > v.length) {
            length = v.length;
        }
        StringBuffer buffer = new StringBuffer(SVGGraphics2D.toString(v[0]));
        int i = 1;
        while (i < length) {
            buffer.append(separator);
            buffer.append(SVGGraphics2D.toString(v[i]));
            ++i;
        }
        return buffer.toString();
    }
}

