/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersistenceHelper;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForMarineLitter;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportMarineLitterAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportMarineLitterAction.class);
    private final GenericformatImportPersistenceHelper persistenceHelper;

    public ImportMarineLitterAction(GenericFormatImportContext importContext, GenericformatImportPersistenceHelper persistenceHelper) {
        super(importContext);
        this.persistenceHelper = persistenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid() && this.importContext.getSurveyFileResult().isValid() && this.importContext.getOperationFileResult().isValid() && this.importContext.getImportRequest().isImportMarineLitter();
    }

    @Override
    protected void skipExecute() {
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.skip.import.marineLitters", (Object[])new Object[0]));
        if (!this.importContext.getImportRequest().isImportMarineLitter()) {
            GenericFormatCsvFileResult importFileResult = this.importContext.getMarineLitterFileResult();
            importFileResult.setSkipped(true);
        }
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Import marineLitter.csv file.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.marineLitters", (Object[])new Object[0]));
        GenericFormatCsvFileResult importFileResult = this.importContext.getMarineLitterFileResult();
        try (CsvConsumerForMarineLitter consumer = this.importContext.loadMarineLitters(true);){
            for (ImportRow row : consumer) {
                GenericFormatImportOperationContext operationContext = consumer.validateRow(row, this.importContext);
                if (operationContext == null) continue;
                consumer.prepareRowForPersist(operationContext, row);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close marineLitter.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
        this.persistMarineLitterBatches();
    }

    public void persistMarineLitterBatches() {
        this.importContext.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                for (GenericFormatImportOperationContext fishingOperationContext : cruiseContext) {
                    boolean override = fishingOperationContext.isOverride();
                    if (override) {
                        this.deleteMarineLitterBatches(fishingOperationContext);
                    }
                    String cruiseStr = cruiseContext.getCruiseLabel();
                    String operationStr = fishingOperationContext.getFishingOperationLabel();
                    ImportMarineLitterAction.this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.operation.marineLitters", (Object[])new Object[]{cruiseStr, operationStr}));
                    if (!fishingOperationContext.withMarineLitterBatches()) continue;
                    Collection<MarineLitterBatch> marineLitterBatches = fishingOperationContext.getMarineLitterBatches();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Persist " + marineLitterBatches.size() + " marine litter(s) of " + operationStr + " for cruise: " + cruiseStr));
                    }
                    this.persistMarineLitterBatches(marineLitterBatches);
                }
            }

            private void persistMarineLitterBatches(Collection<MarineLitterBatch> batches) {
                for (MarineLitterBatch marineLitterBatch : batches) {
                    Integer objectId = marineLitterBatch.getIdAsInt();
                    Collection<AttachmentRow> attachmentRows = ImportMarineLitterAction.this.importContext.popAttachmentRows(ObjectTypeCode.BATCH, objectId);
                    marineLitterBatch.setId((String)null);
                    MarineLitterBatch createdMarineLitterBatch = ImportMarineLitterAction.this.persistenceHelper.createMarineLitterBatch(marineLitterBatch);
                    ImportMarineLitterAction.this.persistenceHelper.persistAttachments(createdMarineLitterBatch.getIdAsInt(), attachmentRows);
                }
            }

            private void deleteMarineLitterBatches(GenericFormatImportOperationContext fishingOperationContext) {
                FishingOperation fishingOperation = fishingOperationContext.getFishingOperation();
                ImportMarineLitterAction.this.persistenceHelper.deleteMarineLitterForFishingOperation(fishingOperation.getId());
            }
        });
    }
}

