/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import fr.ifremer.adagio.core.dao.technical.DatabaseSchemaDao;
import fr.ifremer.adagio.core.dao.technical.DatabaseSchemaUpdateException;
import fr.ifremer.adagio.core.dao.technical.VersionNotFoundException;
import fr.ifremer.adagio.core.service.technical.CacheService;
import fr.ifremer.adagio.core.service.technical.sanity.DatabaseSanityService;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.TechnicalPersistenceService;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.util.version.Version;
import org.nuiton.util.version.Versions;
import org.springframework.stereotype.Service;

@Service(value="technicalPersistenceService")
public class TechnicalPersistenceServiceImpl
extends AbstractPersistenceService
implements TechnicalPersistenceService {
    private static final Log log = LogFactory.getLog(TechnicalPersistenceServiceImpl.class);
    @Resource(name="databaseSanityService")
    protected DatabaseSanityService databaseSanityService;
    @Resource(name="cacheService")
    protected CacheService cacheService;
    @Resource(name="databaseSchemaDao")
    protected DatabaseSchemaDao databaseSchemaDao;

    @Override
    public <V> V invoke(Callable<V> call) {
        try {
            V result = call.call();
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException((Throwable)e);
        }
    }

    @Override
    public Version getDbVersion() {
        Version version = this.getDbVersion0();
        return version;
    }

    private Version getDbVersion0() {
        fr.ifremer.adagio.core.dao.technical.Version version;
        try {
            version = this.databaseSchemaDao.getSchemaVersion();
        }
        catch (VersionNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not find db version", (Throwable)e);
            }
            version = null;
        }
        return version == null ? null : Versions.valueOf((String)version.toString());
    }

    @Override
    public Version getApplicationVersion() {
        fr.ifremer.adagio.core.dao.technical.Version version = this.databaseSchemaDao.getSchemaVersionIfUpdate();
        return Versions.valueOf((String)version.toString());
    }

    @Override
    public void updateSchema() {
        try {
            this.databaseSchemaDao.updateSchema();
        }
        catch (DatabaseSchemaUpdateException e) {
            throw new ApplicationTechnicalException(e.getCause());
        }
    }

    @Override
    public void sanityDb() {
        this.databaseSanityService.sanity();
    }

    @Override
    public void clearAllCaches() {
        this.cacheService.clearAllCaches();
    }
}

