/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri;

import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.pupitri.Signs;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableFloat;

public class PupitriCatch
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MELAG_META_SPECIES = "MELA-NGE";
    protected Species species;
    protected boolean sorted;
    protected Map<Signs, MutableFloat> weightBySign = Maps.newHashMap();

    public PupitriCatch(Species species, boolean sorted) {
        this.species = species;
        this.sorted = sorted;
    }

    public Species getSpecies() {
        return this.species;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public boolean isForMelag() {
        return this.weightBySign.containsKey((Object)Signs.MELAG);
    }

    public boolean isMelagMetaSpecies() {
        boolean melagMetaSpecies = MELAG_META_SPECIES.equals(this.species.getSurveyCode());
        return melagMetaSpecies;
    }

    public Float getWeight(Signs signs) {
        MutableFloat mutableFloat = this.weightBySign.get((Object)signs);
        return mutableFloat == null ? null : Float.valueOf(mutableFloat.floatValue());
    }

    public Map<Signs, MutableFloat> getWeightBySign() {
        return this.weightBySign;
    }

    public void addToSign(Signs sign, Float weight) {
        MutableFloat f = this.weightBySign.get((Object)sign);
        if (f == null) {
            f = new MutableFloat();
            this.weightBySign.put(sign, f);
        }
        f.add((Number)weight);
    }

    public void removeSign(Signs sign) {
        this.weightBySign.remove((Object)sign);
    }

    public int hashCode() {
        int speciesHashCode = this.species != null ? this.species.hashCode() : 0;
        int sortedHashCode = this.sorted ? 0x55555555 : 0x2AAAAAAA;
        return speciesHashCode ^ sortedHashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PupitriCatch other = (PupitriCatch)obj;
        if (!(this.species == other.species || this.species != null && this.species.equals(other.species))) {
            return false;
        }
        return this.sorted == other.sorted;
    }
}

