/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.command;

import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;

public class TemplateTransformEvent
extends NotificationEvent {
    protected final ContainerContext focus;
    private final DesignElement fromElement;
    private final DesignElement toElement;

    public TemplateTransformEvent(ContainerContext containerInfo, DesignElement from, DesignElement to) {
        super(containerInfo.getElement());
        this.fromElement = from;
        this.toElement = to;
        this.focus = containerInfo;
    }

    @Override
    public int getEventType() {
        return 17;
    }

    public int getSlot() {
        return this.focus.getSlotID();
    }

    public IDesignElement getFrom() {
        return this.fromElement;
    }

    public IDesignElement getTo() {
        return this.toElement;
    }

    @Override
    public boolean isSame(NotificationEvent event) {
        if (!super.isSame(event)) {
            return false;
        }
        TemplateTransformEvent transEvent = (TemplateTransformEvent)event;
        return this.focus.equals(transEvent.focus) && this.fromElement == transEvent.getFrom() && this.toElement == transEvent.getTo();
    }
}

