/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion.core;

import liquibase.database.Database;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.structure.type.BooleanType;
import liquibase.database.structure.type.ClobType;
import liquibase.database.structure.type.CurrencyType;
import liquibase.database.structure.type.DataType;
import liquibase.database.structure.type.DateTimeType;
import liquibase.database.structure.type.NumberType;
import liquibase.database.structure.type.NumericType;
import liquibase.database.typeconversion.core.AbstractTypeConverter;

public class FirebirdTypeConverter
extends AbstractTypeConverter {
    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof FirebirdDatabase;
    }

    public DataType getDataType(String columnTypeString, Boolean autoIncrement) {
        DataType type = super.getDataType(columnTypeString, autoIncrement);
        if (type.getDataTypeName().startsWith("BLOB SUB_TYPE <0")) {
            return this.getBlobType();
        }
        return type;
    }

    public BooleanType getBooleanType() {
        return new BooleanType.NumericBooleanType("SMALLINT");
    }

    public CurrencyType getCurrencyType() {
        return new CurrencyType("DECIMAL(18, 4)");
    }

    public ClobType getClobType() {
        return new ClobType("BLOB SUB_TYPE TEXT");
    }

    public DateTimeType getDateTimeType() {
        return new DateTimeType("TIMESTAMP");
    }

    public NumberType getNumberType() {
        return new NumericType();
    }
}

