package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency;

/*
 * #%L
 * Tutti :: UI
 * $Id: BenthosFrequencyRowModel.java 1564 2014-01-31 10:56:26Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.3.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/benthos/frequency/BenthosFrequencyRowModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.List;

/**
 * Represents a batch frequency row.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class BenthosFrequencyRowModel extends AbstractTuttiBeanUIModel<BenthosBatchFrequency, BenthosFrequencyRowModel> implements Comparable<BenthosFrequencyRowModel>, BenthosBatchFrequency {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_LENGTH_STEP = "lengthStep";

    public static final String PROPERTY_NUMBER = "number";

    public static final String PROPERTY_WEIGHT = "weight";

    public static final String PROPERTY_LENGHT_STEP_CARACTERISTIC = "lengthStepCaracteristic";

    /**
     * Length step.
     *
     * @since 0.2
     */
    protected Float lengthStep;

    /**
     * Count of fishes for this lengthStep.
     *
     * @since 0.2
     */
    protected Integer number;

    /**
     * Weight of fishes observed.
     *
     * @since 0.2
     */
    protected Float weight;

    /**
     * Length step caracteristic.
     *
     * @since 0.3
     */
    protected Caracteristic lengthStepCaracteristic;

    /**
     * Weight unit.
     *
     * @since 2.5
     */
    protected final WeightUnit weightUnit;

    protected static final Binder<BenthosBatchFrequency, BenthosFrequencyRowModel> fromBeanBinder =
            BinderFactory.newBinder(BenthosBatchFrequency.class,
                                    BenthosFrequencyRowModel.class);

    protected static final Binder<BenthosFrequencyRowModel, BenthosBatchFrequency> toBeanBinder =
            BinderFactory.newBinder(BenthosFrequencyRowModel.class,
                                    BenthosBatchFrequency.class);

    private static final Ordering<Float> ordering = Ordering.natural().nullsFirst();

    //------------------------------------------------------------------------//
    //-- Factory methods                                                    --//
    //------------------------------------------------------------------------//

    public static List<BenthosFrequencyRowModel> fromEntity(WeightUnit weightUnit,
                                                            List<BenthosBatchFrequency> entities) {
        List<BenthosFrequencyRowModel> result = Lists.newArrayList();
        for (BenthosBatchFrequency entity : entities) {

            BenthosFrequencyRowModel row =
                    new BenthosFrequencyRowModel(weightUnit);
            row.fromEntity(entity);
            result.add(row);
        }
        return result;
    }

    public static List<BenthosBatchFrequency> toEntity(List<BenthosFrequencyRowModel> rows,
                                                       BenthosBatch batch) {
        List<BenthosBatchFrequency> result = Lists.newArrayList();
        for (BenthosFrequencyRowModel row : rows) {
            BenthosBatchFrequency model = row.toEntity();

            model.setBatch(batch);
            result.add(model);
        }
        return result;
    }

    public BenthosFrequencyRowModel(WeightUnit weightUnit) {
        super(fromBeanBinder, toBeanBinder);
        this.weightUnit = weightUnit;
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiBeanUIModel                                           --//
    //------------------------------------------------------------------------//

    @Override
    protected BenthosBatchFrequency newEntity() {
        return BenthosBatchFrequencys.newBenthosBatchFrequency();
    }

    @Override
    public void fromEntity(BenthosBatchFrequency entity) {
        super.fromEntity(entity);

        // convert weight
        setWeight(weightUnit.fromEntity(getWeight()));
    }

    @Override
    public BenthosBatchFrequency toEntity() {
        BenthosBatchFrequency result = super.toEntity();

        // convert weight
        result.setWeight(weightUnit.toEntity(getWeight()));
        return result;
    }

    //------------------------------------------------------------------------//
    //-- BenthosBatchFrequency                                              --//
    //------------------------------------------------------------------------//

    @Override
    public Float getLengthStep() {
        return lengthStep;
    }

    @Override
    public void setLengthStep(Float lengthStep) {
        Object oldValue = getLengthStep();
        this.lengthStep = lengthStep;
        firePropertyChange(PROPERTY_LENGTH_STEP, oldValue, lengthStep);
    }

    @Override
    public Integer getNumber() {
        return number;
    }

    @Override
    public void setNumber(Integer number) {
        Object oldValue = getNumber();
        this.number = number;
        firePropertyChange(PROPERTY_NUMBER, oldValue, number);
    }

    @Override
    public Float getWeight() {
        return weight;
    }

    @Override
    public void setWeight(Float weight) {
        Object oldValue = getWeight();
        this.weight = weight;
        firePropertyChange(PROPERTY_WEIGHT, oldValue, weight);
    }

    @Override
    public Caracteristic getLengthStepCaracteristic() {
        return lengthStepCaracteristic;
    }

    @Override
    public void setLengthStepCaracteristic(Caracteristic lengthStepCaracteristic) {
        Object oldValue = getLengthStepCaracteristic();
        this.lengthStepCaracteristic = lengthStepCaracteristic;
        firePropertyChange(PROPERTY_LENGHT_STEP_CARACTERISTIC, oldValue, lengthStepCaracteristic);
    }

    @Override
    public BenthosBatch getBatch() {
        return null;
    }

    @Override
    public void setBatch(BenthosBatch batch) {
    }

    @Override
    public int compareTo(BenthosFrequencyRowModel o) {
        int result = ordering.compare(lengthStep, o.lengthStep);
        return result;
    }

    @Override
    public Integer getRankOrder() {
        return null;
    }

    @Override
    public void setRankOrder(Integer rankOrder) {
    }
}
