package fr.ifremer.tutti.ui.swing.content.db;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class DbManagerUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<TuttiUIContext, DbManagerUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EXPORT_DB_BUTTON_VISIBLE = "exportDbButton.visible";
    public static final String BINDING_INSTALL_OR_REINSTALL_DB_BUTTON_TEXT = "installOrReinstallDbButton.text";
    public static final String BINDING_INSTALL_OR_REINSTALL_DB_BUTTON_TOOL_TIP_TEXT = "installOrReinstallDbButton.toolTipText";
    public static final String BINDING_OPEN_DB_BUTTON_VISIBLE = "openDbButton.visible";
    public static final String BINDING_UPGRADE_DB_BUTTON_VISIBLE = "upgradeDbButton.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWTW8bRRiemDip49C0SVulkAgnRZFT0XWLqEAKguZTdeQ0KHGkqjmUWe/YnjL7wey42WAV8RP4CXAFLkjcOCEOnDlwQfwFhDj0inhndr3+2vG6bRRt4tn3eead93nfx/PD3yjrc7TyBAeBwVuOoDYx9jcfPjw0n5Ca2CF+jVNPuByFPxMZlDlFeSte9wW6cVqR8FIEL227tuc6xOlBb1TQjC/OGfGbhAiBlvsRNd8vHcevNwKvxTuscVJJrN/8+0/ma+urbzMIBR5kl4ejFNJQ3ZNMVlCGWgLNw05PcYlhpwFpcOo0IN/X5do2w77/ANvkc/Qlmq6gKQ9zIBNodfwjKw6FDzyBLlvmAXZwg/Cq632CHcIEul3nBq1zYhNuiJYQ1GhRwz+DPIya6wigNSzT2OkAT8qepwinBMrariUpinqKqvx4Ut6WTIHoQqdM7n5GuEDrKdj7hHlbKrYLzlGn7kbpz8tKBRFiXy3KqFwcPCeDuY0FdZ1NTrBAV/sgVchLwmT4fIyaxjUJUB+v9BPOuh5xdswtyA5OhRb62MJVGbkYA96gji8wY4f8iET/duAyYqk/+iIFNbkYETHX8hocW2QUCQl0JBy92dek0P5Gt/27/TlxirK8BcsCLZ4OT8wRvApnZXFgViShevvftYU/fv7rp73eAbmaGNoz39C4HocKc0Hl1nPhdLQEZaUD7G2copxPGJiDGv6lhMSOo9eQHOx3WcINCTfuY78JFNnpP3/59dqnv7+GMntohrnY2sMyvoxyosmhCi6zAu/jeyqj2bML8Lwkc4N2f9yEZoRytFfDTo2nyZAvVp8FUI2lhGrEKZm5354vHP94r1ORCcjwuja8W5XsIzRFHUYdokwj8oNEk8h7PmlZbnfuk5wAJVmBFw3YTfU0hiqQgV5vupx+AV2P2SajDcdWdjTX3q9gkzBje/dBdffomUAz4fSUpYGgfM8ABi3J/a46uvzvPcjkUs97xZOWyCQ4QN2ttXxsMujYbB0zH/7mI7uqnnvwKSf9ptQUNpNm43JLms1y2yFnhV3bE+dbaql4951C9LsOeV8gFhW9rEn5DhpKWrowjpMyGYHutJvYsRj0S4OIcugE4YBKEyoqNzWov2PuBtQXxfX1wVLORPZxyzLB+R7D1ozWwkRUlEDbbb2fhkxGOcGNQrhRkz0Cm87SOx84Bw6xXYfWwKMH2z1iiuGGHcfmheuyKvWq6sS39SemXvKBO1O2PjxlQ9t2xm5YpBGeO75eb+kSiBx6QJ1cuK4XZ3MMcRSFyjraZLQ0xZQUtcrcSAMKuEjEYhT1YnTi9VoMfKOl1X86rv+yZs/wCxi+pJ9Sn6ppvdke6qXC2lphpbtaAaMnVnFopKYlmV6yu+mSHapsRsu0NvIkWpFWRsP6JFrTShRF6wXqu9GML09Bs198PelV6Eo7XYv5lmdhQW5xUifypksx08jyfrosJ4rrZa0tPoNWm7dTkX3y6O2sC9ArNHjlG18knYd1LogvqlEuBOonZgxpdoNXsbZO5i9sbTFwTGuL40dYW/89O00WuEROMXzuQjC6+CH0Jy6Y1LGgNB8NsU/I50wqo1z+Tj6+T2ZYeGWG68DwPx/eFxeqDwAA";
    private static final Log log = LogFactory.getLog(DbManagerUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actions;
    protected TuttiHelpBroker broker;
    protected DbManagerUI dbManagerTopPanel = this;
    protected JButton exportDbButton;
    protected final DbManagerUIHandler handler = new DbManagerUIHandler();
    protected JButton importDbButton;
    protected JPanel infoPanel;
    protected JTextPane informationArea;
    protected JButton installOrReinstallDbButton;
    protected TuttiUIContext model;
    protected JButton openDbButton;
    protected JButton upgradeDbButton;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DbManagerUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public DbManagerUI() {
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActions() {
        return actions;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getExportDbButton() {
        return exportDbButton;
    }

    public DbManagerUIHandler getHandler() {
        return handler;
    }

    public JButton getImportDbButton() {
        return importDbButton;
    }

    public JPanel getInfoPanel() {
        return infoPanel;
    }

    public JTextPane getInformationArea() {
        return informationArea;
    }

    public JButton getInstallOrReinstallDbButton() {
        return installOrReinstallDbButton;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public JButton getOpenDbButton() {
        return openDbButton;
    }

    public JButton getUpgradeDbButton() {
        return upgradeDbButton;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActions() {
        if (!allComponentsCreated) {
            return;
        }
        actions.add(openDbButton);
        actions.add(installOrReinstallDbButton);
        actions.add(importDbButton);
        actions.add(upgradeDbButton);
        actions.add(exportDbButton);
    }

    protected void addChildrenToDbManagerTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(infoPanel, BorderLayout.CENTER);
        add(actions, BorderLayout.SOUTH);
    }

    protected void addChildrenToInfoPanel() {
        if (!allComponentsCreated) {
            return;
        }
        infoPanel.add(informationArea, BorderLayout.CENTER);
    }

    protected void createActions() {
        $objectMap.put("actions", actions = new JPanel());
        
        actions.setName("actions");
        actions.setLayout(new GridLayout(0, 1));
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.dbManager.help"));
    }

    protected void createExportDbButton() {
        $objectMap.put("exportDbButton", exportDbButton = new JButton());
        
        exportDbButton.setName("exportDbButton");
        exportDbButton.setText(t("tutti.dbManager.action.exportDb"));
        exportDbButton.setToolTipText(t("tutti.dbManager.action.exportDb.tip"));
        exportDbButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportDbAction.class);
        exportDbButton.putClientProperty("help", "tutti.dbManager.action.exportDb.help");
    }

    protected void createImportDbButton() {
        $objectMap.put("importDbButton", importDbButton = new JButton());
        
        importDbButton.setName("importDbButton");
        importDbButton.setText(t("tutti.dbManager.action.importDb"));
        importDbButton.setToolTipText(t("tutti.dbManager.action.importDb.tip"));
        importDbButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportOrReimportDbAction.class);
        importDbButton.putClientProperty("help", "tutti.dbManager.action.importDb.help");
    }

    protected void createInfoPanel() {
        $objectMap.put("infoPanel", infoPanel = new JPanel());
        
        infoPanel.setName("infoPanel");
        infoPanel.setLayout(new BorderLayout());
    }

    protected void createInformationArea() {
        $objectMap.put("informationArea", informationArea = new JTextPane());
        
        informationArea.setName("informationArea");
        informationArea.setFocusable(false);
        informationArea.setContentType("text/html");
        informationArea.setEditable(false);
    }

    protected void createInstallOrReinstallDbButton() {
        $objectMap.put("installOrReinstallDbButton", installOrReinstallDbButton = new JButton());
        
        installOrReinstallDbButton.setName("installOrReinstallDbButton");
        installOrReinstallDbButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.InstallOrReinstallDbAction.class);
        installOrReinstallDbButton.putClientProperty("help", "tutti.dbManager.action.installDb.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createOpenDbButton() {
        $objectMap.put("openDbButton", openDbButton = new JButton());
        
        openDbButton.setName("openDbButton");
        openDbButton.setText(t("tutti.dbManager.action.openDb"));
        openDbButton.setToolTipText(t("tutti.dbManager.action.openDb.tip"));
        openDbButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.OpenDbAction.class);
        openDbButton.putClientProperty("help", "tutti.dbManager.action.openDb.help");
    }

    protected void createUpgradeDbButton() {
        $objectMap.put("upgradeDbButton", upgradeDbButton = new JButton());
        
        upgradeDbButton.setName("upgradeDbButton");
        upgradeDbButton.setText(t("tutti.dbManager.action.upgradeDb"));
        upgradeDbButton.setToolTipText(t("tutti.dbManager.action.upgradeDb.tip"));
        upgradeDbButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.UpdateDbAction.class);
        upgradeDbButton.putClientProperty("help", "tutti.dbManager.action.upgradeDb.help");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDbManagerTopPanel();
        addChildrenToInfoPanel();
        addChildrenToActions();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        informationArea.setBorder(new EmptyBorder(5, 5, 5, 5));
        openDbButton.setIcon(SwingUtil.createActionIcon("open-db"));
        openDbButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.dbManager.action.openDb.mnemonic"),'Z'));
        installOrReinstallDbButton.setIcon(SwingUtil.createActionIcon("install-db"));
        installOrReinstallDbButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.dbManager.action.installDb.mnemonic"),'Z'));
        importDbButton.setIcon(SwingUtil.createActionIcon("import-db"));
        importDbButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.dbManager.action.importDb.mnemonic"),'Z'));
        upgradeDbButton.setIcon(SwingUtil.createActionIcon("update-referential"));
        upgradeDbButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.dbManager.action.upgradeDb.mnemonic"),'Z'));
        exportDbButton.setIcon(SwingUtil.createActionIcon("export-db"));
        exportDbButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.dbManager.action.exportDb.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, dbManagerTopPanel, "tutti.dbManager.help");
        registerHelpId(_broker, openDbButton, "tutti.dbManager.action.openDb.help");
        registerHelpId(_broker, installOrReinstallDbButton, "tutti.dbManager.action.installDb.help");
        registerHelpId(_broker, importDbButton, "tutti.dbManager.action.importDb.help");
        registerHelpId(_broker, upgradeDbButton, "tutti.dbManager.action.upgradeDb.help");
        registerHelpId(_broker, exportDbButton, "tutti.dbManager.action.exportDb.help");
        _broker.prepareUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("dbManagerTopPanel", dbManagerTopPanel);
        createModel();
        createBroker();
        createInfoPanel();
        createInformationArea();
        createActions();
        createOpenDbButton();
        createInstallOrReinstallDbButton();
        createImportDbButton();
        createUpgradeDbButton();
        createExportDbButton();
        // inline creation of dbManagerTopPanel
        setName("dbManagerTopPanel");
        setLayout(new BorderLayout());
        dbManagerTopPanel.putClientProperty("help", "tutti.dbManager.help");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OPEN_DB_BUTTON_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    openDbButton.setVisible(model.isDbExist() && !model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INSTALL_OR_REINSTALL_DB_BUTTON_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    installOrReinstallDbButton.setText(handler.getInstallButtonText(model.isDbExist()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INSTALL_OR_REINSTALL_DB_BUTTON_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    installOrReinstallDbButton.setToolTipText(handler.getInstallButtonTip(model.isDbExist()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UPGRADE_DB_BUTTON_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    upgradeDbButton.setVisible(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_DB_BUTTON_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportDbButton.setVisible(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
    }

}