package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditSampleCategoryModelAction.java 1566 2014-02-04 08:31:02Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.3.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/EditSampleCategoryModelAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;

import static org.nuiton.i18n.I18n.t;

/**
 * To show {@link TuttiScreen#EDIT_SAMPLE_CATEGORY_MODEL} config screen.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.4
 */
public class EditSampleCategoryModelAction extends AbstractChangeScreenAction {

    public EditSampleCategoryModelAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.EDIT_SAMPLE_CATEGORY_MODEL);
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        if (result) {
            result = askAdminPassword(
                    t("tutti.editSampleCategoryModel.passwordDialog.message"),
                    t("tutti.editSampleCategoryModel.passwordDialog.title"),
                    t("tutti.editSampleCategoryModel.passwordDialog.error.message"),
                    t("tutti.editSampleCategoryModel.passwordDialog.error.title")
            );
        }
        return result;
    }
}