/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.TemplateArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.BlockStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.BlockTextLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.IInlineStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.InlineContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.Layout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LineLayout;
import org.eclipse.birt.report.engine.layout.pdf.font.FontHandler;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class TemplateLayout
extends Layout {
    public TemplateLayout(LayoutEngineContext context, ContainerLayout parent, IContent content) {
        super(context, parent, content);
    }

    @Override
    protected void closeLayout() {
    }

    @Override
    protected void initialize() {
    }

    @Override
    public void layout() throws BirtException {
        boolean isInline = this.parent instanceof IInlineStackingLayout;
        if (isInline) {
            if (this.parent instanceof LineLayout) {
                InlineContainerLayout inlineContainer = new InlineContainerLayout(this.context, this.parent, this.content);
                ((Layout)inlineContainer).initialize();
                this.addTemplateArea(inlineContainer, true);
                inlineContainer.closeLayout();
            } else {
                this.addTemplateArea(this.parent, true);
            }
        } else {
            assert (this.parent instanceof BlockStackingLayout);
            boolean inlineElement = PropertyUtil.isInlineElement(this.content);
            if (!inlineElement) {
                BlockTextLayout tLayout = new BlockTextLayout(this.context, this.parent, this.content);
                tLayout.initialize();
                LineLayout line = new LineLayout(this.context, tLayout);
                line.initialize();
                this.addTemplateArea(line, false);
                line.closeLayout();
                tLayout.closeLayout();
            }
        }
    }

    protected void addTemplateArea(ContainerLayout parent, boolean isInline) {
        IAutoTextContent autoText = (IAutoTextContent)this.content;
        TemplateArea templateArea = (TemplateArea)AreaFactory.createTemplateArea(autoText);
        int maxWidth = parent.getCurrentMaxContentWidth();
        templateArea.setAllocatedWidth(maxWidth - parent.currentContext.currentIP);
        int maxAvaWidth = templateArea.getWidth();
        int width = this.getDimensionValue(autoText.getWidth(), maxWidth);
        if (width == 0) {
            int defaultWidth = this.getDimensionValue(templateArea.getStyle().getFontSize()) * 4;
            width = Math.min(maxAvaWidth, defaultWidth);
        } else if (width > maxAvaWidth) {
            width = maxAvaWidth;
        }
        templateArea.setWidth(width);
        this.context.setTotalPageTemplateWidth(templateArea.getContentWidth());
        FontHandler handler = new FontHandler(this.context.getFontManager(), autoText, false);
        FontInfo fontInfo = handler.getFontInfo();
        int height = this.getDimensionValue(autoText.getHeight(), 0);
        templateArea.setContentHeight(Math.max((int)(fontInfo.getWordHeight() * 1000.0f), height));
        templateArea.setBaseLine(fontInfo.getBaseline() + templateArea.getContentY());
        parent.addToRoot(templateArea);
    }
}

