/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.SemanticException;
import javax.persistence.AttributeConverter;
import org.hibernate.hql.internal.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.internal.ast.tree.AbstractSelectExpression;
import org.hibernate.hql.internal.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.internal.ast.util.ColumnHelper;
import org.hibernate.type.SingleColumnType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.converter.AttributeConverterTypeAdapter;

public class LiteralNode
extends AbstractSelectExpression
implements HqlSqlTokenTypes,
ExpectedTypeAwareNode {
    private Type expectedType;

    @Override
    public void setScalarColumnText(int i) throws SemanticException {
        ColumnHelper.generateSingleScalarColumn(this, i);
    }

    @Override
    public Type getDataType() {
        if (this.expectedType != null) {
            return this.expectedType;
        }
        switch (this.getType()) {
            case 130: {
                return StandardBasicTypes.INTEGER;
            }
            case 100: {
                return StandardBasicTypes.FLOAT;
            }
            case 101: {
                return StandardBasicTypes.LONG;
            }
            case 99: {
                return StandardBasicTypes.DOUBLE;
            }
            case 102: {
                return StandardBasicTypes.BIG_INTEGER;
            }
            case 103: {
                return StandardBasicTypes.BIG_DECIMAL;
            }
            case 127: {
                return StandardBasicTypes.STRING;
            }
            case 20: 
            case 49: {
                return StandardBasicTypes.BOOLEAN;
            }
        }
        return null;
    }

    public Object getLiteralValue() {
        Type inherentType;
        String text = this.getText();
        if (this.getType() == 127) {
            text = text.substring(1, text.length() - 1);
        }
        if ((inherentType = this.getDataType()) == null) {
            return text;
        }
        return ((SingleColumnType)inherentType).fromStringValue(text);
    }

    @Override
    public void setExpectedType(Type expectedType) {
        if (this.expectedType != null) {
            return;
        }
        if (AttributeConverterTypeAdapter.class.isInstance(expectedType)) {
            AttributeConverterTypeAdapter adapterType = (AttributeConverterTypeAdapter)expectedType;
            if (this.getDataType().getReturnedClass().equals(adapterType.getModelType())) {
                AttributeConverter converter = ((AttributeConverterTypeAdapter)expectedType).getAttributeConverter();
                Object converted = converter.convertToDatabaseColumn(this.getLiteralValue());
                if (this.isCharacterData(adapterType.sqlType())) {
                    this.setText("'" + converted.toString() + "'");
                } else {
                    this.setText(converted.toString());
                }
            }
            this.expectedType = expectedType;
        }
    }

    private boolean isCharacterData(int typeCode) {
        return 12 == typeCode || 1 == typeCode || -9 == typeCode || -15 == typeCode;
    }

    @Override
    public Type getExpectedType() {
        return this.expectedType;
    }
}

