/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.ListBody;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.ListLabel;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.BidiLine;
import com.itextpdf.text.pdf.FloatLayout;
import com.itextpdf.text.pdf.PdfChunk;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDocument;
import com.itextpdf.text.pdf.PdfFont;
import com.itextpdf.text.pdf.PdfLine;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPRow;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPTableEvent;
import com.itextpdf.text.pdf.PdfPTableEventAfterSplit;
import com.itextpdf.text.pdf.PdfPTableEventSplit;
import com.itextpdf.text.pdf.draw.DrawInterface;
import com.itextpdf.text.pdf.interfaces.IAccessibleElement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnText {
    private final Logger LOGGER = LoggerFactory.getLogger(ColumnText.class);
    public static final int AR_NOVOWEL = 1;
    public static final int AR_COMPOSEDTASHKEEL = 4;
    public static final int AR_LIG = 8;
    public static final int DIGITS_EN2AN = 32;
    public static final int DIGITS_AN2EN = 64;
    public static final int DIGITS_EN2AN_INIT_LR = 96;
    public static final int DIGITS_EN2AN_INIT_AL = 128;
    public static final int DIGIT_TYPE_AN = 0;
    public static final int DIGIT_TYPE_AN_EXTENDED = 256;
    protected int runDirection = 0;
    public static final float GLOBAL_SPACE_CHAR_RATIO = 0.0f;
    public static final int START_COLUMN = 0;
    public static final int NO_MORE_TEXT = 1;
    public static final int NO_MORE_COLUMN = 2;
    protected static final int LINE_STATUS_OK = 0;
    protected static final int LINE_STATUS_OFFLIMITS = 1;
    protected static final int LINE_STATUS_NOLINE = 2;
    protected float maxY;
    protected float minY;
    protected float leftX;
    protected float rightX;
    protected int alignment = 0;
    protected ArrayList<float[]> leftWall;
    protected ArrayList<float[]> rightWall;
    protected BidiLine bidiLine;
    protected boolean isWordSplit;
    protected float yLine;
    protected float lastX;
    protected float currentLeading = 16.0f;
    protected float fixedLeading = 16.0f;
    protected float multipliedLeading = 0.0f;
    protected PdfContentByte canvas;
    protected PdfContentByte[] canvases;
    protected int lineStatus;
    protected float indent = 0.0f;
    protected float followingIndent = 0.0f;
    protected float rightIndent = 0.0f;
    protected float extraParagraphSpace = 0.0f;
    protected float rectangularWidth = -1.0f;
    protected boolean rectangularMode = false;
    private float spaceCharRatio = 0.0f;
    private boolean lastWasNewline = true;
    private boolean repeatFirstLineIndent = true;
    private int linesWritten;
    private float firstLineY;
    private boolean firstLineYDone = false;
    private int arabicOptions = 0;
    protected float descender;
    protected boolean composite = false;
    protected ColumnText compositeColumn;
    protected LinkedList<Element> compositeElements;
    protected int listIdx = 0;
    protected int rowIdx = 0;
    private int splittedRow = -1;
    protected Phrase waitPhrase;
    private boolean useAscender = false;
    private float filledWidth;
    private boolean adjustFirstLine = true;
    private boolean inheritGraphicState = false;

    public ColumnText(PdfContentByte canvas) {
        this.canvas = canvas;
    }

    public static ColumnText duplicate(ColumnText org) {
        ColumnText ct = new ColumnText(null);
        ct.setACopy(org);
        return ct;
    }

    public ColumnText setACopy(ColumnText org) {
        this.setSimpleVars(org);
        if (org.bidiLine != null) {
            this.bidiLine = new BidiLine(org.bidiLine);
        }
        return this;
    }

    protected void setSimpleVars(ColumnText org) {
        this.maxY = org.maxY;
        this.minY = org.minY;
        this.alignment = org.alignment;
        this.leftWall = null;
        if (org.leftWall != null) {
            this.leftWall = new ArrayList<float[]>(org.leftWall);
        }
        this.rightWall = null;
        if (org.rightWall != null) {
            this.rightWall = new ArrayList<float[]>(org.rightWall);
        }
        this.yLine = org.yLine;
        this.currentLeading = org.currentLeading;
        this.fixedLeading = org.fixedLeading;
        this.multipliedLeading = org.multipliedLeading;
        this.canvas = org.canvas;
        this.canvases = org.canvases;
        this.lineStatus = org.lineStatus;
        this.indent = org.indent;
        this.followingIndent = org.followingIndent;
        this.rightIndent = org.rightIndent;
        this.extraParagraphSpace = org.extraParagraphSpace;
        this.rectangularWidth = org.rectangularWidth;
        this.rectangularMode = org.rectangularMode;
        this.spaceCharRatio = org.spaceCharRatio;
        this.lastWasNewline = org.lastWasNewline;
        this.repeatFirstLineIndent = org.repeatFirstLineIndent;
        this.linesWritten = org.linesWritten;
        this.arabicOptions = org.arabicOptions;
        this.runDirection = org.runDirection;
        this.descender = org.descender;
        this.composite = org.composite;
        this.splittedRow = org.splittedRow;
        if (org.composite) {
            this.compositeElements = new LinkedList();
            for (Element element : org.compositeElements) {
                if (element instanceof PdfPTable) {
                    this.compositeElements.add(new PdfPTable((PdfPTable)element));
                    continue;
                }
                this.compositeElements.add(element);
            }
            if (org.compositeColumn != null) {
                this.compositeColumn = ColumnText.duplicate(org.compositeColumn);
            }
        }
        this.listIdx = org.listIdx;
        this.rowIdx = org.rowIdx;
        this.firstLineY = org.firstLineY;
        this.leftX = org.leftX;
        this.rightX = org.rightX;
        this.firstLineYDone = org.firstLineYDone;
        this.waitPhrase = org.waitPhrase;
        this.useAscender = org.useAscender;
        this.filledWidth = org.filledWidth;
        this.adjustFirstLine = org.adjustFirstLine;
        this.inheritGraphicState = org.inheritGraphicState;
    }

    private void addWaitingPhrase() {
        if (this.bidiLine == null && this.waitPhrase != null) {
            this.bidiLine = new BidiLine();
            for (Chunk c : this.waitPhrase.getChunks()) {
                this.bidiLine.addChunk(new PdfChunk(c, null, this.waitPhrase.getTabSettings()));
            }
            this.waitPhrase = null;
        }
    }

    public void addText(Phrase phrase) {
        if (phrase == null || this.composite) {
            return;
        }
        this.addWaitingPhrase();
        if (this.bidiLine == null) {
            this.waitPhrase = phrase;
            return;
        }
        for (Chunk element : phrase.getChunks()) {
            this.bidiLine.addChunk(new PdfChunk(element, null, phrase.getTabSettings()));
        }
    }

    public void setText(Phrase phrase) {
        this.bidiLine = null;
        this.composite = false;
        this.compositeColumn = null;
        this.compositeElements = null;
        this.listIdx = 0;
        this.rowIdx = 0;
        this.splittedRow = -1;
        this.waitPhrase = phrase;
    }

    public void addText(Chunk chunk) {
        if (chunk == null || this.composite) {
            return;
        }
        this.addText(new Phrase(chunk));
    }

    public void addElement(Element element) {
        if (element == null) {
            return;
        }
        if (element instanceof Image) {
            Image img = (Image)element;
            PdfPTable t = new PdfPTable(1);
            float w = img.getWidthPercentage();
            if (w == 0.0f) {
                t.setTotalWidth(img.getScaledWidth());
                t.setLockedWidth(true);
            } else {
                t.setWidthPercentage(w);
            }
            t.setSpacingAfter(img.getSpacingAfter());
            t.setSpacingBefore(img.getSpacingBefore());
            switch (img.getAlignment()) {
                case 0: {
                    t.setHorizontalAlignment(0);
                    break;
                }
                case 2: {
                    t.setHorizontalAlignment(2);
                    break;
                }
                default: {
                    t.setHorizontalAlignment(1);
                }
            }
            PdfPCell c = new PdfPCell(img, true);
            c.setPadding(0.0f);
            c.setBorder(img.getBorder());
            c.setBorderColor(img.getBorderColor());
            c.setBorderWidth(img.getBorderWidth());
            c.setBackgroundColor(img.getBackgroundColor());
            t.addCell(c);
            element = t;
        }
        if (element.type() == 10) {
            element = new Paragraph((Chunk)element);
        } else if (element.type() == 11) {
            element = new Paragraph((Phrase)element);
        }
        if (element.type() != 12 && element.type() != 14 && element.type() != 23 && element.type() != 55 && element.type() != 37) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("element.not.allowed", new Object[0]));
        }
        if (!this.composite) {
            this.composite = true;
            this.compositeElements = new LinkedList();
            this.bidiLine = null;
            this.waitPhrase = null;
        }
        if (element.type() == 12) {
            Paragraph p = (Paragraph)element;
            this.compositeElements.addAll(p.breakUp());
            return;
        }
        this.compositeElements.add(element);
    }

    public static boolean isAllowedElement(Element element) {
        int type = element.type();
        if (type == 10 || type == 11 || type == 37 || type == 12 || type == 14 || type == 55 || type == 23) {
            return true;
        }
        return element instanceof Image;
    }

    protected ArrayList<float[]> convertColumn(float[] cLine) {
        if (cLine.length < 4) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("no.valid.column.line.found", new Object[0]));
        }
        ArrayList<float[]> cc = new ArrayList<float[]>();
        for (int k = 0; k < cLine.length - 2; k += 2) {
            float x1 = cLine[k];
            float y1 = cLine[k + 1];
            float x2 = cLine[k + 2];
            float y2 = cLine[k + 3];
            if (y1 == y2) continue;
            float a = (x1 - x2) / (y1 - y2);
            float b = x1 - a * y1;
            float[] r = new float[]{Math.min(y1, y2), Math.max(y1, y2), a, b};
            cc.add(r);
            this.maxY = Math.max(this.maxY, r[1]);
            this.minY = Math.min(this.minY, r[0]);
        }
        if (cc.isEmpty()) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("no.valid.column.line.found", new Object[0]));
        }
        return cc;
    }

    protected float findLimitsPoint(ArrayList<float[]> wall) {
        this.lineStatus = 0;
        if (this.yLine < this.minY || this.yLine > this.maxY) {
            this.lineStatus = 1;
            return 0.0f;
        }
        for (int k = 0; k < wall.size(); ++k) {
            float[] r = wall.get(k);
            if (this.yLine < r[0] || this.yLine > r[1]) continue;
            return r[2] * this.yLine + r[3];
        }
        this.lineStatus = 2;
        return 0.0f;
    }

    protected float[] findLimitsOneLine() {
        float x1 = this.findLimitsPoint(this.leftWall);
        if (this.lineStatus == 1 || this.lineStatus == 2) {
            return null;
        }
        float x2 = this.findLimitsPoint(this.rightWall);
        if (this.lineStatus == 2) {
            return null;
        }
        return new float[]{x1, x2};
    }

    protected float[] findLimitsTwoLines() {
        float[] x2;
        float[] x1;
        boolean repeat = false;
        while (true) {
            if (repeat && this.currentLeading == 0.0f) {
                return null;
            }
            repeat = true;
            x1 = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            this.yLine -= this.currentLeading;
            if (this.lineStatus == 2) continue;
            x2 = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            if (this.lineStatus == 2) {
                this.yLine -= this.currentLeading;
                continue;
            }
            if (!(x1[0] >= x2[1]) && !(x2[0] >= x1[1])) break;
        }
        return new float[]{x1[0], x1[1], x2[0], x2[1]};
    }

    public void setColumns(float[] leftLine, float[] rightLine) {
        this.maxY = -1.0E21f;
        this.minY = 1.0E21f;
        this.setYLine(Math.max(leftLine[1], leftLine[leftLine.length - 1]));
        this.rightWall = this.convertColumn(rightLine);
        this.leftWall = this.convertColumn(leftLine);
        this.rectangularWidth = -1.0f;
        this.rectangularMode = false;
    }

    public void setSimpleColumn(Phrase phrase, float llx, float lly, float urx, float ury, float leading, int alignment) {
        this.addText(phrase);
        this.setSimpleColumn(llx, lly, urx, ury, leading, alignment);
    }

    public void setSimpleColumn(float llx, float lly, float urx, float ury, float leading, int alignment) {
        this.setLeading(leading);
        this.alignment = alignment;
        this.setSimpleColumn(llx, lly, urx, ury);
    }

    public void setSimpleColumn(float llx, float lly, float urx, float ury) {
        this.leftX = Math.min(llx, urx);
        this.maxY = Math.max(lly, ury);
        this.minY = Math.min(lly, ury);
        this.rightX = Math.max(llx, urx);
        this.yLine = this.maxY;
        this.rectangularWidth = this.rightX - this.leftX;
        if (this.rectangularWidth < 0.0f) {
            this.rectangularWidth = 0.0f;
        }
        this.rectangularMode = true;
    }

    public void setSimpleColumn(Rectangle rect) {
        this.setSimpleColumn(rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getTop());
    }

    public void setLeading(float leading) {
        this.fixedLeading = leading;
        this.multipliedLeading = 0.0f;
    }

    public void setLeading(float fixedLeading, float multipliedLeading) {
        this.fixedLeading = fixedLeading;
        this.multipliedLeading = multipliedLeading;
    }

    public float getLeading() {
        return this.fixedLeading;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public void setYLine(float yLine) {
        this.yLine = yLine;
    }

    public float getYLine() {
        return this.yLine;
    }

    public int getRowsDrawn() {
        return this.rowIdx;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setIndent(float indent) {
        this.setIndent(indent, true);
    }

    public void setIndent(float indent, boolean repeatFirstLineIndent) {
        this.indent = indent;
        this.lastWasNewline = true;
        this.repeatFirstLineIndent = repeatFirstLineIndent;
    }

    public float getIndent() {
        return this.indent;
    }

    public void setFollowingIndent(float indent) {
        this.followingIndent = indent;
        this.lastWasNewline = true;
    }

    public float getFollowingIndent() {
        return this.followingIndent;
    }

    public void setRightIndent(float indent) {
        this.rightIndent = indent;
        this.lastWasNewline = true;
    }

    public float getRightIndent() {
        return this.rightIndent;
    }

    public float getCurrentLeading() {
        return this.currentLeading;
    }

    public boolean getInheritGraphicState() {
        return this.inheritGraphicState;
    }

    public void setInheritGraphicState(boolean inheritGraphicState) {
        this.inheritGraphicState = inheritGraphicState;
    }

    public int go() throws DocumentException {
        return this.go(false);
    }

    public int go(boolean simulate) throws DocumentException {
        return this.go(simulate, null);
    }

    public int go(boolean simulate, IAccessibleElement elementToGo) throws DocumentException {
        this.isWordSplit = false;
        if (this.composite) {
            return this.goComposite(simulate);
        }
        ListBody lBody = null;
        if (ColumnText.isTagged(this.canvas) && elementToGo instanceof ListItem) {
            lBody = ((ListItem)elementToGo).getListBody();
        }
        this.addWaitingPhrase();
        if (this.bidiLine == null) {
            return 1;
        }
        this.descender = 0.0f;
        this.linesWritten = 0;
        this.lastX = 0.0f;
        boolean dirty = false;
        float ratio = this.spaceCharRatio;
        Object[] currentValues = new Object[2];
        PdfFont currentFont = null;
        Float lastBaseFactor = new Float(0.0f);
        currentValues[1] = lastBaseFactor;
        PdfDocument pdf = null;
        PdfContentByte graphics = null;
        PdfContentByte text = null;
        this.firstLineY = Float.NaN;
        int localRunDirection = 1;
        if (this.runDirection != 0) {
            localRunDirection = this.runDirection;
        }
        if (this.canvas != null) {
            graphics = this.canvas;
            pdf = this.canvas.getPdfDocument();
            text = !ColumnText.isTagged(this.canvas) ? this.canvas.getDuplicate(this.inheritGraphicState) : this.canvas;
        } else if (!simulate) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("columntext.go.with.simulate.eq.eq.false.and.text.eq.eq.null", new Object[0]));
        }
        if (!simulate) {
            if (ratio == 0.0f) {
                ratio = text.getPdfWriter().getSpaceCharRatio();
            } else if (ratio < 0.001f) {
                ratio = 0.001f;
            }
        }
        if (!this.rectangularMode) {
            float max = 0.0f;
            for (PdfChunk c : this.bidiLine.chunks) {
                max = Math.max(max, c.height());
            }
            this.currentLeading = this.fixedLeading + max * this.multipliedLeading;
        }
        float firstIndent = 0.0f;
        int status = 0;
        while (true) {
            float x1;
            PdfLine line;
            float f = firstIndent = this.lastWasNewline ? this.indent : this.followingIndent;
            if (this.rectangularMode) {
                if (this.rectangularWidth <= firstIndent + this.rightIndent) {
                    status = 2;
                    if (!this.bidiLine.isEmpty()) break;
                    status |= 1;
                    break;
                }
                if (this.bidiLine.isEmpty()) {
                    status = 1;
                    break;
                }
                line = this.bidiLine.processLine(this.leftX, this.rectangularWidth - firstIndent - this.rightIndent, this.alignment, localRunDirection, this.arabicOptions, this.minY, this.yLine, this.descender);
                this.isWordSplit |= this.bidiLine.isWordSplit();
                if (line == null) {
                    status = 1;
                    break;
                }
                float[] maxSize = line.getMaxSize(this.fixedLeading, this.multipliedLeading);
                this.currentLeading = this.isUseAscender() && Float.isNaN(this.firstLineY) ? line.getAscender() : Math.max(maxSize[0], maxSize[1] - this.descender);
                if (this.yLine > this.maxY || this.yLine - this.currentLeading < this.minY) {
                    status = 2;
                    this.bidiLine.restore();
                    break;
                }
                this.yLine -= this.currentLeading;
                if (!simulate && !dirty) {
                    text.beginText();
                    dirty = true;
                }
                if (Float.isNaN(this.firstLineY)) {
                    this.firstLineY = this.yLine;
                }
                this.updateFilledWidth(this.rectangularWidth - line.widthLeft());
                x1 = this.leftX;
            } else {
                float yTemp = this.yLine - this.currentLeading;
                float[] xx = this.findLimitsTwoLines();
                if (xx == null) {
                    status = 2;
                    if (this.bidiLine.isEmpty()) {
                        status |= 1;
                    }
                    this.yLine = yTemp;
                    break;
                }
                if (this.bidiLine.isEmpty()) {
                    status = 1;
                    this.yLine = yTemp;
                    break;
                }
                x1 = Math.max(xx[0], xx[2]);
                float x2 = Math.min(xx[1], xx[3]);
                if (x2 - x1 <= firstIndent + this.rightIndent) continue;
                if (!simulate && !dirty) {
                    text.beginText();
                    dirty = true;
                }
                if ((line = this.bidiLine.processLine(x1, x2 - x1 - firstIndent - this.rightIndent, this.alignment, localRunDirection, this.arabicOptions, this.minY, this.yLine, this.descender)) == null) {
                    status = 1;
                    this.yLine = yTemp;
                    break;
                }
            }
            if (ColumnText.isTagged(this.canvas) && elementToGo instanceof ListItem && !Float.isNaN(this.firstLineY) && !this.firstLineYDone) {
                if (!simulate) {
                    ListLabel lbl = ((ListItem)elementToGo).getListLabel();
                    this.canvas.openMCBlock(lbl);
                    Chunk symbol = new Chunk(((ListItem)elementToGo).getListSymbol());
                    symbol.setRole(null);
                    ColumnText.showTextAligned(this.canvas, 0, new Phrase(symbol), this.leftX + lbl.getIndentation(), this.firstLineY, 0.0f);
                    this.canvas.closeMCBlock(lbl);
                }
                this.firstLineYDone = true;
            }
            if (!simulate) {
                if (lBody != null) {
                    this.canvas.openMCBlock(lBody);
                    lBody = null;
                }
                currentValues[0] = currentFont;
                text.setTextMatrix(x1 + (line.isRTL() ? this.rightIndent : firstIndent) + line.indentLeft(), this.yLine);
                this.lastX = pdf.writeLineToContent(line, text, graphics, currentValues, ratio);
                currentFont = (PdfFont)currentValues[0];
            }
            this.lastWasNewline = this.repeatFirstLineIndent && line.isNewlineSplit();
            this.yLine -= line.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
            ++this.linesWritten;
            this.descender = line.getDescender();
        }
        if (dirty) {
            text.endText();
            if (this.canvas != text) {
                this.canvas.add(text);
            }
        }
        return status;
    }

    public boolean isWordSplit() {
        return this.isWordSplit;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float extraParagraphSpace) {
        this.extraParagraphSpace = extraParagraphSpace;
    }

    public void clearChunks() {
        if (this.bidiLine != null) {
            this.bidiLine.clearChunks();
        }
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float spaceCharRatio) {
        this.spaceCharRatio = spaceCharRatio;
    }

    public void setRunDirection(int runDirection) {
        if (runDirection < 0 || runDirection > 3) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.run.direction.1", runDirection));
        }
        this.runDirection = runDirection;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public int getLinesWritten() {
        return this.linesWritten;
    }

    public float getLastX() {
        return this.lastX;
    }

    public int getArabicOptions() {
        return this.arabicOptions;
    }

    public void setArabicOptions(int arabicOptions) {
        this.arabicOptions = arabicOptions;
    }

    public float getDescender() {
        return this.descender;
    }

    public static float getWidth(Phrase phrase, int runDirection, int arabicOptions) {
        ColumnText ct = new ColumnText(null);
        ct.addText(phrase);
        ct.addWaitingPhrase();
        PdfLine line = ct.bidiLine.processLine(0.0f, 20000.0f, 0, runDirection, arabicOptions, 0.0f, 0.0f, 0.0f);
        if (line == null) {
            return 0.0f;
        }
        return 20000.0f - line.widthLeft();
    }

    public static float getWidth(Phrase phrase) {
        return ColumnText.getWidth(phrase, 1, 0);
    }

    public static void showTextAligned(PdfContentByte canvas, int alignment, Phrase phrase, float x, float y, float rotation, int runDirection, int arabicOptions) {
        float urx;
        float llx;
        if (alignment != 0 && alignment != 1 && alignment != 2) {
            alignment = 0;
        }
        canvas.saveState();
        ColumnText ct = new ColumnText(canvas);
        float lly = -1.0f;
        float ury = 2.0f;
        switch (alignment) {
            case 0: {
                llx = 0.0f;
                urx = 20000.0f;
                break;
            }
            case 2: {
                llx = -20000.0f;
                urx = 0.0f;
                break;
            }
            default: {
                llx = -20000.0f;
                urx = 20000.0f;
            }
        }
        if (rotation == 0.0f) {
            llx += x;
            lly += y;
            urx += x;
            ury += y;
        } else {
            double alpha = (double)rotation * Math.PI / 180.0;
            float cos = (float)Math.cos(alpha);
            float sin = (float)Math.sin(alpha);
            canvas.concatCTM(cos, sin, -sin, cos, x, y);
        }
        ct.setSimpleColumn(phrase, llx, lly, urx, ury, 2.0f, alignment);
        if (runDirection == 3) {
            if (alignment == 0) {
                alignment = 2;
            } else if (alignment == 2) {
                alignment = 0;
            }
        }
        ct.setAlignment(alignment);
        ct.setArabicOptions(arabicOptions);
        ct.setRunDirection(runDirection);
        try {
            ct.go();
        }
        catch (DocumentException e) {
            throw new ExceptionConverter(e);
        }
        canvas.restoreState();
    }

    public static void showTextAligned(PdfContentByte canvas, int alignment, Phrase phrase, float x, float y, float rotation) {
        ColumnText.showTextAligned(canvas, alignment, phrase, x, y, rotation, 1, 0);
    }

    public static float fitText(Font font, String text, Rectangle rect, float maxFontSize, int runDirection) {
        try {
            ColumnText ct = null;
            int status = 0;
            if (maxFontSize <= 0.0f) {
                int cr = 0;
                int lf = 0;
                char[] t = text.toCharArray();
                for (int k = 0; k < t.length; ++k) {
                    if (t[k] == '\n') {
                        ++lf;
                        continue;
                    }
                    if (t[k] != '\r') continue;
                    ++cr;
                }
                int minLines = Math.max(cr, lf) + 1;
                maxFontSize = Math.abs(rect.getHeight()) / (float)minLines - 0.001f;
            }
            font.setSize(maxFontSize);
            Phrase ph = new Phrase(text, font);
            ct = new ColumnText(null);
            ct.setSimpleColumn(ph, rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getTop(), maxFontSize, 0);
            ct.setRunDirection(runDirection);
            status = ct.go(true);
            if ((status & 1) != 0) {
                return maxFontSize;
            }
            float precision = 0.1f;
            float min = 0.0f;
            float max = maxFontSize;
            float size = maxFontSize;
            for (int k = 0; k < 50; ++k) {
                size = (min + max) / 2.0f;
                ct = new ColumnText(null);
                font.setSize(size);
                ct.setSimpleColumn(new Phrase(text, font), rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getTop(), size, 0);
                ct.setRunDirection(runDirection);
                status = ct.go(true);
                if ((status & 1) != 0) {
                    if (max - min < size * precision) {
                        return size;
                    }
                    min = size;
                    continue;
                }
                max = size;
            }
            return size;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    protected int goComposite(boolean simulate) throws DocumentException {
        boolean isRTL;
        PdfDocument pdf = null;
        if (this.canvas != null) {
            pdf = this.canvas.pdf;
        }
        if (!this.rectangularMode) {
            throw new DocumentException(MessageLocalization.getComposedMessage("irregular.columns.are.not.supported.in.composite.mode", new Object[0]));
        }
        this.linesWritten = 0;
        this.descender = 0.0f;
        boolean firstPass = true;
        boolean bl = isRTL = this.runDirection == 3;
        block4: while (!this.compositeElements.isEmpty()) {
            Element element = this.compositeElements.getFirst();
            if (element.type() == 12) {
                Paragraph para = (Paragraph)element;
                int status = 0;
                for (int keep = 0; keep < 2; ++keep) {
                    boolean s;
                    float lastY = this.yLine;
                    boolean createHere = false;
                    if (this.compositeColumn == null) {
                        this.compositeColumn = new ColumnText(this.canvas);
                        this.compositeColumn.setAlignment(para.getAlignment());
                        this.compositeColumn.setIndent(para.getIndentationLeft() + para.getFirstLineIndent(), false);
                        this.compositeColumn.setExtraParagraphSpace(para.getExtraParagraphSpace());
                        this.compositeColumn.setFollowingIndent(para.getIndentationLeft());
                        this.compositeColumn.setRightIndent(para.getIndentationRight());
                        this.compositeColumn.setLeading(para.getLeading(), para.getMultipliedLeading());
                        this.compositeColumn.setRunDirection(this.runDirection);
                        this.compositeColumn.setArabicOptions(this.arabicOptions);
                        this.compositeColumn.setSpaceCharRatio(this.spaceCharRatio);
                        this.compositeColumn.addText(para);
                        if (!firstPass || !this.adjustFirstLine) {
                            this.yLine -= para.getSpacingBefore();
                        }
                        createHere = true;
                    }
                    this.compositeColumn.setUseAscender((firstPass || this.descender == 0.0f) && this.adjustFirstLine ? this.useAscender : false);
                    this.compositeColumn.setInheritGraphicState(this.inheritGraphicState);
                    this.compositeColumn.leftX = this.leftX;
                    this.compositeColumn.rightX = this.rightX;
                    this.compositeColumn.yLine = this.yLine;
                    this.compositeColumn.rectangularWidth = this.rectangularWidth;
                    this.compositeColumn.rectangularMode = this.rectangularMode;
                    this.compositeColumn.minY = this.minY;
                    this.compositeColumn.maxY = this.maxY;
                    boolean keepCandidate = para.getKeepTogether() && createHere && (!firstPass || !this.adjustFirstLine);
                    boolean bl2 = s = simulate || keepCandidate && keep == 0;
                    if (ColumnText.isTagged(this.canvas) && !s) {
                        this.canvas.openMCBlock(para);
                    }
                    status = this.compositeColumn.go(s);
                    if (ColumnText.isTagged(this.canvas) && !s) {
                        this.canvas.closeMCBlock(para);
                    }
                    this.lastX = this.compositeColumn.getLastX();
                    this.updateFilledWidth(this.compositeColumn.filledWidth);
                    if ((status & 1) == 0 && keepCandidate) {
                        this.compositeColumn = null;
                        this.yLine = lastY;
                        return 2;
                    }
                    if (simulate || !keepCandidate) break;
                    if (keep != 0) continue;
                    this.compositeColumn = null;
                    this.yLine = lastY;
                }
                firstPass = false;
                if (this.compositeColumn.getLinesWritten() > 0) {
                    this.yLine = this.compositeColumn.yLine;
                    this.linesWritten += this.compositeColumn.linesWritten;
                    this.descender = this.compositeColumn.descender;
                    this.isWordSplit |= this.compositeColumn.isWordSplit();
                }
                this.currentLeading = this.compositeColumn.currentLeading;
                if (status & true) {
                    this.compositeColumn = null;
                    this.compositeElements.removeFirst();
                    this.yLine -= para.getSpacingAfter();
                }
                if ((status & 2) == 0) continue;
                return 2;
            }
            if (element.type() == 14) {
                List list = (List)element;
                ArrayList<Element> items = list.getItems();
                ListItem item = null;
                float listIndentation = list.getIndentationLeft();
                int count = 0;
                Stack<Object[]> stack = new Stack<Object[]>();
                for (int k = 0; k < items.size(); ++k) {
                    Element obj = items.get(k);
                    if (obj instanceof ListItem) {
                        if (count == this.listIdx) {
                            item = (ListItem)obj;
                            break;
                        }
                        ++count;
                    } else if (obj instanceof List) {
                        stack.push(new Object[]{list, k, new Float(listIndentation)});
                        list = (List)obj;
                        items = list.getItems();
                        listIndentation += list.getIndentationLeft();
                        k = -1;
                        continue;
                    }
                    if (k != items.size() - 1 || stack.isEmpty()) continue;
                    Object[] objs = (Object[])stack.pop();
                    list = (List)objs[0];
                    items = list.getItems();
                    k = (Integer)objs[1];
                    listIndentation = ((Float)objs[2]).floatValue();
                }
                int status = 0;
                for (int keep = 0; keep < 2; ++keep) {
                    boolean s;
                    float lastY = this.yLine;
                    boolean createHere = false;
                    if (this.compositeColumn == null) {
                        if (item == null) {
                            this.listIdx = 0;
                            this.compositeElements.removeFirst();
                            continue block4;
                        }
                        this.compositeColumn = new ColumnText(this.canvas);
                        this.compositeColumn.setUseAscender((firstPass || this.descender == 0.0f) && this.adjustFirstLine ? this.useAscender : false);
                        this.compositeColumn.setInheritGraphicState(this.inheritGraphicState);
                        this.compositeColumn.setAlignment(item.getAlignment());
                        this.compositeColumn.setIndent(item.getIndentationLeft() + listIndentation + item.getFirstLineIndent(), false);
                        this.compositeColumn.setExtraParagraphSpace(item.getExtraParagraphSpace());
                        this.compositeColumn.setFollowingIndent(this.compositeColumn.getIndent());
                        this.compositeColumn.setRightIndent(item.getIndentationRight() + list.getIndentationRight());
                        this.compositeColumn.setLeading(item.getLeading(), item.getMultipliedLeading());
                        this.compositeColumn.setRunDirection(this.runDirection);
                        this.compositeColumn.setArabicOptions(this.arabicOptions);
                        this.compositeColumn.setSpaceCharRatio(this.spaceCharRatio);
                        this.compositeColumn.addText(item);
                        if (!firstPass || !this.adjustFirstLine) {
                            this.yLine -= item.getSpacingBefore();
                        }
                        createHere = true;
                    }
                    this.compositeColumn.leftX = this.leftX;
                    this.compositeColumn.rightX = this.rightX;
                    this.compositeColumn.yLine = this.yLine;
                    this.compositeColumn.rectangularWidth = this.rectangularWidth;
                    this.compositeColumn.rectangularMode = this.rectangularMode;
                    this.compositeColumn.minY = this.minY;
                    this.compositeColumn.maxY = this.maxY;
                    boolean keepCandidate = item.getKeepTogether() && createHere && (!firstPass || !this.adjustFirstLine);
                    boolean bl3 = s = simulate || keepCandidate && keep == 0;
                    if (ColumnText.isTagged(this.canvas) && !s) {
                        item.getListLabel().setIndentation(listIndentation);
                        if (list.getFirstItem() == item || this.compositeColumn != null && this.compositeColumn.bidiLine != null) {
                            this.canvas.openMCBlock(list);
                        }
                        this.canvas.openMCBlock(item);
                    }
                    status = this.compositeColumn.go(simulate || keepCandidate && keep == 0, item);
                    if (ColumnText.isTagged(this.canvas) && !s) {
                        this.canvas.closeMCBlock(item.getListBody());
                        this.canvas.closeMCBlock(item);
                        if (list.getLastItem() == item && (status & 1) != 0 || (status & 2) != 0) {
                            this.canvas.closeMCBlock(list);
                        }
                    }
                    this.lastX = this.compositeColumn.getLastX();
                    this.updateFilledWidth(this.compositeColumn.filledWidth);
                    if ((status & 1) == 0 && keepCandidate) {
                        this.compositeColumn = null;
                        this.yLine = lastY;
                        return 2;
                    }
                    if (simulate || !keepCandidate) break;
                    if (keep != 0) continue;
                    this.compositeColumn = null;
                    this.yLine = lastY;
                }
                firstPass = false;
                this.yLine = this.compositeColumn.yLine;
                this.linesWritten += this.compositeColumn.linesWritten;
                this.descender = this.compositeColumn.descender;
                this.currentLeading = this.compositeColumn.currentLeading;
                if (!(ColumnText.isTagged(this.canvas) || Float.isNaN(this.compositeColumn.firstLineY) || this.compositeColumn.firstLineYDone)) {
                    if (!simulate) {
                        if (isRTL) {
                            ColumnText.showTextAligned(this.canvas, 2, new Phrase(item.getListSymbol()), this.compositeColumn.lastX + item.getIndentationLeft(), this.compositeColumn.firstLineY, 0.0f, this.runDirection, this.arabicOptions);
                        } else {
                            ColumnText.showTextAligned(this.canvas, 0, new Phrase(item.getListSymbol()), this.compositeColumn.leftX + listIndentation, this.compositeColumn.firstLineY, 0.0f);
                        }
                    }
                    this.compositeColumn.firstLineYDone = true;
                }
                if (status & true) {
                    this.compositeColumn = null;
                    ++this.listIdx;
                    this.yLine -= item.getSpacingAfter();
                }
                if ((status & 2) == 0) continue;
                return 2;
            }
            if (element.type() == 23) {
                ArrayList<PdfPRow> rows;
                int kTemp;
                boolean skipHeader;
                float tableWidth;
                PdfPTable table = (PdfPTable)element;
                if (table.size() <= table.getHeaderRows()) {
                    this.compositeElements.removeFirst();
                    continue;
                }
                float yTemp = this.yLine;
                yTemp += this.descender;
                if (this.rowIdx == 0 && this.adjustFirstLine) {
                    yTemp -= table.spacingBefore();
                }
                if (yTemp < this.minY || yTemp > this.maxY) {
                    return 2;
                }
                float yLineWrite = yTemp;
                float x1 = this.leftX;
                this.currentLeading = 0.0f;
                if (table.isLockedWidth()) {
                    tableWidth = table.getTotalWidth();
                    this.updateFilledWidth(tableWidth);
                } else {
                    tableWidth = this.rectangularWidth * table.getWidthPercentage() / 100.0f;
                    table.setTotalWidth(tableWidth);
                }
                table.normalizeHeadersFooters();
                int headerRows = table.getHeaderRows();
                int footerRows = table.getFooterRows();
                int realHeaderRows = headerRows - footerRows;
                float headerHeight = table.getHeaderHeight();
                float footerHeight = table.getFooterHeight();
                boolean bl4 = skipHeader = table.isSkipFirstHeader() && this.rowIdx <= realHeaderRows && (table.isComplete() || this.rowIdx != realHeaderRows);
                if (!table.isComplete() && table.getTotalHeight() - headerHeight > yTemp - this.minY) {
                    table.setSkipFirstHeader(false);
                    return 2;
                }
                if (!skipHeader && ((yTemp -= headerHeight) < this.minY || yTemp > this.maxY)) {
                    return 2;
                }
                int k = 0;
                if (this.rowIdx < headerRows) {
                    this.rowIdx = headerRows;
                }
                if (!table.isComplete()) {
                    yTemp -= footerHeight;
                }
                PdfPTable.FittingRows fittingRows = table.getFittingRows(yTemp - this.minY, this.rowIdx);
                k = fittingRows.lastRow + 1;
                yTemp -= fittingRows.height;
                this.LOGGER.info("Want to split at row " + k);
                for (kTemp = k; kTemp > this.rowIdx && kTemp < table.size() && table.getRow(kTemp).isMayNotBreak(); --kTemp) {
                }
                if (kTemp > this.rowIdx && kTemp < k || kTemp == 0 && table.getRow(0).isMayNotBreak() && table.isLoopCheck()) {
                    yTemp = this.minY;
                    k = kTemp;
                    table.setLoopCheck(false);
                }
                this.LOGGER.info("Will split at row " + k);
                if (table.isSplitLate() && k > 0) {
                    fittingRows.correctLastRowChosen(table, k - 1);
                }
                if (!table.isComplete()) {
                    yTemp += footerHeight;
                }
                if (!table.isSplitRows()) {
                    this.splittedRow = -1;
                    if (k == this.rowIdx) {
                        if (k == table.size()) {
                            this.compositeElements.removeFirst();
                            continue;
                        }
                        table.getRows().remove(k);
                        return 2;
                    }
                } else if (table.isSplitLate() && this.rowIdx < k) {
                    this.splittedRow = -1;
                } else if (k < table.size()) {
                    float h = (yTemp -= fittingRows.completedRowsHeight - fittingRows.height) - this.minY;
                    PdfPRow newRow = table.getRow(k).splitRow(table, k, h);
                    if (newRow == null) {
                        this.LOGGER.info("Didn't split row!");
                        this.splittedRow = -1;
                        if (this.rowIdx == k) {
                            return 2;
                        }
                    } else {
                        if (k != this.splittedRow) {
                            this.splittedRow = k + 1;
                            table = new PdfPTable(table);
                            this.compositeElements.set(0, table);
                            rows = table.getRows();
                            for (int i = headerRows; i < this.rowIdx; ++i) {
                                rows.set(i, null);
                            }
                        }
                        yTemp = this.minY;
                        table.getRows().add(++k, newRow);
                        this.LOGGER.info("Inserting row at position " + k);
                    }
                }
                firstPass = false;
                if (!simulate) {
                    PdfPTableEvent tableEvent;
                    switch (table.getHorizontalAlignment()) {
                        case 2: {
                            if (isRTL) break;
                            x1 += this.rectangularWidth - tableWidth;
                            break;
                        }
                        case 1: {
                            x1 += (this.rectangularWidth - tableWidth) / 2.0f;
                            break;
                        }
                        default: {
                            if (!isRTL) break;
                            x1 += this.rectangularWidth - tableWidth;
                        }
                    }
                    PdfPTable nt = PdfPTable.shallowCopy(table);
                    ArrayList<PdfPRow> sub = nt.getRows();
                    if (!skipHeader && realHeaderRows > 0) {
                        rows = table.getRows(0, realHeaderRows);
                        if (ColumnText.isTagged(this.canvas)) {
                            nt.getHeader().rows = rows;
                        }
                        sub.addAll(rows);
                    } else {
                        nt.setHeaderRows(footerRows);
                    }
                    rows = table.getRows(this.rowIdx, k);
                    if (ColumnText.isTagged(this.canvas)) {
                        nt.getBody().rows = rows;
                    }
                    sub.addAll(rows);
                    boolean showFooter = !table.isSkipLastFooter();
                    boolean newPageFollows = false;
                    if (k < table.size()) {
                        nt.setComplete(true);
                        showFooter = true;
                        newPageFollows = true;
                    }
                    if (footerRows > 0 && nt.isComplete() && showFooter) {
                        ArrayList<PdfPRow> rows2 = table.getRows(realHeaderRows, realHeaderRows + footerRows);
                        if (ColumnText.isTagged(this.canvas)) {
                            nt.getFooter().rows = rows2;
                        }
                        sub.addAll(rows2);
                    } else {
                        footerRows = 0;
                    }
                    float rowHeight = 0.0f;
                    int lastIdx = sub.size() - 1 - footerRows;
                    PdfPRow last = sub.get(lastIdx);
                    if (table.isExtendLastRow(newPageFollows)) {
                        rowHeight = last.getMaxHeights();
                        last.setMaxHeights(yTemp - this.minY + rowHeight);
                        yTemp = this.minY;
                    }
                    if (newPageFollows && (tableEvent = table.getTableEvent()) instanceof PdfPTableEventSplit) {
                        ((PdfPTableEventSplit)tableEvent).splitTable(table);
                    }
                    if (this.canvases != null) {
                        if (ColumnText.isTagged(this.canvases[3])) {
                            this.canvases[3].openMCBlock(table);
                        }
                        nt.writeSelectedRows(0, -1, 0, -1, x1, yLineWrite, this.canvases, false);
                        if (ColumnText.isTagged(this.canvases[3])) {
                            this.canvases[3].closeMCBlock(table);
                        }
                    } else {
                        if (ColumnText.isTagged(this.canvas)) {
                            this.canvas.openMCBlock(table);
                        }
                        nt.writeSelectedRows(0, -1, 0, -1, x1, yLineWrite, this.canvas, false);
                        if (ColumnText.isTagged(this.canvas)) {
                            this.canvas.closeMCBlock(table);
                        }
                    }
                    if (!table.isComplete()) {
                        table.addNumberOfRowsWritten(k);
                    }
                    if (this.splittedRow == k && k < table.size()) {
                        PdfPRow splitted = table.getRows().get(k);
                        splitted.copyRowContent(nt, lastIdx);
                    } else if (k > 0 && k < table.size()) {
                        PdfPRow row = table.getRow(k);
                        row.splitRowspans(table, k - 1, nt, lastIdx);
                    }
                    if (table.isExtendLastRow(newPageFollows)) {
                        last.setMaxHeights(rowHeight);
                    }
                    if (newPageFollows && (tableEvent = table.getTableEvent()) instanceof PdfPTableEventAfterSplit) {
                        PdfPRow row = table.getRow(k);
                        ((PdfPTableEventAfterSplit)tableEvent).afterSplitTable(table, row, k);
                    }
                } else if (table.isExtendLastRow() && this.minY > -1.0737418E9f) {
                    yTemp = this.minY;
                }
                this.yLine = yTemp;
                this.descender = 0.0f;
                this.currentLeading = 0.0f;
                if (!skipHeader && !table.isComplete()) {
                    this.yLine += footerHeight;
                }
                while (k < table.size() && !(table.getRowHeight(k) > 0.0f) && !table.hasRowspan(k)) {
                    ++k;
                }
                if (k >= table.size()) {
                    this.yLine = this.yLine - table.spacingAfter() < this.minY ? this.minY : (this.yLine -= table.spacingAfter());
                    this.compositeElements.removeFirst();
                    this.splittedRow = -1;
                    this.rowIdx = 0;
                    continue;
                }
                if (this.splittedRow != -1) {
                    ArrayList<PdfPRow> rows3 = table.getRows();
                    for (int i = this.rowIdx; i < k; ++i) {
                        rows3.set(i, null);
                    }
                }
                this.rowIdx = k;
                return 2;
            }
            if (element.type() == 55) {
                if (!simulate) {
                    DrawInterface zh = (DrawInterface)((Object)element);
                    zh.draw(this.canvas, this.leftX, this.minY, this.rightX, this.maxY, this.yLine);
                }
                this.compositeElements.removeFirst();
                continue;
            }
            if (element.type() == 37) {
                ArrayList<Element> floatingElements = new ArrayList<Element>();
                do {
                    floatingElements.add(element);
                    this.compositeElements.removeFirst();
                    Element element2 = element = !this.compositeElements.isEmpty() ? this.compositeElements.getFirst() : null;
                } while (element != null && element.type() == 37);
                FloatLayout fl = new FloatLayout(floatingElements, this.useAscender);
                fl.setSimpleColumn(this.leftX, this.minY, this.rightX, this.yLine);
                int status = fl.layout(this.canvas, simulate);
                this.yLine = fl.getYLine();
                this.descender = 0.0f;
                if ((status & 1) != 0) continue;
                this.compositeElements.addAll(floatingElements);
                return status;
            }
            this.compositeElements.removeFirst();
        }
        return 1;
    }

    public PdfContentByte getCanvas() {
        return this.canvas;
    }

    public void setCanvas(PdfContentByte canvas) {
        this.canvas = canvas;
        this.canvases = null;
        if (this.compositeColumn != null) {
            this.compositeColumn.setCanvas(canvas);
        }
    }

    public void setCanvases(PdfContentByte[] canvases) {
        this.canvases = canvases;
        this.canvas = canvases[3];
        if (this.compositeColumn != null) {
            this.compositeColumn.setCanvases(canvases);
        }
    }

    public PdfContentByte[] getCanvases() {
        return this.canvases;
    }

    public boolean zeroHeightElement() {
        return this.composite && !this.compositeElements.isEmpty() && this.compositeElements.getFirst().type() == 55;
    }

    public java.util.List<Element> getCompositeElements() {
        return this.compositeElements;
    }

    public boolean isUseAscender() {
        return this.useAscender;
    }

    public void setUseAscender(boolean useAscender) {
        this.useAscender = useAscender;
    }

    public static boolean hasMoreText(int status) {
        return (status & 1) == 0;
    }

    public float getFilledWidth() {
        return this.filledWidth;
    }

    public void setFilledWidth(float filledWidth) {
        this.filledWidth = filledWidth;
    }

    public void updateFilledWidth(float w) {
        if (w > this.filledWidth) {
            this.filledWidth = w;
        }
    }

    public boolean isAdjustFirstLine() {
        return this.adjustFirstLine;
    }

    public void setAdjustFirstLine(boolean adjustFirstLine) {
        this.adjustFirstLine = adjustFirstLine;
    }

    private static boolean isTagged(PdfContentByte canvas) {
        return canvas != null && canvas.pdf != null && canvas.writer != null && canvas.writer.isTagged();
    }
}

