/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.hibernate;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.nuiton.util.DateUtil;

public class ConfigurationHelper {
    public static Integer getInteger(String key, Properties properties) {
        return org.hibernate.internal.util.config.ConfigurationHelper.getInteger((String)key, (Map)properties);
    }

    public static String getString(String key, Properties properties) {
        return org.hibernate.internal.util.config.ConfigurationHelper.getString((String)key, (Map)properties);
    }

    public static String getString(String key, Properties properties, String defaultValue) {
        return org.hibernate.internal.util.config.ConfigurationHelper.getString((String)key, (Map)properties, (String)defaultValue);
    }

    public static Multimap<String, String> getMultimap(String key, Properties properties) {
        String property = ConfigurationHelper.getString(key, properties);
        return ConfigurationHelper.getMultimap(property);
    }

    public static long getLong(String key, Properties properties, int defaultValue) {
        return org.hibernate.internal.util.config.ConfigurationHelper.getLong((String)key, (Map)properties, (int)defaultValue);
    }

    public static boolean getBoolean(String key, Properties properties, boolean defaultValue) {
        return org.hibernate.internal.util.config.ConfigurationHelper.getBoolean((String)key, (Map)properties, (boolean)defaultValue);
    }

    public static int getInt(String key, Properties properties, int defaultValue) {
        return org.hibernate.internal.util.config.ConfigurationHelper.getInt((String)key, (Map)properties, (int)defaultValue);
    }

    public static Multimap<String, String> getMultimap(String property) {
        if (StringUtils.isBlank((CharSequence)property)) {
            return null;
        }
        ArrayListMultimap result = ArrayListMultimap.create();
        Map valuesStrByKey = Splitter.on((char)',').trimResults().withKeyValueSeparator(Splitter.on((char)'|').trimResults()).split((CharSequence)property);
        for (String mapKey : valuesStrByKey.keySet()) {
            String valuesStr = (String)valuesStrByKey.get(mapKey);
            List valuesList = Splitter.on((char)';').trimResults().splitToList((CharSequence)valuesStr);
            result.putAll((Object)mapKey, (Iterable)valuesList);
        }
        return result;
    }

    public static void setMultimap(String key, Multimap<String, String> multimap, Properties properties) {
        if (multimap == null || multimap.isEmpty()) {
            properties.remove(key);
            return;
        }
        StringBuilder propertyBuilder = new StringBuilder();
        for (String mapKey : multimap.keySet()) {
            Collection mapValues = multimap.get((Object)mapKey);
            propertyBuilder.append(',').append(mapKey.toUpperCase()).append('|');
            Joiner.on((char)';').appendTo(propertyBuilder, (Iterable)mapValues);
        }
        properties.setProperty(key, propertyBuilder.substring(1));
    }

    public static void setDate(String key, Date date, String pattern, boolean withTime, Properties properties) {
        if (date == null) {
            properties.remove(key);
            return;
        }
        if (!withTime) {
            date = DateUtils.truncate((Date)date, (int)5);
        }
        String property = DateUtil.formatDate((Date)date, (String)pattern);
        properties.setProperty(key, property);
    }

    public static void setString(String key, String property, Properties properties) {
        if (property == null) {
            properties.remove(key);
            return;
        }
        properties.setProperty(key, property);
    }

    public static void setBoolean(String key, Boolean property, Properties properties) {
        if (property == null) {
            properties.remove(key);
            return;
        }
        properties.setProperty(key, property.toString());
    }

    public static void setFile(String key, File file, Properties properties) {
        if (file == null) {
            properties.remove(key);
            return;
        }
        properties.setProperty(key, file.getAbsolutePath());
    }
}

