/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.bigfin;

import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import java.util.Map;

public enum Signs {
    NOT_SEXED("NOT SET"){

        @Override
        public Integer getCategory() {
            return PmfmId.SEX.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.NON_SEXED_SEX.getValue();
        }

        @Override
        public boolean isNullEquivalent() {
            return true;
        }
    }
    ,
    MALE("M"){

        @Override
        public Integer getCategory() {
            return PmfmId.SEX.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.SEX_MALE.getValue();
        }

        @Override
        public boolean isNullEquivalent() {
            return false;
        }
    }
    ,
    FEMALE("F"){

        @Override
        public Integer getCategory() {
            return PmfmId.SEX.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.SEX_FEMALE.getValue();
        }

        @Override
        public boolean isNullEquivalent() {
            return false;
        }
    }
    ,
    NOT_SIZED("0"){

        @Override
        public Integer getCategory() {
            return PmfmId.SIZE_CATEGORY.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.UNSORTED.getValue();
        }

        @Override
        public boolean isNullEquivalent() {
            return true;
        }
    }
    ,
    SMALL("1"){

        @Override
        public Integer getCategory() {
            return PmfmId.SIZE_CATEGORY.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.SIZE_SMALL.getValue();
        }

        @Override
        public boolean isNullEquivalent() {
            return false;
        }
    }
    ,
    BIG("2"){

        @Override
        public Integer getCategory() {
            return PmfmId.SIZE_CATEGORY.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.SIZE_BIG.getValue();
        }

        @Override
        public boolean isNullEquivalent() {
            return false;
        }
    }
    ,
    VRAC(""){

        @Override
        public Integer getCategory() {
            return PmfmId.SORTED_UNSORTED.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.SORTED_VRAC.getValue();
        }

        @Override
        public boolean isNullEquivalent() {
            return false;
        }
    }
    ,
    HORS_VRAC("HV"){

        @Override
        public Integer getCategory() {
            return PmfmId.SORTED_UNSORTED.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.SORTED_HORS_VRAC.getValue();
        }

        @Override
        public boolean isNullEquivalent() {
            return false;
        }
    };

    private String sign;

    private Signs(String sign) {
        this.sign = sign;
    }

    public String getSign() {
        return this.sign;
    }

    public static Signs getSign(String sign) {
        Signs result = Signs.getSign(sign, null);
        return result;
    }

    public static Signs getSign(String sign, Integer categoryId) {
        Signs result = null;
        for (Signs s : Signs.values()) {
            if (!s.sign.equals(sign) || categoryId != null && !s.getCategory().equals(categoryId)) continue;
            result = s;
            break;
        }
        return result;
    }

    public abstract Integer getCategory();

    public abstract Integer getQualitativeValueId();

    public abstract boolean isNullEquivalent();

    public void registerSign(Caracteristic caracteristic, Map<Signs, CaracteristicQualitativeValue> map) {
        Integer valueId = this.getQualitativeValueId();
        CaracteristicQualitativeValue result = CaracteristicQualitativeValues.getQualitativeValue((Caracteristic)caracteristic, (Integer)valueId);
        map.put(this, result);
    }
}

