package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.io.Files;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.spi.UIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JOptionPane;
import java.io.File;

import static org.nuiton.i18n.I18n.t;

/**
 * @author kmorin <morin@codelutin.com>
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class ImportPupitriPopupUIHandler implements UIHandler<ImportPupitriPopupUI> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(ImportPupitriPopupUIHandler.class);

    protected ImportPupitriPopupUI ui;

    @Override
    public void beforeInit(ImportPupitriPopupUI ui) {
        this.ui = ui;
    }

    @Override
    public void afterInit(ImportPupitriPopupUI ui) {
        ui.getTrunkFile().setDialogOwner(ui);
        ui.getCarrouselFile().setDialogOwner(ui);
        ui.pack();
        ui.setResizable(true);
    }

    private boolean objectIsAdjusting;

    public void updateTrunkFile() {

        if (objectIsAdjusting) {
            // avoid re-entrant code
            return;
        }
        File carrouselFile = ui.getCarrouselFile().getSelectedFile();

        if (carrouselFile != null) {
            String nameWithoutExtension = Files.getNameWithoutExtension(carrouselFile.getName());
            File trunkFile = new File(carrouselFile.getParentFile(), nameWithoutExtension + ".tnk");
            if (trunkFile.exists()) {

                if (log.isInfoEnabled()) {
                    log.info("Select from carrousel file, trunk file: " + trunkFile);
                }

                objectIsAdjusting = true;
                try {
                    ui.getTrunkFile().setSelectedFile(trunkFile);
                } finally {
                    objectIsAdjusting = false;
                }

            } else {
                if (log.isDebugEnabled()) {
                    log.debug("No trunk file at " + trunkFile);
                }
            }
        }

    }

    public void updateCarrouselFile() {

        if (objectIsAdjusting) {
            // avoid re-entrant code
            return;
        }

        File trunkFile = ui.getTrunkFile().getSelectedFile();
        if (trunkFile != null) {
            String nameWithoutExtension = Files.getNameWithoutExtension(trunkFile.getName());
            File carrouselFile = new File(trunkFile.getParentFile(), nameWithoutExtension + ".car");
            if (carrouselFile.exists()) {

                if (log.isInfoEnabled()) {
                    log.info("Select from trunk file, carrousel file: " + carrouselFile);
                }

                objectIsAdjusting = true;
                try {
                    ui.getCarrouselFile().setSelectedFile(carrouselFile);
                } finally {
                    objectIsAdjusting = false;
                }

            } else {
                if (log.isDebugEnabled()) {
                    log.debug("No carrousel file at " + carrouselFile);
                }
            }
        }

    }

    public void open() {
        resetFields();
        SwingUtil.center(TuttiUIUtil.getApplicationContext(ui).getMainUI(), ui);
        ui.setVisible(true);
    }

    public void cancel() {
        resetFields();
        ui.dispose();
    }

    public void validate() {
        if (ui.getTrunkFile().getSelectedFile() != null
            && ui.getTrunkFile().getSelectedFile().exists()
            && ui.getCarrouselFile().getSelectedFile() != null
            && ui.getCarrouselFile().getSelectedFile().exists()) {

            ui.dispose();

        } else {
            JOptionPane.showMessageDialog(ui,
                                          t("tutti.importPupitri.error.fileMissing.message"),
                                          t("tutti.importPupitri.error.fileMissing.title"),
                                          JOptionPane.ERROR_MESSAGE);
        }
    }

    protected void resetFields() {
        ui.getTrunkFile().setSelectedFilePath(null);
        ui.getCarrouselFile().setSelectedFilePath(null);
    }

}
