/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.dao.SynchroTableDao;
import fr.ifremer.adagio.synchro.service.SynchroContext;
import fr.ifremer.adagio.synchro.service.SynchroResult;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;

public class SynchroBaseService {
    private static final Log log = LogFactory.getLog(SynchroBaseService.class);
    protected final SynchroConfiguration config;
    protected final int batchSize;
    protected final DataSource dataSource;

    public SynchroBaseService(DataSource dataSource, SynchroConfiguration config) {
        Preconditions.checkNotNull((Object)config);
        this.dataSource = dataSource;
        this.config = config;
        this.batchSize = config.getImportJdbcBatchSize();
    }

    public SynchroBaseService() {
        this.config = SynchroConfiguration.getInstance();
        Preconditions.checkNotNull((Object)this.config, (Object)String.format("%s instance not initialized. Make sure 'setInstance()' is called first.", SynchroConfiguration.class.getName()));
        this.dataSource = null;
        this.batchSize = this.config.getImportJdbcBatchSize();
    }

    protected void reportProgress(SynchroResult result, SynchroTableDao dao, int countR, String tablePrefix) {
        if (countR % this.batchSize == 0) {
            result.getProgressionModel().increments(this.batchSize);
        }
        if (countR % (this.batchSize * 10) == 0 && log.isInfoEnabled()) {
            log.info((Object)String.format("%s Done: %s (inserts: %s, updates: %s)", tablePrefix, countR, dao.getInsertCount(), dao.getUpdateCount()));
        }
    }

    protected Dialect getDialect(Properties connectionProperties) {
        return Dialect.getDialect((Properties)connectionProperties);
    }

    protected Dialect getTargetDialect(SynchroContext context) {
        return this.getDialect(context.getTargetConnectionProperties());
    }

    protected Dialect getSourceDialect(SynchroContext context) {
        return this.getDialect(context.getSourceConnectionProperties());
    }
}

