/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Vessels;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.referential.ImportRequestResult;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.VesselModel;
import fr.ifremer.tutti.service.referential.VesselRow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ReferentialTemporaryVesselService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ReferentialTemporaryVesselService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
    }

    public ReferentialImportResult<Vessel> importTemporaryVessel(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import vessels from file: " + file));
        }
        ArrayList existingVessels = Lists.newArrayList(this.persistenceService.getAllFishingVessel());
        existingVessels.addAll(this.persistenceService.getAllScientificVessel());
        ImportRequestResult<Vessel, String> requestResult = this.processImportFile(file, existingVessels);
        ReferentialImportResult<Vessel> result = new ReferentialImportResult<Vessel>();
        if (requestResult.withEntitiesToDelete()) {
            Collection<String> idsToDelete = requestResult.getIdsToDelete();
            this.persistenceService.deleteTemporaryVessels(idsToDelete);
            result.setNbRefDeleted(idsToDelete.size());
        }
        if (requestResult.withEntitiesToAdd()) {
            Collection<Vessel> entitiesToAdd = requestResult.getEntitiesToAdd();
            Collection<Vessel> entitiesAdded = this.persistenceService.importTemporaryVessel(entitiesToAdd);
            result.addAllRefsAdded(entitiesAdded);
        }
        if (requestResult.withEntitiesToUpdate()) {
            Collection<Vessel> entitiesToUpdate = requestResult.getEntitiesToUpdate();
            Collection<Vessel> entitiesUpdated = this.persistenceService.importTemporaryVessel(entitiesToUpdate);
            result.addAllRefsUpdated(entitiesUpdated);
        }
        return result;
    }

    public void exportExistingTemporaryVessel(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Getting all vessels from database");
        }
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllFishingVessel());
        targetList.addAll(this.persistenceService.getAllScientificVessel());
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + targetList.size() + " vessels"));
        }
        List<Vessel> toExport = this.persistenceService.retainTemporaryVesselList(targetList);
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + toExport.size() + " temporary vessels"));
        }
        this.exportTemporaryVessel(file, toExport);
    }

    public void exportTemporaryVesselExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Vessel v = Vessels.newVessel();
        v.setRegistrationCode("RegCode1");
        v.setName("Temporary fishing vessel name 1");
        v.setInternationalRegistrationCode("International registration code F1");
        v.setScientificVessel(false);
        toExport.add(v);
        v = Vessels.newVessel();
        v.setRegistrationCode("RegCode2");
        v.setName("Temporary fishing vessel name 2");
        v.setInternationalRegistrationCode("International registration code F2");
        v.setScientificVessel(false);
        toExport.add(v);
        v = Vessels.newVessel();
        v.setRegistrationCode("RegCode3");
        v.setName("Temporary scientific vessel name 3");
        v.setInternationalRegistrationCode("International registration code S3");
        v.setScientificVessel(true);
        toExport.add(v);
        v = Vessels.newVessel();
        v.setRegistrationCode("RegCode4");
        v.setName("Temporary scientific vessel name 4");
        v.setInternationalRegistrationCode("International registration code S4");
        v.setScientificVessel(true);
        toExport.add(v);
        this.exportTemporaryVessel(file, toExport);
    }

    protected ImportRequestResult<Vessel, String> processImportFile(File file, List<Vessel> existingEntities) {
        ImportRequestResult<Vessel, String> requestResult = new ImportRequestResult<Vessel, String>(existingEntities, TuttiEntities.newIdFunction(), Vessels.GET_INTERNAL_REGISTRATION_CODE);
        try (BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);){
            VesselModel csvModel = new VesselModel(this.getCsvSeparator());
            try (Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
                for (VesselRow bean : importer) {
                    this.importVessel(bean, requestResult);
                }
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.import.vessels.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, (Throwable)e);
        }
        return requestResult;
    }

    private void importVessel(VesselRow bean, ImportRequestResult<Vessel, String> requestResult) {
        String id = StringUtils.trimToNull((String)bean.getId());
        String internationalRegistrationCode = bean.getInternationalRegistrationCode();
        boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
        if (id == null) {
            if (delete) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.vessel.cannotDeleteWithoutId.error", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)internationalRegistrationCode)) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.vessel.add.noRegistrationCode.error", (Object[])new Object[0]));
            }
            if (!requestResult.addExistingNaturalId(internationalRegistrationCode)) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.vessel.existingRegistrationCode.error", (Object[])new Object[]{internationalRegistrationCode}));
            }
            requestResult.addEntityToAdd(bean.toEntity());
        } else {
            Vessel vessel = requestResult.getExistingEntityById(id);
            if (vessel == null) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.vessel.notExistingId.error", (Object[])new Object[]{id}));
            }
            if (delete) {
                if (this.persistenceService.isTemporaryVesselUsed(id)) {
                    String vesselRef = id + " :" + this.decoratorService.getDecoratorByType(Vessel.class).toString((Object)vessel);
                    throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.vessel.used.error", (Object[])new Object[]{vesselRef}));
                }
                requestResult.addIdToDelete(id);
                requestResult.removeExistingNaturalId(internationalRegistrationCode);
            } else {
                if (StringUtils.isBlank((CharSequence)internationalRegistrationCode)) {
                    throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.vessel.noRegistrationCode.error", (Object[])new Object[]{id}));
                }
                if (!internationalRegistrationCode.equals(vessel.getName()) && !requestResult.addExistingNaturalId(internationalRegistrationCode)) {
                    throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.vessel.existingRegistrationCode.error", (Object[])new Object[]{internationalRegistrationCode}));
                }
                requestResult.addEntityToUpdate(bean.toEntity());
            }
        }
    }

    protected void exportTemporaryVessel(File file, List<Vessel> toExport) throws IOException {
        VesselModel csvModel = new VesselModel(this.getCsvSeparator());
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        List toExportRows = Lists.transform(toExport, (Function)new Function<Vessel, VesselRow>(){

            public VesselRow apply(Vessel vessel) {
                return new VesselRow(vessel);
            }
        });
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExportRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.vessel.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected char getCsvSeparator() {
        return this.context.getConfig().getCsvSeparator();
    }
}

