/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.shared.application.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.shared.application.ApplicationTechnicalException;
import fr.ifremer.shared.application.swing.AbstractApplicationUIHandler;
import fr.ifremer.shared.application.swing.action.AbstractApplicationAction;
import fr.ifremer.shared.application.swing.action.ApplicationUIAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.nuiton.i18n.I18n;

public class ApplicationActionFactory {
    public <A extends AbstractApplicationAction> ApplicationUIAction<A> createUIAction(AbstractApplicationUIHandler handler, Class<A> actionName) {
        return this.createUIAction(handler, null, actionName);
    }

    public <A extends AbstractApplicationAction> ApplicationUIAction<A> createUIAction(AbstractApplicationUIHandler handler, AbstractButton abstractButton, Class<A> actionName) {
        try {
            A logicAction = this.createLogicAction(handler, actionName);
            ApplicationUIAction<A> result = this.createUIAction(abstractButton, logicAction);
            return result;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n._((String)"application.action.create.error", (Object[])new Object[]{actionName}), (Throwable)e);
        }
    }

    public <A extends AbstractApplicationAction> ApplicationUIAction<A> createUIAction(AbstractButton abstractButton, A logicAction) {
        ApplicationUIAction<A> result = new ApplicationUIAction<A>(abstractButton, logicAction);
        return result;
    }

    public <A extends AbstractApplicationAction> A createLogicAction(AbstractApplicationUIHandler handler, Class<A> actionName) {
        try {
            AbstractApplicationAction result = (AbstractApplicationAction)((Object)ConstructorUtils.invokeConstructor(actionName, (Object[])new Object[]{handler}));
            return (A)((Object)result);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n._((String)"application.action.create.error", (Object[])new Object[]{actionName}), (Throwable)e);
        }
    }

    public <A extends AbstractApplicationAction> A getLogicAction(AbstractButton b) {
        Action action = b.getAction();
        Preconditions.checkNotNull((Object)action);
        Preconditions.checkState((boolean)(action instanceof ApplicationUIAction));
        return ((ApplicationUIAction)action).getLogicAction();
    }
}

