/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AliasMap<K, V, A>
extends HashMap<K, V> {
    private static Log log = LogFactory.getLog(AliasMap.class);
    private static final long serialVersionUID = 1L;
    protected MultiValueMap aliases = MultiValueMap.decorate(new HashMap(), HashSet.class);
    protected MultiValueMap keys = MultiValueMap.decorate(new HashMap(), HashSet.class);

    public V put(K key, V value, A alias1, A ... alias) {
        V result = this.put(key, value);
        this.putAlias(key, alias1, alias);
        return result;
    }

    protected void putAlias(K key, A alias1, A ... alias) {
        this.aliases.put(alias1, key);
        this.keys.put(key, alias1);
        for (A a : alias) {
            this.aliases.put(a, key);
            this.keys.put(key, a);
        }
    }

    public Collection<K> getKeyAlias(A ... alias) {
        Set result = null;
        for (A a : alias) {
            Collection tmp = this.aliases.getCollection(a);
            if (tmp == null) continue;
            if (result == null) {
                result = new HashSet(tmp);
                continue;
            }
            result.retainAll(tmp);
        }
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public Collection<V> getValueAlias(A ... alias) {
        Collection<K> keys = this.getKeyAlias(alias);
        HashSet result = new HashSet(keys.size());
        for (K k : keys) {
            result.add(this.get(k));
        }
        return result;
    }

    public Collection<A> getAlias(K key) {
        Set result = this.keys.getCollection(key);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        Object result = super.remove(key);
        Collection<A> alias = this.getAlias(key);
        this.keys.remove(key);
        if (alias != null) {
            for (A a : alias) {
                this.aliases.remove(a, key);
                if (!CollectionUtils.isEmpty((Collection)this.aliases.getCollection(a))) continue;
                this.aliases.remove(a);
            }
        }
        return result;
    }

    public Collection<V> removeValue(A ... alias) {
        Collection<K> keys = this.getKeyAlias(alias);
        ArrayList<V> result = new ArrayList<V>(keys.size());
        for (K k : keys) {
            result.add(this.remove(k));
        }
        return result;
    }

    public void removeAlias(A ... alias) {
        for (A a : alias) {
            Collection ks = this.aliases.getCollection(a);
            this.aliases.remove(a);
            if (ks == null) continue;
            for (Object k : ks) {
                this.keys.remove(k, a);
            }
        }
    }
}

