/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.shared.application.swing.ApplicationUI;
import fr.ifremer.shared.application.swing.tab.TabHandler;
import fr.ifremer.shared.application.type.CoordinateEditorType;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.action.CancelEditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.SecondaryVesselTypeEnum;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.AbstractCaracteristicTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.GearUseFeatureTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.VesselUseFeatureTabUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.caracteristics.GearCaracteristicListCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditFishingOperationUIHandler
extends AbstractTuttiTabContainerUIHandler<EditFishingOperationUIModel, EditFishingOperationUI>
implements TabHandler {
    private static final Log log = LogFactory.getLog(EditFishingOperationUIHandler.class);
    private final PropertyChangeListener startDateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Date oldDate = (Date)evt.getOldValue();
            Date newDate = (Date)evt.getNewValue();
            if (!(newDate == null || ((EditFishingOperationUIModel)EditFishingOperationUIHandler.this.getModel()).getGearShootingEndDate() != null || oldDate != null && DateUtils.isSameDay((Date)oldDate, (Date)newDate))) {
                ((EditFishingOperationUIModel)EditFishingOperationUIHandler.this.getModel()).setGearShootingEndDate(newDate);
            }
        }
    };
    private final PropertyChangeListener coordinatePropertiesListener = new PropertyChangeListener(){
        private List<String> properties = Lists.newArrayList((Object[])new String[]{"fishingOperationRectiligne", "gearShootingEndLatitude", "gearShootingEndLatitudeDms", "gearShootingEndLatitudeDmsSign", "gearShootingEndLatitudeDmsDegree", "gearShootingEndLatitudeDmsMinute", "gearShootingEndLatitudeDmsSecond", "gearShootingEndLatitudeDmd", "gearShootingEndLatitudeDmdSign", "gearShootingEndLatitudeDmdDegree", "gearShootingEndLatitudeDmdMinute", "gearShootingEndLatitudeDmdDecimal", "gearShootingEndLongitude", "gearShootingEndLongitudeDms", "gearShootingEndLongitudeDmsSign", "gearShootingEndLongitudeDmsDegree", "gearShootingEndLongitudeDmsMinute", "gearShootingEndLongitudeDmsSecond", "gearShootingEndLongitudeDmd", "gearShootingEndLongitudeDmdSign", "gearShootingEndLongitudeDmdDegree", "gearShootingEndLongitudeDmdMinute", "gearShootingEndLongitudeDmdDecimal", "gearShootingStartLatitude", "gearShootingStartLatitudeDms", "gearShootingStartLatitudeDmsSign", "gearShootingStartLatitudeDmsDegree", "gearShootingStartLatitudeDmsMinute", "gearShootingStartLatitudeDmsSecond", "gearShootingStartLatitudeDmd", "gearShootingStartLatitudeDmdSign", "gearShootingStartLatitudeDmdDegree", "gearShootingStartLatitudeDmdMinute", "gearShootingStartLatitudeDmdDecimal", "gearShootingStartLongitude", "gearShootingStartLongitudeDms", "gearShootingStartLongitudeDmsSign", "gearShootingStartLongitudeDmsDegree", "gearShootingStartLongitudeDmsMinute", "gearShootingStartLongitudeDmsSecond", "gearShootingStartLongitudeDmd", "gearShootingStartLongitudeDmdSign", "gearShootingStartLongitudeDmdDegree", "gearShootingStartLongitudeDmdMinute", "gearShootingStartLongitudeDmdDecimal"});

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.properties.contains(evt.getPropertyName())) {
                EditFishingOperationUIModel source = (EditFishingOperationUIModel)evt.getSource();
                if (source.isFishingOperationRectiligne()) {
                    source.computeDistance();
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Property %s changed to %s", evt.getPropertyName(), evt.getNewValue()));
                }
            }
        }
    };
    private TuttiBeanMonitor<EditFishingOperationUIModel> fishingOperationMonitor;

    public void setQuadrantValue(int value) {
        if (log.isInfoEnabled()) {
            log.info((Object)("New quadrant value: " + value));
        }
    }

    public boolean isQuadrantSelected(Integer value, int requiredValue) {
        return value != null && value == requiredValue;
    }

    public void beforeInit(EditFishingOperationUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.fishingOperationMonitor = new TuttiBeanMonitor("stationNumber", "fishingOperationNumber", "strata", "subStrata", "gearShootingEndLatitude", "gearShootingEndLatitudeDms", "gearShootingEndLatitudeDmsSign", "gearShootingEndLatitudeDmsDegree", "gearShootingEndLatitudeDmsMinute", "gearShootingEndLatitudeDmsSecond", "gearShootingEndLatitudeDmd", "gearShootingEndLatitudeDmdSign", "gearShootingEndLatitudeDmdDegree", "gearShootingEndLatitudeDmdMinute", "gearShootingEndLongitude", "gearShootingEndLongitudeDms", "gearShootingEndLongitudeDmsSign", "gearShootingEndLongitudeDmsDegree", "gearShootingEndLongitudeDmsMinute", "gearShootingEndLongitudeDmsSecond", "gearShootingEndLongitudeDmd", "gearShootingEndLongitudeDmdSign", "gearShootingEndLongitudeDmdDegree", "gearShootingEndLongitudeDmdMinute", "gearShootingStartLatitude", "gearShootingStartLatitudeDms", "gearShootingStartLatitudeDmsSign", "gearShootingStartLatitudeDmsDegree", "gearShootingStartLatitudeDmsMinute", "gearShootingStartLatitudeDmsSecond", "gearShootingStartLatitudeDmd", "gearShootingStartLatitudeDmdSign", "gearShootingStartLatitudeDmdDegree", "gearShootingStartLatitudeDmdMinute", "gearShootingStartLongitude", "gearShootingStartLongitudeDms", "gearShootingStartLongitudeDmsSign", "gearShootingStartLongitudeDmsDegree", "gearShootingStartLongitudeDmsMinute", "gearShootingStartLongitudeDmsSecond", "gearShootingStartLongitudeDmd", "gearShootingStartLongitudeDmdSign", "gearShootingStartLongitudeDmdDegree", "gearShootingStartLongitudeDmdMinute", "gearShootingStartDate", "gearShootingEndDate", "fishingOperationRectiligne", "trawlDistance", "fishingOperationValid", "location", "recorderPerson", "secondaryVessel", "vessel", "gear", "multirigAggregation", "comment");
        EditFishingOperationUIModel model = new EditFishingOperationUIModel();
        model.setCoordinateEditorType(this.getConfig().getCoordinateEditorType());
        model.setValidationContext(this.getContext().getValidationContext());
        model.addPropertyChangeListener("strata", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditFishingOperationUIModel source = (EditFishingOperationUIModel)evt.getSource();
                TuttiLocation newStrata = (TuttiLocation)evt.getNewValue();
                EditFishingOperationUIHandler.this.onSelectedStrata(source, newStrata);
            }
        });
        model.addPropertyChangeListener("subStrata", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditFishingOperationUIModel source = (EditFishingOperationUIModel)evt.getSource();
                TuttiLocation newStrata = (TuttiLocation)evt.getNewValue();
                EditFishingOperationUIHandler.this.onSelectedSubStrata(source, newStrata);
            }
        });
        this.getContext().addPropertyChangeListener("validationContext", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ((EditFishingOperationUIModel)EditFishingOperationUIHandler.this.getModel()).setValidationContext((String)evt.getNewValue());
            }
        });
        model.addPropertyChangeListener("fishingOperationValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean valid = (Boolean)evt.getNewValue();
                Color color = null;
                Color fontColor = Color.BLACK;
                if (valid == Boolean.TRUE) {
                    color = Color.GREEN;
                } else if (valid == Boolean.FALSE) {
                    color = Color.RED;
                    fontColor = Color.WHITE;
                }
                Component tab = EditFishingOperationUIHandler.this.getTabPanel().getTabComponentAt(0);
                tab.setForeground(fontColor);
                tab.setBackground(color);
            }
        });
        ui.setContextValue(model);
        this.fishingOperationMonitor.setBean(model);
    }

    public void afterInit(EditFishingOperationUI ui) {
        ui.getSecondaryVesselList().getBeforeFilterPanel().add((Component)ui.getSecondaryVesselFilterPane(), "Center");
        ui.getFishingOperationValidPanel().remove(ui.getFishingOperationResetRadio());
        EditFishingOperationUIModel model = (EditFishingOperationUIModel)this.getModel();
        this.initUI(ui);
        List people = this.getDataContext().getPersons();
        this.initBeanList(ui.getRecorderPersonList(), people, model.getRecorderPerson());
        Cruise cruise = this.getDataContext().getCruise();
        Preconditions.checkNotNull((Object)cruise, (Object)"Could not find cruise in ui context");
        ui.getMultirigAggregationField().setEnabled(cruise.getMultirigNumber() != 1);
        this.initBeanFilterableComboBox(ui.getGearComboBox(), Lists.newArrayList(), null, "gearWithrankOrder");
        JComboBox combobox = ui.getGearComboBox().getCombobox();
        combobox.setRenderer(new GearCaracteristicListCellRenderer(combobox.getRenderer(), this.getDecorator(Caracteristic.class, "withUnit"), this.getDecorator(Gear.class, "gearWithrankOrder"), true));
        combobox.addItemListener(new ItemListener(){
            Map<Gear, String> tips = Maps.newHashMap();

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (e.getStateChange() == 1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("itemStateChanged selected " + item + " - " + (item != null ? item.getClass() : null)));
                    }
                    JComboBox combo = (JComboBox)e.getSource();
                    JComponent jC = (JComponent)combo.getEditor().getEditorComponent();
                    GearCaracteristicListCellRenderer renderer = (GearCaracteristicListCellRenderer)combo.getRenderer();
                    String toolTipText = renderer.getToolTipText((Gear)item);
                    jC.setToolTipText(toolTipText);
                } else {
                    JComboBox combo = (JComboBox)e.getSource();
                    JComponent jC = (JComponent)combo.getEditor().getEditorComponent();
                    jC.setToolTipText(null);
                }
            }
        });
        Program program = this.getDataContext().getProgram();
        Preconditions.checkNotNull((Object)program, (Object)"Could not find program in ui context");
        TuttiLocation zone = program.getZone();
        TuttiLocation strata = model.getStrata();
        String strataId = strata == null ? null : strata.getId();
        TuttiLocation subStrata = model.getSubStrata();
        String substrataId = subStrata == null ? null : subStrata.getId();
        TuttiLocation location = model.getLocation();
        PersistenceService persistenceService = this.getPersistenceService();
        String zoneId = zone.getId();
        ArrayList stratas = Lists.newArrayList((Iterable)persistenceService.getAllFishingOperationStrata(zoneId));
        ArrayList subStratas = Lists.newArrayList((Iterable)persistenceService.getAllFishingOperationSubStrata(zoneId, strataId));
        ArrayList locations = Lists.newArrayList((Iterable)persistenceService.getAllFishingOperationLocation(zoneId, strataId, substrataId));
        this.initBeanFilterableComboBox(ui.getStrataComboBox(), stratas, strata);
        this.initBeanFilterableComboBox(ui.getSubStrataComboBox(), subStratas, subStrata);
        this.initBeanFilterableComboBox(ui.getLocationComboBox(), locations, location);
        this.initBeanList(ui.getSecondaryVesselList(), Lists.newArrayList(), model.getSecondaryVessel());
        model.addPropertyChangeListener("fishingOperationNumber", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
        model.addPropertyChangeListener("secondaryVesselType", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditFishingOperationUIModel model = (EditFishingOperationUIModel)evt.getSource();
                boolean modify = model.isModify();
                SecondaryVesselTypeEnum vesselType = (SecondaryVesselTypeEnum)((Object)evt.getNewValue());
                List<Object> vessels = Lists.newArrayList();
                if (vesselType != null) {
                    switch (vesselType) {
                        case SCIENTIFIC: {
                            vessels = model.getScientificSecondaryVessel();
                            break;
                        }
                        case FISHING: {
                            vessels = model.getFishingSecondaryVessel();
                            break;
                        }
                        case ONLY_CRUISE: {
                            vessels = model.getOnlyCruisSecondaryVessel();
                            break;
                        }
                        default: {
                            vessels = model.getAllSecondaryVessel();
                        }
                    }
                }
                ((EditFishingOperationUI)EditFishingOperationUIHandler.this.ui).getSecondaryVesselList().getHandler().clearFilters();
                ArrayList selected = Lists.newArrayList((Iterable)((EditFishingOperationUI)EditFishingOperationUIHandler.this.ui).getSecondaryVesselList().getModel().getSelected());
                ((EditFishingOperationUI)EditFishingOperationUIHandler.this.ui).getSecondaryVesselList().getModel().setUniverse((List)vessels);
                ((EditFishingOperationUI)EditFishingOperationUIHandler.this.ui).getSecondaryVesselList().getModel().setSelected((List)selected);
                model.setModify(modify);
            }
        });
        model.setSecondaryVesselType(null);
        this.changeValidatorContext(model.getValidationContext(), ui.getValidator());
        this.listenValidationTableHasNoFatalError((SimpleBeanValidator)ui.getValidator(), model);
        this.setCustomTab(0, model);
        this.listModelIsModify(model);
        GearUseFeatureTabUIModel gearUseFeatureModel = ui.getGearUseFeatureTabContent().getModel();
        gearUseFeatureModel.setAvailableCaracteristics(this.getDataContext().getCaracteristics());
        this.setCustomTab(1, gearUseFeatureModel);
        this.listenModelModifiy(gearUseFeatureModel);
        VesselUseFeatureTabUIModel vesselUseFeatureModel = ui.getVesselUseFeatureTabContent().getModel();
        vesselUseFeatureModel.setAvailableCaracteristics(this.getDataContext().getCaracteristics());
        this.listenModelModifiy(vesselUseFeatureModel);
        this.setCustomTab(2, vesselUseFeatureModel);
        ((EditFishingOperationUIModel)this.getModel()).addPropertyChangeListener("id", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JButton button = ((EditFishingOperationUI)EditFishingOperationUIHandler.this.ui).getCancelButton();
                CancelEditFishingOperationAction action = (CancelEditFishingOperationAction)EditFishingOperationUIHandler.this.getContext().getActionFactory().getLogicAction((AbstractButton)button);
                if (evt.getNewValue() == null) {
                    button.setText(I18n._((String)"tutti.editFishingOperation.action.cancelEditFishingOperation", (Object[])new Object[0]));
                    button.setToolTipText(I18n._((String)"tutti.editFishingOperation.action.cancelEditFishingOperation.tip", (Object[])new Object[0]));
                    button.setMnemonic(I18n._((String)"tutti.editFishingOperation.action.cancelEditFishingOperation.mnemonic", (Object[])new Object[0]).charAt(0));
                    action.setActionDescription(I18n._((String)"tutti.editFishingOperation.action.cancelEditFishingOperation.tip", (Object[])new Object[0]));
                } else {
                    button.setText(I18n._((String)"tutti.editFishingOperation.action.resetEditFishingOperation", (Object[])new Object[0]));
                    button.setToolTipText(I18n._((String)"tutti.editFishingOperation.action.resetEditFishingOperation.tip", (Object[])new Object[0]));
                    button.setMnemonic(I18n._((String)"tutti.editFishingOperation.action.resetEditFishingOperation.mnemonic", (Object[])new Object[0]).charAt(0));
                    action.setActionDescription(I18n._((String)"tutti.editFishingOperation.action.resetEditFishingOperation.tip", (Object[])new Object[0]));
                }
            }
        });
    }

    protected JComponent getComponentToFocus() {
        return ((EditFishingOperationUI)this.getUI()).getStationNumberField();
    }

    @Override
    protected Set<String> getPropertiesToIgnore() {
        Set<String> result = super.getPropertiesToIgnore();
        result.add("attachment");
        result.add("secondaryVesselType");
        result.add("secondaryVesselTypeAll");
        result.add("secondaryVesselTypeScientific");
        result.add("secondaryVesselTypeFishing");
        result.add("secondaryVesselTypeOnlyCruise");
        return result;
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
        ((EditFishingOperationUI)this.ui).getFishingOperationAttachmentsButton().onCloseUI();
        this.closeUI(((EditFishingOperationUI)this.ui).getGearUseFeatureTabContent());
        this.closeUI(((EditFishingOperationUI)this.ui).getVesselUseFeatureTabContent());
    }

    public SwingValidator<EditFishingOperationUIModel> getValidator() {
        return ((EditFishingOperationUI)this.ui).getValidator();
    }

    public void setDate(ActionEvent event, String property) {
        JXDatePicker field = (JXDatePicker)event.getSource();
        Date value = field.getDate();
        Date date = (Date)TuttiEntities.getProperty((Object)this.getModel(), (String)property);
        if (value != null && date != null) {
            Calendar cal = DateUtils.toCalendar((Date)date);
            value = DateUtils.setHours((Date)value, (int)cal.get(11));
            value = DateUtils.setMinutes((Date)value, (int)cal.get(12));
        }
        TuttiEntities.setProperty((Object)this.getModel(), (String)property, (Object)value);
    }

    @Override
    public boolean onTabChanged(int currentIndex, int newIndex) {
        ((EditFishingOperationUI)this.ui).getFishingOperationAttachmentsButton().onCloseUI();
        return super.onTabChanged(currentIndex, newIndex);
    }

    public JTabbedPane getTabPanel() {
        return ((EditFishingOperationUI)this.ui).getFishingOperationTabPane();
    }

    public boolean onHideTab(int currentIndex, int newIndex) {
        boolean result;
        ((EditFishingOperationUI)this.ui).getFishingOperationAttachmentsButton().onCloseUI();
        if (this.isAModelModified()) {
            EditFishingOperationUIModel model = (EditFishingOperationUIModel)this.getModel();
            if (model.isValid()) {
                String message = TuttiEntities.isNew(model.getFishingOperation()) ? I18n._((String)"tutti.editFishingOperation.askSaveBeforeLeaving.createFishingOperation", (Object[])new Object[0]) : I18n._((String)"tutti.editFishingOperation.askSaveBeforeLeaving.saveFishingOperation", (Object[])new Object[0]);
                int answer = this.askSaveBeforeLeaving(message);
                switch (answer) {
                    case 0: {
                        this.getContext().getActionEngine().runAction((AbstractButton)((EditFishingOperationUI)this.ui).getSaveButton());
                        result = true;
                        break;
                    }
                    case 1: {
                        this.getContext().getActionEngine().runAction((AbstractButton)((EditFishingOperationUI)this.ui).getCancelButton());
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                        break;
                    }
                }
            } else {
                result = this.askCancelEditBeforeLeaving(I18n._((String)"tutti.editFishingOperation.askCancelEditBeforeLeaving.cancelEditFishingOperation", (Object[])new Object[0]));
                if (result) {
                    this.getContext().getActionEngine().runAction((AbstractButton)((EditFishingOperationUI)this.ui).getCancelButton());
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    public void onShowTab(int currentIndex, int newIndex) {
        this.registerValidators(((EditFishingOperationUI)this.ui).getValidator());
    }

    public void registerValidator() {
        this.registerValidators(((EditFishingOperationUI)this.ui).getValidator());
    }

    public AbstractCaracteristicTabUIModel[] getSubModels() {
        return new AbstractCaracteristicTabUIModel[]{((EditFishingOperationUI)this.ui).getGearUseFeatureTabContent().getModel(), ((EditFishingOperationUI)this.ui).getVesselUseFeatureTabContent().getModel()};
    }

    public void uninstallStartDateListener() {
        ((EditFishingOperationUIModel)this.getModel()).removePropertyChangeListener("gearShootingStartDate", this.startDateListener);
    }

    public void installStartDateListener() {
        ((EditFishingOperationUIModel)this.getModel()).addPropertyChangeListener("gearShootingStartDate", this.startDateListener);
    }

    public void uninstallCoordinatesListener() {
        ((EditFishingOperationUIModel)this.getModel()).removePropertyChangeListener(this.coordinatePropertiesListener);
    }

    public void installCoordinatesListener() {
        ((EditFishingOperationUIModel)this.getModel()).addPropertyChangeListener(this.coordinatePropertiesListener);
    }

    public FishingOperationsUI getParentUi() {
        return (FishingOperationsUI)this.getParentContainer(FishingOperationsUI.class);
    }

    public TuttiBeanMonitor<EditFishingOperationUIModel> getFishingOperationMonitor() {
        return this.fishingOperationMonitor;
    }

    public String getGearLatitudeLabelText(CoordinateEditorType coordinateEditorType) {
        String result = I18n._((String)"tutti.editFishingOperation.field.gearLatitude", (Object[])new Object[]{coordinateEditorType.toString()});
        return result;
    }

    public String getGearLongitudeLabelText(CoordinateEditorType coordinateEditorType) {
        String result = I18n._((String)"tutti.editFishingOperation.field.gearLongitude", (Object[])new Object[]{coordinateEditorType.toString()});
        return result;
    }

    public String getTrawlDistanceTooltipText(Float trawlDistance) {
        String result = trawlDistance == null ? null : I18n._((String)"tutti.editFishingOperation.field.trawlDistance.inMilles.tip", (Object[])new Object[]{TuttiEntities.getDistanceInMilles((Float)trawlDistance)});
        return result;
    }

    public String getDuration(Date startDate, Date endDate) {
        String duration = TuttiEntities.getDuration((Date)startDate, (Date)endDate, (String)I18n._((String)"tutti.editFishingOperation.duration.format", (Object[])new Object[0]));
        return duration;
    }

    public String decorateVessel(Vessel vessel) {
        return this.decorate(vessel);
    }

    protected void onSelectedStrata(EditFishingOperationUIModel model, TuttiLocation newStrata) {
        model.setSubStrata(null);
        ((EditFishingOperationUI)this.ui).getSubStrataComboBox().setData(null);
        TuttiLocation zone = this.getDataContext().getProgram().getZone();
        String zoneId = zone.getId();
        String strataId = newStrata == null ? null : newStrata.getId();
        List subStrata = this.getPersistenceService().getAllFishingOperationSubStrata(zoneId, strataId);
        List location = this.getPersistenceService().getAllFishingOperationLocation(zoneId, strataId, null);
        ((EditFishingOperationUI)this.ui).getSubStrataComboBox().setData(subStrata);
        ((EditFishingOperationUI)this.ui).getLocationComboBox().setData(location);
        if (newStrata == null) {
            ((EditFishingOperationUI)this.ui).getStrataComboBox().grabFocus();
        } else if (CollectionUtils.isEmpty((Collection)subStrata)) {
            ((EditFishingOperationUI)this.ui).getLocationComboBox().grabFocus();
        }
    }

    protected void onSelectedSubStrata(EditFishingOperationUIModel model, TuttiLocation newSubStrata) {
        model.setLocation(null);
        ((EditFishingOperationUI)this.ui).getLocationComboBox().setData(null);
        TuttiLocation zone = this.getDataContext().getProgram().getZone();
        String zoneId = zone.getId();
        TuttiLocation strata = model.getStrata();
        String subStrataId = newSubStrata == null ? null : newSubStrata.getId();
        String strataId = strata == null ? null : strata.getId();
        List location = this.getPersistenceService().getAllFishingOperationLocation(zoneId, strataId, subStrataId);
        ((EditFishingOperationUI)this.ui).getLocationComboBox().setData(location);
        if (newSubStrata == null) {
            ((EditFishingOperationUI)this.ui).getSubStrataComboBox().grabFocus();
        }
    }

    protected boolean areAllModelsValid() {
        AbstractCaracteristicTabUIModel[] subModels;
        boolean result = ((EditFishingOperationUIModel)this.getModel()).isValid();
        for (AbstractCaracteristicTabUIModel subModel : subModels = this.getSubModels()) {
            result &= subModel.isValid();
        }
        return result;
    }

    protected boolean isAModelModified() {
        AbstractCaracteristicTabUIModel[] subModels;
        boolean result = ((EditFishingOperationUIModel)this.getModel()).isModify();
        for (AbstractCaracteristicTabUIModel subModel : subModels = this.getSubModels()) {
            result |= subModel.isModify();
        }
        return result;
    }

    public void resetAllModels() {
        for (AbstractCaracteristicTabUIModel subModel : this.getSubModels()) {
            subModel.setModify(false);
        }
        ((EditFishingOperationUIModel)this.getModel()).setModify(false);
    }
}

