/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ichtyometer.feed;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FeedReaderRecord {
    private static final Log log = LogFactory.getLog(FeedReaderRecord.class);
    protected final String record;
    protected final String crc;
    protected final String computedCrc;
    protected final Float length;
    protected final boolean valid;

    public FeedReaderRecord(String record, String crc) {
        this.record = record;
        this.crc = crc;
        this.computedCrc = this.computeCRC(record);
        this.length = this.computeLength(record);
        this.valid = this.length != null;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getRecord() {
        return this.record;
    }

    public String getCrc() {
        return this.crc;
    }

    public String getComputedCrc() {
        return this.computedCrc;
    }

    public Float getLength() {
        return this.length;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("record", (Object)this.record).append("crc", (Object)this.crc).append("computedCrc", (Object)this.computedCrc).append("valid", this.valid).append("length", (Object)this.length).toString();
    }

    protected String computeCRC(String record) {
        long checksum = 0L;
        long mask = 0xFFFFFFFFL;
        int recordLength = record.length();
        for (int i = 0; i < recordLength; ++i) {
            long msb = (checksum &= mask) >> 31;
            log.debug((Object)String.format("i=%4d char=%s(int:%3d) incoming checksum=%10d msb=%d bits=%33s", i, Character.valueOf(record.charAt(i)), (int)record.charAt(i), checksum, msb, Long.toBinaryString(checksum)));
            log.debug((Object)String.format("After lef shift   : %33s", Long.toBinaryString(checksum <<= 1)));
            log.debug((Object)String.format("After add smb     : %33s", Long.toBinaryString(checksum += msb)));
            log.debug((Object)String.format("After add car     : %33s", Long.toBinaryString(checksum += (long)record.charAt(i))));
        }
        String hex = Long.toHexString(checksum).toUpperCase();
        log.debug((Object)("checksum= " + checksum));
        return hex;
    }

    protected Float computeLength(String record) {
        Float length;
        try {
            String[] cells = record.split("\\s*,\\s*");
            String lengthCell = cells[0];
            lengthCell = lengthCell.replaceAll("\\s*", "");
            lengthCell = lengthCell.replaceAll("^0*", "");
            length = Float.valueOf(lengthCell);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Could not get length from " + record), (Throwable)e);
            }
            length = null;
        }
        return length;
    }
}

