/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class EditProtocolAction
extends AbstractChangeScreenAction {
    private static final Log log = LogFactory.getLog(EditProtocolAction.class);
    public static final JAXXContextEntryDef<TuttiProtocol> CLEAN_PROTOCOL_ENTRY = new JAXXContextEntryDef("cleanProtocol", TuttiProtocol.class);

    public EditProtocolAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.EDIT_PROTOCOL);
    }

    @Override
    public boolean prepareAction() throws Exception {
        CLEAN_PROTOCOL_ENTRY.removeContextValue((JAXXContext)this.getContext().getMainUI());
        boolean doAction = super.prepareAction();
        if (doAction) {
            SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
            TuttiProtocol protocol = this.getDataContext().getProtocol();
            HashSet badCategories = Sets.newHashSet();
            TuttiProtocols.checkSampleCategories(sampleCategoryModel, protocol, badCategories);
            if (!badCategories.isEmpty()) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("There is some bad categories: " + badCategories));
                }
                String message = TuttiProtocols.getBadCategoriesMessage(badCategories, this.getDecorator(Caracteristic.class, null), (TuttiPersistence)this.getContext().getPersistenceService());
                String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", message, I18n._((String)"tutti.common.askBeforeEditProtocol.help", (Object[])new Object[0]));
                int response = JOptionPane.showOptionDialog(this.getContext().getActionUI(), htmlMessage, I18n._((String)"tutti.common.askBeforeEditProtocol.title", (Object[])new Object[0]), 0, 2, UIManager.getIcon("warning"), new Object[]{I18n._((String)"tutti.option.cleanAndEdit", (Object[])new Object[0]), I18n._((String)"tutti.option.edit", (Object[])new Object[0]), I18n._((String)"tutti.option.cancel", (Object[])new Object[0])}, I18n._((String)"tutti.option.cancel", (Object[])new Object[0]));
                switch (response) {
                    case 0: {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Clean and edit");
                        }
                        protocol = this.getContext().getPersistenceService().getProtocol(this.getContext().getProtocolId());
                        CLEAN_PROTOCOL_ENTRY.setContextValue((JAXXContext)this.getContext().getMainUI(), (Object)protocol);
                        TuttiProtocols.removeBadCategories(sampleCategoryModel, protocol);
                        break;
                    }
                    case 1: {
                        if (!log.isInfoEnabled()) break;
                        log.info((Object)"Edit with no cleaning");
                        break;
                    }
                    default: {
                        doAction = false;
                    }
                }
            }
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkState((boolean)this.getContext().isProtocolFilled());
        if (log.isInfoEnabled()) {
            log.info((Object)("Edit protocol: " + this.getContext().getProtocolId()));
        }
        this.createProgressionModelIfRequired(4);
        super.doAction();
    }
}

