/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content;

import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.db.ImportDbAction;
import fr.ifremer.tutti.ui.swing.content.db.InstallDbAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class StartAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(StartAction.class);
    protected AbstractMainUITuttiAction delegateAction;

    public StartAction(MainUIHandler handler) {
        super(handler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareAction() throws Exception {
        File actionfile = this.getConfig().getStartActionFile();
        boolean doAction = actionfile.exists();
        if (doAction) {
            block8: {
                try {
                    String content = TuttiIOUtil.readContent(actionfile, I18n._((String)"tutti.error.read.startActionFile", (Object[])new Object[]{actionfile}));
                    content = content.trim();
                    if (InstallDbAction.class.getName().equals(content)) {
                        this.delegateAction = TuttiActionHelper.createLogicAction(this.getHandler(), InstallDbAction.class);
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Found install db action");
                        }
                        break block8;
                    }
                    if (content.startsWith(ImportDbAction.class.getName())) {
                        ImportDbAction action = TuttiActionHelper.createLogicAction(this.getHandler(), ImportDbAction.class);
                        File importFile = new File(content.substring(ImportDbAction.class.getName().length() + 1));
                        action.setImportFile(importFile);
                        this.delegateAction = action;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Found import db action (with file " + importFile + ")"));
                        }
                        break block8;
                    }
                    doAction = false;
                }
                catch (Throwable throwable) {
                    TuttiIOUtil.deleteFile(actionfile, I18n._((String)"tutti.error.delete.startActionFile", (Object[])new Object[]{actionfile}));
                    throw throwable;
                }
            }
            TuttiIOUtil.deleteFile(actionfile, I18n._((String)"tutti.error.delete.startActionFile", (Object[])new Object[]{actionfile}));
        }
        if (doAction) {
            this.setActionDescription(this.delegateAction.getActionDescription());
            doAction = this.delegateAction.prepareAction();
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        TuttiActionHelper.runInternalAction(this.delegateAction);
    }

    @Override
    protected void releaseAction() {
        this.delegateAction = null;
        super.releaseAction();
    }
}

