/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BadPdfFormatException;
import com.itextpdf.text.pdf.ByteBuffer;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PageResources;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfContents;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfDocument;
import com.itextpdf.text.pdf.PdfException;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfIndirectObject;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNull;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfOutline;
import com.itextpdf.text.pdf.PdfPage;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfReaderInstance;
import com.itextpdf.text.pdf.PdfRectangle;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfStructTreeController;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfCopy
extends PdfWriter {
    protected HashMap<RefKey, IndirectReferences> indirects;
    protected HashMap<PdfReader, HashMap<RefKey, IndirectReferences>> indirectMap;
    protected HashMap<PdfObject, PdfObject> parentObjects;
    protected HashSet<PdfObject> disableIndirects;
    protected PdfReader reader;
    protected PdfIndirectReference acroForm;
    protected int[] namePtr = new int[]{0};
    private boolean rotateContents = true;
    protected PdfArray fieldArray;
    protected HashSet<PdfTemplate> fieldTemplates;
    private PdfStructTreeController structTreeController = null;
    private int currentStructArrayNumber = 0;
    protected PRIndirectReference structTreeRootReference;
    protected HashMap<RefKey, PdfIndirectObject> indirectObjects;
    protected ArrayList<PdfIndirectObject> savedObjects;
    protected ArrayList<ImportedPage> importedPages;
    protected HashSet<RefKey> streams;
    protected boolean updateRootKids = false;

    public PdfCopy(Document document, OutputStream os) throws DocumentException {
        super(new PdfDocument(), os);
        document.addDocListener(this.pdf);
        this.pdf.addWriter(this);
        this.indirectMap = new HashMap();
        this.parentObjects = new HashMap();
        this.disableIndirects = new HashSet();
        this.indirectObjects = new HashMap();
        this.savedObjects = new ArrayList();
        this.importedPages = new ArrayList();
        this.streams = new HashSet();
    }

    @Override
    public void setPageEvent(PdfPageEvent event) {
        throw new UnsupportedOperationException();
    }

    public boolean isRotateContents() {
        return this.rotateContents;
    }

    public void setRotateContents(boolean rotateContents) {
        this.rotateContents = rotateContents;
    }

    @Override
    public PdfImportedPage getImportedPage(PdfReader reader, int pageNumber) {
        if (this.structTreeController != null) {
            this.structTreeController.reader = null;
        }
        this.disableIndirects.clear();
        this.parentObjects.clear();
        return this.getImportedPageImpl(reader, pageNumber);
    }

    public PdfImportedPage getImportedPage(PdfReader reader, int pageNumber, boolean keepTaggedPdfStructure) throws BadPdfFormatException {
        this.updateRootKids = false;
        if (!keepTaggedPdfStructure) {
            return this.getImportedPage(reader, pageNumber);
        }
        if (this.structTreeController != null) {
            if (reader != this.structTreeController.reader) {
                this.structTreeController.setReader(reader);
            }
        } else {
            this.structTreeController = new PdfStructTreeController(reader, this);
        }
        ImportedPage newPage = new ImportedPage(reader, pageNumber);
        switch (this.checkStructureTreeRootKids(newPage)) {
            case -1: {
                this.clearIndirects(reader);
                this.updateRootKids = true;
                break;
            }
            case 0: {
                this.updateRootKids = false;
                break;
            }
            case 1: {
                this.updateRootKids = true;
            }
        }
        this.importedPages.add(newPage);
        this.disableIndirects.clear();
        this.parentObjects.clear();
        return this.getImportedPageImpl(reader, pageNumber);
    }

    private void clearIndirects(PdfReader reader) {
        HashMap<RefKey, IndirectReferences> currIndirects = this.indirectMap.get(reader);
        ArrayList<RefKey> forDelete = new ArrayList<RefKey>();
        for (Map.Entry<RefKey, IndirectReferences> entry : currIndirects.entrySet()) {
            PdfIndirectReference iRef = entry.getValue().theRef;
            RefKey key = new RefKey(iRef);
            PdfIndirectObject iobj = this.indirectObjects.get(key);
            if (iobj == null) {
                if (this.streams.contains(key)) continue;
                forDelete.add(entry.getKey());
                continue;
            }
            if (!iobj.object.isArray() && !iobj.object.isDictionary()) continue;
            forDelete.add(entry.getKey());
        }
        for (RefKey key : forDelete) {
            currIndirects.remove(key);
        }
    }

    private int checkStructureTreeRootKids(ImportedPage newPage) {
        if (this.importedPages.size() == 0) {
            return 1;
        }
        boolean readerExist = false;
        for (ImportedPage page : this.importedPages) {
            if (!page.reader.equals(newPage.reader)) continue;
            readerExist = true;
            break;
        }
        if (!readerExist) {
            return 1;
        }
        ImportedPage lastPage = this.importedPages.get(this.importedPages.size() - 1);
        boolean equalReader = lastPage.reader.equals(newPage.reader);
        if (equalReader && newPage.pageNumber > lastPage.pageNumber) {
            return 0;
        }
        return -1;
    }

    protected void fixStructureTreeRoot(HashSet<RefKey> activeKeys, HashSet<PdfName> activeClassMaps) {
        HashMap<PdfName, PdfObject> newClassMap = new HashMap<PdfName, PdfObject>(activeClassMaps.size());
        for (PdfName key : activeClassMaps) {
            PdfObject cm = this.structureTreeRoot.classes.get(key);
            if (cm == null) continue;
            newClassMap.put(key, cm);
        }
        this.structureTreeRoot.classes = newClassMap;
        PdfArray kids = this.structureTreeRoot.getAsArray(PdfName.K);
        if (kids != null) {
            for (int i = 0; i < kids.size(); ++i) {
                PdfIndirectReference iref = (PdfIndirectReference)kids.getPdfObject(i);
                RefKey key = new RefKey(iref);
                if (activeKeys.contains(key)) continue;
                kids.remove(i--);
            }
        }
    }

    protected PdfImportedPage getImportedPageImpl(PdfReader reader, int pageNumber) {
        if (this.currentPdfReaderInstance != null) {
            if (this.currentPdfReaderInstance.getReader() != reader) {
                this.currentPdfReaderInstance = super.getPdfReaderInstance(reader);
            }
        } else {
            this.currentPdfReaderInstance = super.getPdfReaderInstance(reader);
        }
        return this.currentPdfReaderInstance.getImportedPage(pageNumber);
    }

    protected PdfIndirectReference copyIndirect(PRIndirectReference in, boolean keepStructure, boolean directRootKids) throws IOException, BadPdfFormatException {
        PdfObject type;
        PdfIndirectReference theRef;
        PdfDictionary dict;
        RefKey key = new RefKey(in);
        IndirectReferences iRef = this.indirects.get(key);
        PdfObject obj = PdfReader.getPdfObjectRelease(in);
        if (keepStructure && directRootKids && obj instanceof PdfDictionary && (dict = (PdfDictionary)obj).contains(PdfName.PG)) {
            return null;
        }
        if (iRef != null) {
            theRef = iRef.getRef();
            if (iRef.getCopied()) {
                return theRef;
            }
        } else {
            theRef = this.body.getPdfIndirectReference();
            iRef = new IndirectReferences(theRef);
            this.indirects.put(key, iRef);
        }
        if (obj != null && obj.isDictionary() && (type = PdfReader.getPdfObjectRelease(((PdfDictionary)obj).get(PdfName.TYPE))) != null && PdfName.PAGE.equals(type)) {
            return theRef;
        }
        iRef.setCopied();
        this.parentObjects.put(obj, in);
        PdfObject res = this.copyObject(obj, keepStructure, directRootKids);
        if (this.disableIndirects.contains(obj)) {
            iRef.setNotCopied();
        }
        if (res != null && !(res instanceof PdfNull)) {
            this.addToBody(res, theRef);
            return theRef;
        }
        this.indirects.remove(key);
        return null;
    }

    protected PdfIndirectReference copyIndirect(PRIndirectReference in) throws IOException, BadPdfFormatException {
        return this.copyIndirect(in, false, false);
    }

    protected PdfDictionary copyDictionary(PdfDictionary in, boolean keepStruct, boolean directRootKids) throws IOException, BadPdfFormatException {
        PdfDictionary out = new PdfDictionary();
        PdfObject type = PdfReader.getPdfObjectRelease(in.get(PdfName.TYPE));
        if (keepStruct) {
            if (directRootKids && in.contains(PdfName.PG)) {
                PdfObject curr = in;
                this.disableIndirects.add(curr);
                while (this.parentObjects.containsKey(curr) && !this.disableIndirects.contains(curr)) {
                    curr = this.parentObjects.get(curr);
                    this.disableIndirects.add(curr);
                }
                return null;
            }
            PdfName structType = in.getAsName(PdfName.S);
            this.structTreeController.addRole(structType);
            this.structTreeController.addClass(in);
        }
        Iterator<PdfName> i$ = in.getKeys().iterator();
        while (i$.hasNext()) {
            PdfObject res;
            PdfName element;
            PdfName key = element = i$.next();
            PdfObject value = in.get(key);
            if (this.structTreeController != null && this.structTreeController.reader != null && key.equals(PdfName.STRUCTPARENTS)) {
                out.put(key, new PdfNumber(this.currentStructArrayNumber));
                this.structTreeController.copyStructTreeForPage((PdfNumber)value, this.currentStructArrayNumber++);
                continue;
            }
            if (type != null && PdfName.PAGE.equals(type)) {
                if (key.equals(PdfName.B) || key.equals(PdfName.PARENT)) continue;
                this.parentObjects.put(value, in);
                res = this.copyObject(value, keepStruct, directRootKids);
                if (res == null || res instanceof PdfNull) continue;
                out.put(key, res);
                continue;
            }
            res = this.tagged && value.isIndirect() && this.isStructTreeRootReference((PRIndirectReference)value) ? this.structureTreeRoot.getReference() : this.copyObject(value, keepStruct, directRootKids);
            if (res == null || res instanceof PdfNull) continue;
            out.put(key, res);
        }
        return out;
    }

    protected PdfDictionary copyDictionary(PdfDictionary in) throws IOException, BadPdfFormatException {
        return this.copyDictionary(in, false, false);
    }

    protected PdfStream copyStream(PRStream in) throws IOException, BadPdfFormatException {
        PRStream out = new PRStream(in, null);
        Iterator<PdfName> i$ = in.getKeys().iterator();
        while (i$.hasNext()) {
            PdfName element;
            PdfName key = element = i$.next();
            PdfObject value = in.get(key);
            this.parentObjects.put(value, in);
            PdfObject res = this.copyObject(value);
            if (res == null || res instanceof PdfNull) continue;
            out.put(key, res);
        }
        return out;
    }

    protected PdfArray copyArray(PdfArray in, boolean keepStruct, boolean directRootKids) throws IOException, BadPdfFormatException {
        PdfArray out = new PdfArray();
        ListIterator<PdfObject> i = in.listIterator();
        while (i.hasNext()) {
            PdfObject value = (PdfObject)i.next();
            this.parentObjects.put(value, in);
            PdfObject res = this.copyObject(value, keepStruct, directRootKids);
            if (res == null || res instanceof PdfNull) continue;
            out.add(res);
        }
        return out;
    }

    protected PdfArray copyArray(PdfArray in) throws IOException, BadPdfFormatException {
        return this.copyArray(in, false, false);
    }

    protected PdfObject copyObject(PdfObject in, boolean keepStruct, boolean directRootKids) throws IOException, BadPdfFormatException {
        if (in == null) {
            return PdfNull.PDFNULL;
        }
        switch (in.type) {
            case 6: {
                return this.copyDictionary((PdfDictionary)in, keepStruct, directRootKids);
            }
            case 10: {
                if (!keepStruct && !directRootKids) {
                    return this.copyIndirect((PRIndirectReference)in);
                }
                return this.copyIndirect((PRIndirectReference)in, keepStruct, directRootKids);
            }
            case 5: {
                return this.copyArray((PdfArray)in, keepStruct, directRootKids);
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return in;
            }
            case 7: {
                return this.copyStream((PRStream)in);
            }
        }
        if (in.type < 0) {
            String lit = ((PdfLiteral)in).toString();
            if (lit.equals("true") || lit.equals("false")) {
                return new PdfBoolean(lit);
            }
            return new PdfLiteral(lit);
        }
        System.out.println("CANNOT COPY type " + in.type);
        return null;
    }

    protected PdfObject copyObject(PdfObject in) throws IOException, BadPdfFormatException {
        return this.copyObject(in, false, false);
    }

    protected int setFromIPage(PdfImportedPage iPage) {
        int pageNum = iPage.getPageNumber();
        PdfReaderInstance inst = this.currentPdfReaderInstance = iPage.getPdfReaderInstance();
        this.reader = inst.getReader();
        this.setFromReader(this.reader);
        return pageNum;
    }

    protected void setFromReader(PdfReader reader) {
        this.reader = reader;
        this.indirects = this.indirectMap.get(reader);
        if (this.indirects == null) {
            this.indirects = new HashMap();
            this.indirectMap.put(reader, this.indirects);
            PdfDictionary catalog = reader.getCatalog();
            PRIndirectReference ref = null;
            PdfObject o = catalog.get(PdfName.ACROFORM);
            if (o == null || o.type() != 10) {
                return;
            }
            ref = (PRIndirectReference)o;
            if (this.acroForm == null) {
                this.acroForm = this.body.getPdfIndirectReference();
            }
            this.indirects.put(new RefKey(ref), new IndirectReferences(this.acroForm));
        }
    }

    public void addPage(PdfImportedPage iPage) throws IOException, BadPdfFormatException {
        int pageNum = this.setFromIPage(iPage);
        PdfDictionary thePage = this.reader.getPageN(pageNum);
        PRIndirectReference origRef = this.reader.getPageOrigRef(pageNum);
        this.reader.releasePage(pageNum);
        RefKey key = new RefKey(origRef);
        IndirectReferences iRef = this.indirects.get(key);
        if (iRef != null && !iRef.getCopied()) {
            this.pageReferences.add(iRef.getRef());
            iRef.setCopied();
        }
        PdfIndirectReference pageRef = this.getCurrentPage();
        if (iRef == null) {
            iRef = new IndirectReferences(pageRef);
            this.indirects.put(key, iRef);
        }
        iRef.setCopied();
        if (this.tagged) {
            this.structTreeRootReference = (PRIndirectReference)this.reader.getCatalog().get(PdfName.STRUCTTREEROOT);
        }
        PdfDictionary newPage = this.copyDictionary(thePage);
        this.root.addPage(newPage);
        iPage.setCopied();
        ++this.currentPageNumber;
        this.structTreeRootReference = null;
    }

    public void addPage(Rectangle rect, int rotation) throws DocumentException {
        PdfRectangle mediabox = new PdfRectangle(rect, rotation);
        PageResources resources = new PageResources();
        PdfPage page = new PdfPage(mediabox, new HashMap<String, PdfRectangle>(), resources.getResources(), 0);
        page.put(PdfName.TABS, this.getTabs());
        this.root.addPage(page);
        ++this.currentPageNumber;
    }

    @Override
    public PdfIndirectObject addToBody(PdfObject object, PdfIndirectReference ref) throws IOException {
        if (this.tagged && this.indirectObjects != null && (object.isArray() || object.isDictionary())) {
            RefKey key = new RefKey(ref);
            PdfIndirectObject obj = this.indirectObjects.get(key);
            if (obj == null) {
                obj = new PdfIndirectObject(ref, object, (PdfWriter)this);
                this.indirectObjects.put(key, obj);
            }
            return obj;
        }
        if (this.tagged && object.isStream()) {
            this.streams.add(new RefKey(ref));
        }
        return super.addToBody(object, ref);
    }

    @Override
    public PdfIndirectObject addToBody(PdfObject object) throws IOException {
        PdfIndirectObject iobj = super.addToBody(object);
        if (this.tagged && this.indirectObjects != null) {
            this.savedObjects.add(iobj);
            RefKey key = new RefKey(iobj.number, iobj.generation);
            if (!this.indirectObjects.containsKey(key)) {
                this.indirectObjects.put(key, iobj);
            }
        }
        return iobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushTaggedObjects() throws IOException {
        try {
            this.fixTaggedStructure();
        }
        catch (ClassCastException classCastException) {
        }
        finally {
            this.flushIndirectObjects();
        }
    }

    protected void fixTaggedStructure() throws IOException {
        HashMap<Integer, PdfIndirectReference> numTree = this.structureTreeRoot.getNumTree();
        HashSet<RefKey> activeKeys = new HashSet<RefKey>();
        ArrayList<PdfIndirectReference> actives = new ArrayList<PdfIndirectReference>();
        if (this.pageReferences.size() == numTree.size()) {
            for (int i = numTree.size() - 1; i >= 0; --i) {
                PdfIndirectReference currNum = numTree.get(i);
                RefKey numKey = new RefKey(currNum);
                activeKeys.add(numKey);
                actives.add(currNum);
                PdfObject obj = this.indirectObjects.get((Object)numKey).object;
                PdfArray currNums = (PdfArray)obj;
                PdfIndirectReference currPage = (PdfIndirectReference)this.pageReferences.get(i);
                actives.add(currPage);
                activeKeys.add(new RefKey(currPage));
                PdfIndirectReference prevKid = null;
                for (int j = 0; j < currNums.size(); ++j) {
                    PdfDictionary dict;
                    PdfIndirectReference pg;
                    PdfIndirectReference currKid = (PdfIndirectReference)currNums.getDirectObject(j);
                    if (currKid.equals(prevKid)) continue;
                    RefKey kidKey = new RefKey(currKid);
                    activeKeys.add(kidKey);
                    actives.add(currKid);
                    PdfIndirectObject iobj = this.indirectObjects.get(kidKey);
                    if (iobj.object.isDictionary() && !this.pageReferences.contains(pg = (PdfIndirectReference)(dict = (PdfDictionary)iobj.object).get(PdfName.PG)) && !pg.equals(currPage)) {
                        PdfObject firstKid;
                        dict.put(PdfName.PG, currPage);
                        PdfArray kids = dict.getAsArray(PdfName.K);
                        if (kids != null && (firstKid = kids.getDirectObject(0)).isNumber()) {
                            kids.remove(0);
                        }
                    }
                    prevKid = currKid;
                }
            }
        } else {
            return;
        }
        HashSet<PdfName> activeClassMaps = new HashSet<PdfName>();
        this.findActives(actives, activeKeys, activeClassMaps);
        ArrayList<PdfIndirectReference> newRefs = this.findActiveParents(activeKeys);
        this.fixPgKey(newRefs, activeKeys);
        this.fixStructureTreeRoot(activeKeys, activeClassMaps);
        for (Map.Entry<RefKey, PdfIndirectObject> entry : this.indirectObjects.entrySet()) {
            PdfObject kids;
            if (!activeKeys.contains(entry.getKey())) {
                entry.setValue(null);
                continue;
            }
            if (entry.getValue().object.isArray()) {
                this.removeInactiveReferences((PdfArray)entry.getValue().object, activeKeys);
                continue;
            }
            if (!entry.getValue().object.isDictionary() || (kids = ((PdfDictionary)entry.getValue().object).get(PdfName.K)) == null || !kids.isArray()) continue;
            this.removeInactiveReferences((PdfArray)kids, activeKeys);
        }
    }

    private void removeInactiveReferences(PdfArray array, HashSet<RefKey> activeKeys) {
        for (int i = 0; i < array.size(); ++i) {
            PdfObject obj = array.getPdfObject(i);
            if ((obj.type() != 0 || activeKeys.contains(new RefKey((PdfIndirectReference)obj))) && (!obj.isDictionary() || !this.containsInactivePg((PdfDictionary)obj, activeKeys))) continue;
            array.remove(i--);
        }
    }

    private boolean containsInactivePg(PdfDictionary dict, HashSet<RefKey> activeKeys) {
        PdfObject pg = dict.get(PdfName.PG);
        return pg != null && !activeKeys.contains(new RefKey((PdfIndirectReference)pg));
    }

    private ArrayList<PdfIndirectReference> findActiveParents(HashSet<RefKey> activeKeys) {
        ArrayList<PdfIndirectReference> newRefs = new ArrayList<PdfIndirectReference>();
        ArrayList<RefKey> tmpActiveKeys = new ArrayList<RefKey>(activeKeys);
        for (int i = 0; i < tmpActiveKeys.size(); ++i) {
            RefKey key;
            PdfObject parent;
            PdfIndirectObject iobj = this.indirectObjects.get(tmpActiveKeys.get(i));
            if (iobj == null || !iobj.object.isDictionary() || (parent = ((PdfDictionary)iobj.object).get(PdfName.P)) == null || parent.type() != 0 || activeKeys.contains(key = new RefKey((PdfIndirectReference)parent))) continue;
            activeKeys.add(key);
            tmpActiveKeys.add(key);
            newRefs.add((PdfIndirectReference)parent);
        }
        return newRefs;
    }

    private void fixPgKey(ArrayList<PdfIndirectReference> newRefs, HashSet<RefKey> activeKeys) {
        block0: for (PdfIndirectReference iref : newRefs) {
            PdfArray kids;
            PdfDictionary dict;
            PdfObject pg;
            PdfIndirectObject iobj = this.indirectObjects.get(new RefKey(iref));
            if (iobj == null || !iobj.object.isDictionary() || (pg = (dict = (PdfDictionary)iobj.object).get(PdfName.PG)) == null || activeKeys.contains(new RefKey((PdfIndirectReference)pg)) || (kids = dict.getAsArray(PdfName.K)) == null) continue;
            for (int i = 0; i < kids.size(); ++i) {
                PdfObject kidPg;
                PdfObject obj = kids.getPdfObject(i);
                if (obj.type() != 0) {
                    kids.remove(i--);
                    continue;
                }
                PdfIndirectObject kid = this.indirectObjects.get(new RefKey((PdfIndirectReference)obj));
                if (kid == null || !kid.object.isDictionary() || (kidPg = ((PdfDictionary)kid.object).get(PdfName.PG)) == null || !activeKeys.contains(new RefKey((PdfIndirectReference)kidPg))) continue;
                dict.put(PdfName.PG, kidPg);
                continue block0;
            }
        }
    }

    private void findActives(ArrayList<PdfIndirectReference> actives, HashSet<RefKey> activeKeys, HashSet<PdfName> activeClassMaps) {
        block5: for (int i = 0; i < actives.size(); ++i) {
            RefKey key = new RefKey(actives.get(i));
            PdfIndirectObject iobj = this.indirectObjects.get(key);
            if (iobj == null || iobj.object == null) continue;
            switch (iobj.object.type()) {
                case 0: {
                    this.findActivesFromReference((PdfIndirectReference)iobj.object, actives, activeKeys);
                    continue block5;
                }
                case 5: {
                    this.findActivesFromArray((PdfArray)iobj.object, actives, activeKeys, activeClassMaps);
                    continue block5;
                }
                case 6: {
                    this.findActivesFromDict((PdfDictionary)iobj.object, actives, activeKeys, activeClassMaps);
                }
            }
        }
    }

    private void findActivesFromReference(PdfIndirectReference iref, ArrayList<PdfIndirectReference> actives, HashSet<RefKey> activeKeys) {
        RefKey key = new RefKey(iref);
        PdfIndirectObject iobj = this.indirectObjects.get(key);
        if (iobj != null && iobj.object.isDictionary() && this.containsInactivePg((PdfDictionary)iobj.object, activeKeys)) {
            return;
        }
        if (!activeKeys.contains(key)) {
            activeKeys.add(key);
            actives.add(iref);
        }
    }

    private void findActivesFromArray(PdfArray array, ArrayList<PdfIndirectReference> actives, HashSet<RefKey> activeKeys, HashSet<PdfName> activeClassMaps) {
        for (PdfObject obj : array) {
            switch (obj.type()) {
                case 0: {
                    this.findActivesFromReference((PdfIndirectReference)obj, actives, activeKeys);
                    break;
                }
                case 5: {
                    this.findActivesFromArray((PdfArray)obj, actives, activeKeys, activeClassMaps);
                    break;
                }
                case 6: {
                    this.findActivesFromDict((PdfDictionary)obj, actives, activeKeys, activeClassMaps);
                }
            }
        }
    }

    private void findActivesFromDict(PdfDictionary dict, ArrayList<PdfIndirectReference> actives, HashSet<RefKey> activeKeys, HashSet<PdfName> activeClassMaps) {
        if (this.containsInactivePg(dict, activeKeys)) {
            return;
        }
        for (PdfName key : dict.getKeys()) {
            PdfObject obj = dict.get(key);
            if (key.equals(PdfName.P)) continue;
            if (key.equals(PdfName.C)) {
                if (obj.isArray()) {
                    for (PdfObject cm : (PdfArray)obj) {
                        if (!cm.isName()) continue;
                        activeClassMaps.add((PdfName)cm);
                    }
                    continue;
                }
                if (!obj.isName()) continue;
                activeClassMaps.add((PdfName)obj);
                continue;
            }
            switch (obj.type()) {
                case 0: {
                    this.findActivesFromReference((PdfIndirectReference)obj, actives, activeKeys);
                    break;
                }
                case 5: {
                    this.findActivesFromArray((PdfArray)obj, actives, activeKeys, activeClassMaps);
                    break;
                }
                case 6: {
                    this.findActivesFromDict((PdfDictionary)obj, actives, activeKeys, activeClassMaps);
                }
            }
        }
    }

    protected void flushIndirectObjects() throws IOException {
        for (PdfIndirectObject iobj : this.savedObjects) {
            this.indirectObjects.remove(new RefKey(iobj.number, iobj.generation));
        }
        HashSet<RefKey> inactives = new HashSet<RefKey>();
        for (Map.Entry<RefKey, PdfIndirectObject> entry : this.indirectObjects.entrySet()) {
            if (entry.getValue() != null) {
                this.body.write(entry.getValue(), entry.getValue().number);
                continue;
            }
            inactives.add(entry.getKey());
        }
        ArrayList<PdfWriter.PdfBody.PdfCrossReference> pdfCrossReferences = new ArrayList<PdfWriter.PdfBody.PdfCrossReference>(this.body.xrefs);
        for (PdfWriter.PdfBody.PdfCrossReference cr : pdfCrossReferences) {
            RefKey key = new RefKey(cr.getRefnum(), 0);
            if (!inactives.contains(key)) continue;
            this.body.xrefs.remove(cr);
        }
        this.indirectObjects = null;
    }

    public void copyAcroForm(PdfReader reader) throws IOException, BadPdfFormatException {
        PdfIndirectReference myRef;
        this.setFromReader(reader);
        PdfDictionary catalog = reader.getCatalog();
        PRIndirectReference hisRef = null;
        PdfObject o = catalog.get(PdfName.ACROFORM);
        if (o != null && o.type() == 10) {
            hisRef = (PRIndirectReference)o;
        }
        if (hisRef == null) {
            return;
        }
        RefKey key = new RefKey(hisRef);
        IndirectReferences iRef = this.indirects.get(key);
        if (iRef != null) {
            this.acroForm = myRef = iRef.getRef();
        } else {
            this.acroForm = myRef = this.body.getPdfIndirectReference();
            iRef = new IndirectReferences(myRef);
            this.indirects.put(key, iRef);
        }
        if (!iRef.getCopied()) {
            iRef.setCopied();
            PdfDictionary theForm = this.copyDictionary((PdfDictionary)PdfReader.getPdfObject(hisRef));
            this.addToBody((PdfObject)theForm, myRef);
        }
    }

    @Override
    protected PdfDictionary getCatalog(PdfIndirectReference rootObj) {
        try {
            PdfDocument.PdfCatalog theCat = this.pdf.getCatalog(rootObj);
            this.buildStructTreeRootForTagged(theCat);
            if (this.fieldArray == null) {
                if (this.acroForm != null) {
                    theCat.put(PdfName.ACROFORM, this.acroForm);
                }
            } else {
                this.addFieldResources(theCat);
            }
            return theCat;
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    protected boolean isStructTreeRootReference(PdfIndirectReference prRef) {
        if (prRef == null || this.structTreeRootReference == null) {
            return false;
        }
        return prRef.number == this.structTreeRootReference.number && prRef.generation == this.structTreeRootReference.generation;
    }

    private void addFieldResources(PdfDictionary catalog) throws IOException {
        PdfDictionary dic;
        if (this.fieldArray == null) {
            return;
        }
        PdfDictionary acroForm = new PdfDictionary();
        catalog.put(PdfName.ACROFORM, acroForm);
        acroForm.put(PdfName.FIELDS, this.fieldArray);
        acroForm.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
        if (this.fieldTemplates.isEmpty()) {
            return;
        }
        PdfDictionary dr = new PdfDictionary();
        acroForm.put(PdfName.DR, dr);
        for (PdfTemplate template : this.fieldTemplates) {
            PdfFormField.mergeResources(dr, (PdfDictionary)template.getResources());
        }
        PdfDictionary fonts = dr.getAsDict(PdfName.FONT);
        if (fonts == null) {
            fonts = new PdfDictionary();
            dr.put(PdfName.FONT, fonts);
        }
        if (!fonts.contains(PdfName.HELV)) {
            dic = new PdfDictionary(PdfName.FONT);
            dic.put(PdfName.BASEFONT, PdfName.HELVETICA);
            dic.put(PdfName.ENCODING, PdfName.WIN_ANSI_ENCODING);
            dic.put(PdfName.NAME, PdfName.HELV);
            dic.put(PdfName.SUBTYPE, PdfName.TYPE1);
            fonts.put(PdfName.HELV, this.addToBody(dic).getIndirectReference());
        }
        if (!fonts.contains(PdfName.ZADB)) {
            dic = new PdfDictionary(PdfName.FONT);
            dic.put(PdfName.BASEFONT, PdfName.ZAPFDINGBATS);
            dic.put(PdfName.NAME, PdfName.ZADB);
            dic.put(PdfName.SUBTYPE, PdfName.TYPE1);
            fonts.put(PdfName.ZADB, this.addToBody(dic).getIndirectReference());
        }
    }

    @Override
    public void close() {
        if (this.open) {
            PdfReaderInstance ri = this.currentPdfReaderInstance;
            this.pdf.close();
            super.close();
        }
    }

    public PdfIndirectReference add(PdfOutline outline) {
        return null;
    }

    @Override
    public void addAnnotation(PdfAnnotation annot) {
    }

    @Override
    PdfIndirectReference add(PdfPage page, PdfContents contents) throws PdfException {
        return null;
    }

    @Override
    public void freeReader(PdfReader reader) throws IOException {
        this.indirectMap.remove(reader);
        this.currentPdfReaderInstance = null;
        super.freeReader(reader);
    }

    public PageStamp createPageStamp(PdfImportedPage iPage) {
        int pageNum = iPage.getPageNumber();
        PdfReader reader = iPage.getPdfReaderInstance().getReader();
        PdfDictionary pageN = reader.getPageN(pageNum);
        return new PageStamp(reader, pageN, this);
    }

    public static class StampContent
    extends PdfContentByte {
        PageResources pageResources;

        StampContent(PdfWriter writer, PageResources pageResources) {
            super(writer);
            this.pageResources = pageResources;
        }

        public PdfContentByte getDuplicate() {
            return new StampContent(this.writer, this.pageResources);
        }

        PageResources getPageResources() {
            return this.pageResources;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PageStamp {
        PdfDictionary pageN;
        StampContent under;
        StampContent over;
        PageResources pageResources;
        PdfReader reader;
        PdfCopy cstp;

        PageStamp(PdfReader reader, PdfDictionary pageN, PdfCopy cstp) {
            this.pageN = pageN;
            this.reader = reader;
            this.cstp = cstp;
        }

        public PdfContentByte getUnderContent() {
            if (this.under == null) {
                if (this.pageResources == null) {
                    this.pageResources = new PageResources();
                    PdfDictionary resources = this.pageN.getAsDict(PdfName.RESOURCES);
                    this.pageResources.setOriginalResources(resources, this.cstp.namePtr);
                }
                this.under = new StampContent(this.cstp, this.pageResources);
            }
            return this.under;
        }

        public PdfContentByte getOverContent() {
            if (this.over == null) {
                if (this.pageResources == null) {
                    this.pageResources = new PageResources();
                    PdfDictionary resources = this.pageN.getAsDict(PdfName.RESOURCES);
                    this.pageResources.setOriginalResources(resources, this.cstp.namePtr);
                }
                this.over = new StampContent(this.cstp, this.pageResources);
            }
            return this.over;
        }

        public void alterContents() throws IOException {
            if (this.over == null && this.under == null) {
                return;
            }
            PdfArray ar = null;
            PdfObject content = PdfReader.getPdfObject(this.pageN.get(PdfName.CONTENTS), this.pageN);
            if (content == null) {
                ar = new PdfArray();
                this.pageN.put(PdfName.CONTENTS, ar);
            } else if (content.isArray()) {
                ar = (PdfArray)content;
            } else if (content.isStream()) {
                ar = new PdfArray();
                ar.add(this.pageN.get(PdfName.CONTENTS));
                this.pageN.put(PdfName.CONTENTS, ar);
            } else {
                ar = new PdfArray();
                this.pageN.put(PdfName.CONTENTS, ar);
            }
            ByteBuffer out = new ByteBuffer();
            if (this.under != null) {
                out.append(PdfContents.SAVESTATE);
                this.applyRotation(this.pageN, out);
                out.append(this.under.getInternalBuffer());
                out.append(PdfContents.RESTORESTATE);
            }
            if (this.over != null) {
                out.append(PdfContents.SAVESTATE);
            }
            PdfStream stream = new PdfStream(out.toByteArray());
            stream.flateCompress(this.cstp.getCompressionLevel());
            PdfIndirectReference ref1 = this.cstp.addToBody(stream).getIndirectReference();
            ar.addFirst(ref1);
            out.reset();
            if (this.over != null) {
                out.append(' ');
                out.append(PdfContents.RESTORESTATE);
                out.append(PdfContents.SAVESTATE);
                this.applyRotation(this.pageN, out);
                out.append(this.over.getInternalBuffer());
                out.append(PdfContents.RESTORESTATE);
                stream = new PdfStream(out.toByteArray());
                stream.flateCompress(this.cstp.getCompressionLevel());
                ar.add(this.cstp.addToBody(stream).getIndirectReference());
            }
            this.pageN.put(PdfName.RESOURCES, this.pageResources.getResources());
        }

        void applyRotation(PdfDictionary pageN, ByteBuffer out) {
            if (!this.cstp.rotateContents) {
                return;
            }
            Rectangle page = this.reader.getPageSizeWithRotation(pageN);
            int rotation = page.getRotation();
            switch (rotation) {
                case 90: {
                    out.append(PdfContents.ROTATE90);
                    out.append(page.getTop());
                    out.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                    break;
                }
                case 180: {
                    out.append(PdfContents.ROTATE180);
                    out.append(page.getRight());
                    out.append(' ');
                    out.append(page.getTop());
                    out.append(PdfContents.ROTATEFINAL);
                    break;
                }
                case 270: {
                    out.append(PdfContents.ROTATE270);
                    out.append('0').append(' ');
                    out.append(page.getRight());
                    out.append(PdfContents.ROTATEFINAL);
                }
            }
        }

        private void addDocumentField(PdfIndirectReference ref) {
            if (this.cstp.fieldArray == null) {
                this.cstp.fieldArray = new PdfArray();
            }
            this.cstp.fieldArray.add(ref);
        }

        private void expandFields(PdfFormField field, ArrayList<PdfAnnotation> allAnnots) {
            allAnnots.add(field);
            ArrayList<PdfFormField> kids = field.getKids();
            if (kids != null) {
                for (PdfFormField f : kids) {
                    this.expandFields(f, allAnnots);
                }
            }
        }

        public void addAnnotation(PdfAnnotation annot) {
            try {
                ArrayList<PdfAnnotation> allAnnots = new ArrayList<PdfAnnotation>();
                if (annot.isForm()) {
                    PdfFormField field = (PdfFormField)annot;
                    if (field.getParent() != null) {
                        return;
                    }
                    this.expandFields(field, allAnnots);
                    if (this.cstp.fieldTemplates == null) {
                        this.cstp.fieldTemplates = new HashSet();
                    }
                } else {
                    allAnnots.add(annot);
                }
                for (int k = 0; k < allAnnots.size(); ++k) {
                    annot = allAnnots.get(k);
                    if (annot.isForm()) {
                        PdfFormField field;
                        HashSet<PdfTemplate> templates;
                        if (!annot.isUsed() && (templates = annot.getTemplates()) != null) {
                            this.cstp.fieldTemplates.addAll(templates);
                        }
                        if ((field = (PdfFormField)annot).getParent() == null) {
                            this.addDocumentField(field.getIndirectReference());
                        }
                    }
                    if (annot.isAnnotation()) {
                        PdfRectangle rect;
                        PdfObject pdfobj = PdfReader.getPdfObject(this.pageN.get(PdfName.ANNOTS), this.pageN);
                        PdfArray annots = null;
                        if (pdfobj == null || !pdfobj.isArray()) {
                            annots = new PdfArray();
                            this.pageN.put(PdfName.ANNOTS, annots);
                        } else {
                            annots = (PdfArray)pdfobj;
                        }
                        annots.add(annot.getIndirectReference());
                        if (!(annot.isUsed() || (rect = (PdfRectangle)annot.get(PdfName.RECT)) == null || rect.left() == 0.0f && rect.right() == 0.0f && rect.top() == 0.0f && rect.bottom() == 0.0f)) {
                            int rotation = this.reader.getPageRotation(this.pageN);
                            Rectangle pageSize = this.reader.getPageSizeWithRotation(this.pageN);
                            switch (rotation) {
                                case 90: {
                                    annot.put(PdfName.RECT, new PdfRectangle(pageSize.getTop() - rect.bottom(), rect.left(), pageSize.getTop() - rect.top(), rect.right()));
                                    break;
                                }
                                case 180: {
                                    annot.put(PdfName.RECT, new PdfRectangle(pageSize.getRight() - rect.left(), pageSize.getTop() - rect.bottom(), pageSize.getRight() - rect.right(), pageSize.getTop() - rect.top()));
                                    break;
                                }
                                case 270: {
                                    annot.put(PdfName.RECT, new PdfRectangle(rect.bottom(), pageSize.getRight() - rect.left(), rect.top(), pageSize.getRight() - rect.right()));
                                }
                            }
                        }
                    }
                    if (annot.isUsed()) continue;
                    annot.setUsed();
                    this.cstp.addToBody((PdfObject)annot, annot.getIndirectReference());
                }
            }
            catch (IOException e) {
                throw new ExceptionConverter(e);
            }
        }
    }

    protected static class ImportedPage {
        int pageNumber;
        PdfReader reader;

        ImportedPage(PdfReader reader, int pageNumber) {
            this.pageNumber = pageNumber;
            this.reader = reader;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImportedPage)) {
                return false;
            }
            ImportedPage other = (ImportedPage)o;
            return this.pageNumber == other.pageNumber && this.reader.equals(this.reader);
        }

        public String toString() {
            return Integer.toString(this.pageNumber);
        }
    }

    protected static class RefKey {
        int num;
        int gen;

        RefKey(int num, int gen) {
            this.num = num;
            this.gen = gen;
        }

        RefKey(PdfIndirectReference ref) {
            this.num = ref.getNumber();
            this.gen = ref.getGeneration();
        }

        RefKey(PRIndirectReference ref) {
            this.num = ref.getNumber();
            this.gen = ref.getGeneration();
        }

        public int hashCode() {
            return (this.gen << 16) + this.num;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RefKey)) {
                return false;
            }
            RefKey other = (RefKey)o;
            return this.gen == other.gen && this.num == other.num;
        }

        public String toString() {
            return Integer.toString(this.num) + ' ' + this.gen;
        }
    }

    static class IndirectReferences {
        PdfIndirectReference theRef;
        boolean hasCopied;

        IndirectReferences(PdfIndirectReference ref) {
            this.theRef = ref;
            this.hasCopied = false;
        }

        void setCopied() {
            this.hasCopied = true;
        }

        void setNotCopied() {
            this.hasCopied = false;
        }

        boolean getCopied() {
            return this.hasCopied;
        }

        PdfIndirectReference getRef() {
            return this.theRef;
        }

        public String toString() {
            String ext = "";
            if (this.hasCopied) {
                ext = ext + " Copied";
            }
            return this.getRef() + ext;
        }
    }
}

