/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.utils.inflector;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EnglishInflector {
    public static String pluralize(String word) {
        if (word == null) {
            return null;
        }
        Map rules = EnglishInflector.getPluralRules();
        Iterator ruleIterator = rules.entrySet().iterator();
        while (ruleIterator.hasNext()) {
            Map.Entry rule = ruleIterator.next();
            String pattern = rule.getKey().toString();
            String replace = rule.getValue().toString();
            if (!word.matches(pattern)) continue;
            return word.replaceFirst(pattern, replace);
        }
        return word.replaceFirst("([\\w]+)([^s])$", "$1$2s");
    }

    private static Map getPluralRules() {
        HashMap<String, String> rules = new HashMap<String, String>();
        rules.put("(\\w+)(x|ch|ss|sh)$", "$1$2es");
        rules.put("(\\w+)([^aeiou])y$", "$1$2ies");
        rules.put("(\\w*)(f)$", "$1ves");
        rules.put("(\\w*)(fe)$", "$1ves");
        rules.put("(\\w+)(sis)$", "$1ses");
        rules.put("(\\w*)person$", "$1people");
        rules.put("(\\w*)child$", "$1children");
        rules.put("(\\w*)series$", "$1series");
        rules.put("(\\w*)foot$", "$1feet");
        rules.put("(\\w*)tooth$", "$1teeth");
        rules.put("(\\w*)bus$", "$1buses");
        rules.put("(\\w*)man$", "$1men");
        return rules;
    }

    public static String singularize(String word) {
        if (word == null) {
            return null;
        }
        Map rules = EnglishInflector.getSingularRules();
        Iterator ruleIterator = rules.entrySet().iterator();
        while (ruleIterator.hasNext()) {
            Map.Entry rule = ruleIterator.next();
            String pattern = rule.getKey().toString();
            String replace = rule.getValue().toString();
            if (!word.matches(pattern)) continue;
            return word.replaceFirst(pattern, replace);
        }
        return word.replaceFirst("([\\w]+)s$", "$1");
    }

    private static Map getSingularRules() {
        HashMap<String, String> rules = new HashMap<String, String>();
        rules.put("(\\w+)(x|ch|ss)es$", "$1$2");
        rules.put("(\\w+)([^aeiou])ies", "$1$2y");
        rules.put("(\\w+)([^l])ves", "$1$2fe");
        rules.put("(\\w+)([ll])ves", "$1$2f");
        rules.put("(\\w+)(ses)$", "$1sis");
        rules.put("(\\w*)people$", "$1person");
        rules.put("(\\w*)children$", "$1child");
        rules.put("(\\w*)series$", "$1series");
        rules.put("(\\w*)feet$", "$1foot");
        rules.put("(\\w*)teeth$", "$1tooth");
        rules.put("(\\w*)buses$", "$1bus");
        rules.put("(\\w*)men$", "$1man");
        return rules;
    }
}

