/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.translation.ocl.syntax;

import org.andromda.core.translation.TranslationUtils;

public class OCLPatterns {
    static final String SCOPE_PATH = "[\\w+|::]+";
    static final String NAVIGATIONAL_PATH = "[\\w*[\\.]*]+";
    private static final String OPERATION = ".+\\(.*\\).*";
    private static final String COLLECTION_CALL = ".+->.+";
    private static final String COLLECTION_CALL_RESULT_NAVIGATIONAL_PATH = ".+->.+\\(.*\\).*[\\w*[\\.]*]+";
    private static final String AND_OR_OR_OPERATOR = "or\\s+.*|and\\s+.*";

    public static boolean isOperation(Object expression) {
        return TranslationUtils.deleteWhitespace((Object)expression).matches(OPERATION);
    }

    public static boolean isCollectionOperationCall(Object expression) {
        return TranslationUtils.deleteWhitespace((Object)expression).matches(COLLECTION_CALL);
    }

    public static boolean isCollectionOperationResultNavigationalPath(Object expression) {
        return TranslationUtils.deleteWhitespace((Object)expression).matches(COLLECTION_CALL_RESULT_NAVIGATIONAL_PATH);
    }

    public static boolean isNavigationalPath(Object expression) {
        return TranslationUtils.deleteWhitespace((Object)expression).matches(NAVIGATIONAL_PATH);
    }

    public static boolean isAndOrOrExpression(Object expression) {
        return TranslationUtils.trimToEmpty((Object)expression).matches(AND_OR_OR_OPERATOR);
    }
}

