/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.translation.ocl.parser;

import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class OclParserException
extends RuntimeException {
    private StringBuffer messageBuffer;
    private int errorLine;
    private int errorColumn;

    public OclParserException(String message) {
        if (StringUtils.isNotEmpty((String)message)) {
            this.extractErrorPosition(message);
        }
    }

    public String getMessage() {
        String message;
        int position = 0;
        if (this.errorLine != -1) {
            message = "line: " + this.errorLine + " ";
            this.messageBuffer.insert(0, message);
            position = message.length();
        }
        if (this.errorColumn != -1) {
            message = "column: " + this.errorColumn + " ";
            this.messageBuffer.insert(position, message);
            position += message.length();
        }
        this.messageBuffer.insert(position, "--> ");
        return this.messageBuffer.toString();
    }

    private void extractErrorPosition(String message) {
        this.messageBuffer = new StringBuffer();
        if (message.charAt(0) == '[') {
            StringTokenizer tokenizer = new StringTokenizer(message.substring(1), ",]");
            try {
                this.errorLine = Integer.parseInt(tokenizer.nextToken());
                this.errorColumn = Integer.parseInt(tokenizer.nextToken());
                this.messageBuffer.append(tokenizer.nextToken("").substring(2));
            }
            catch (NumberFormatException ex) {
                this.messageBuffer.append(message);
                this.errorLine = -1;
                this.errorColumn = -1;
            }
        } else {
            this.messageBuffer.append(message);
            this.errorLine = -1;
            this.errorColumn = -1;
        }
    }
}

